/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.methodreference;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.el.api.resolver.BarELResolver;
import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.el.common.elcontext.BarELContext;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.FunctionELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.MethodsBean;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.MethodInfo;
import jakarta.el.MethodNotFoundException;
import jakarta.el.MethodReference;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.ValueExpression;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientJspTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "methodreference_jsp_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientJspTest.class.getName());
    private static final String NL = System.getProperty("line.seperator", "\n");
    private Properties testProps;

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="methodreference_jsp_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive jsp_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"methodreference_jsp_vehicle_web.war");
        jsp_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ExpressionTest.class, BarELResolver.class, ResolverTest.class, BareBonesELContext.class, SimpleELContext.class, SimpleELContext.Resolver.class, FuncMapperELContext.class, BarELContext.class, VarMapperELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, NameValuePair.class, ExprEval.class, MethodsBean.class, TCKFunctionMapper.class, EmployeeELResolver.class, VariableELResolver.class, VectELResolver.class, FunctionELResolver.class, ELClientJspTest.class});
        InputStream inStream = ELClientJspTest.class.getResourceAsStream("/vehicle/jsp/jsp_vehicle_web.xml");
        String webXml = ELClientJspTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        jsp_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        URL warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/client.html");
        jsp_vehicle_web.addAsWebResource(warResURL, "/client.html");
        warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/jsp_vehicle.jsp");
        jsp_vehicle_web.addAsWebResource(warResURL, "/jsp_vehicle.jsp");
        return jsp_vehicle_web;
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String servlet_vehicle) throws IOException {
        return ELClientJspTest.inputStreamToString(inStream).replaceAll("el_jsp_vehicle", servlet_vehicle);
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static void main(String[] args) {
        ELClientJspTest theTests = new ELClientJspTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
    }

    @AfterEach
    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="jsp")
    public void methodReferenceTest() throws EETest.Fault {
        boolean pass4;
        boolean pass3;
        boolean pass2;
        boolean pass1;
        StringBuffer buf = new StringBuffer();
        try {
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            ELContext context = new VarMapperELContext(this.testProps).getELContext();
            MethodsBean bean = new MethodsBean();
            ValueExpression ve = expFactory.createValueExpression((Object)bean, MethodsBean.class);
            context.getVariableMapper().setVariable("bean", ve);
            MethodExpression mexp1 = expFactory.createMethodExpression(context, "#{bean.targetF('aaa',1234)}", String.class, null);
            MethodInfo minfo1 = mexp1.getMethodInfo(context);
            MethodReference mref1 = mexp1.getMethodReference(context);
            pass1 = ExpressionTest.testMethodReference((MethodReference)mref1, (Object)bean, (MethodInfo)minfo1, (Class[])new Class[]{Deprecated.class}, (Object[])new Object[]{"aaa", 1234L}, (StringBuffer)buf);
            try {
                mexp1.getMethodReference(null);
                pass2 = false;
                buf.append("Did not get expected NullPointerException for null context." + NL);
            }
            catch (NullPointerException npe) {
                pass2 = true;
            }
            MethodExpression mexp3 = expFactory.createMethodExpression(context, "#{noSuchBean.method()}", String.class, null);
            try {
                mexp3.getMethodReference(context);
                pass3 = false;
                buf.append("Did not get expected PropertyNotFoundException return for unknown bean." + NL);
            }
            catch (PropertyNotFoundException pnfe) {
                pass3 = true;
            }
            MethodExpression mexp4 = expFactory.createMethodExpression(context, "#{bean.noSuchMethod()}", String.class, null);
            try {
                mexp4.getMethodReference(context);
                pass4 = false;
                buf.append("Did not get expected MethodNotFoundException return for unknown bean." + NL);
            }
            catch (MethodNotFoundException mnfe) {
                pass4 = true;
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)("Test getMethodReference threw an Exception!" + ELTestUtil.NL + "Received: " + ex.toString() + ELTestUtil.NL));
            ex.printStackTrace();
            throw new EETest.Fault((Throwable)ex);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("Test FAILED" + NL + buf.toString());
        }
    }
}

