/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.derivedid.ex6b;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.derivedid.ex6b.DID6bMedicalHistory;
import ee.jakarta.tck.persistence.core.derivedid.ex6b.DID6bPerson;
import ee.jakarta.tck.persistence.core.derivedid.ex6b.DID6bPersonId;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void DIDTest() throws Exception {
        boolean pass = false;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            DID6bPersonId personId = new DID6bPersonId("Java", "DUKE");
            DID6bPerson person = new DID6bPerson(personId, "123456789");
            DID6bMedicalHistory mHistory = new DID6bMedicalHistory(personId, person, "drFoo");
            this.getEntityManager().persist((Object)person);
            this.getEntityManager().persist((Object)mHistory);
            this.logTrace("persisted Patient and MedicalHistory");
            this.getEntityManager().flush();
            DID6bMedicalHistory newMHistory = (DID6bMedicalHistory)this.getEntityManager().find(DID6bMedicalHistory.class, (Object)personId);
            if (newMHistory != null) {
                this.getEntityManager().refresh((Object)newMHistory);
            }
            List depList = this.getEntityManager().createQuery("Select m from DID6bMedicalHistory m where m.patient.id.firstName='Java'").getResultList();
            newMHistory = null;
            if (depList.size() > 0) {
                newMHistory = (DID6bMedicalHistory)depList.get(0);
                if (newMHistory.getPatient() == person) {
                    pass1 = true;
                    this.logTrace("Received Expected Patient");
                } else {
                    this.logErr("Searched Patient not found");
                }
            }
            List depList2 = this.getEntityManager().createQuery("Select m from DID6bMedicalHistory m where m.id.firstName='Java'").getResultList();
            DID6bMedicalHistory newMHistory2 = null;
            if (depList2.size() > 0) {
                newMHistory2 = (DID6bMedicalHistory)depList.get(0);
                if (newMHistory2 != null) {
                    if (newMHistory2.getPatient() == person) {
                        pass = true;
                        this.logTrace("Received Expected Patient");
                    } else {
                        this.logErr("Searched Patient not found");
                    }
                } else {
                    this.logErr("getEntityManager().createQuery returned null entry");
                }
            } else {
                this.logErr("getEntityManager().createQuery returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            this.getEntityManager().getTransaction().rollback();
        }
        if (pass1 & pass2) {
            pass = true;
        }
        if (!pass) {
            throw new Exception("DIDTest failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID6BMEDICALHISTORY").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID6BPERSON").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

