/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.common;

import com.sun.ts.tests.jms.common.MessageTestImpl;
import jakarta.jms.JMSException;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.StreamMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;

public class StreamMessageTestImpl
extends MessageTestImpl
implements StreamMessage {
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("buf", byte[].class)};
    public static final byte BOOLEAN_TYPE = 1;
    public static final byte BYTE_TYPE = 2;
    public static final byte CHAR_TYPE = 3;
    public static final byte DOUBLE_TYPE = 4;
    public static final byte FLOAT_TYPE = 5;
    public static final byte INT_TYPE = 6;
    public static final byte LONG_TYPE = 7;
    public static final byte SHORT_TYPE = 8;
    public static final byte STRING_TYPE = 9;
    public static final byte BYTES_TYPE = 10;
    byte[] buf = new byte[0];
    transient ByteArrayInputStream bais;
    transient ByteArrayOutputStream baos;
    transient DataInputStream dis;
    transient DataOutputStream dos;
    private boolean first_time_readBytes = true;
    private int available_bytes = 0;

    public StreamMessageTestImpl() {
        this.init();
    }

    private void init() {
        this.baos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.baos);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.dos.flush();
        this.buf = this.baos.toByteArray();
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.baos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.baos);
        if (this.buf != null) {
            this.dos.write(this.buf);
            this.buf = null;
        }
    }

    private byte getType() throws IOException {
        return this.dis.readByte();
    }

    private int getBytesLength() throws IOException {
        return this.dis.readInt();
    }

    public boolean readBoolean() throws JMSException {
        boolean ret = false;
        this.checkReadAccess();
        try {
            byte type = this.getType();
            switch (type) {
                case 1: {
                    ret = this.dis.readBoolean();
                    break;
                }
                case 9: {
                    String s = this.dis.readUTF();
                    ret = Boolean.valueOf(s);
                    break;
                }
                default: {
                    throw new MessageFormatException("type conversion is invalid");
                }
            }
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public byte readByte() throws JMSException {
        byte ret = 0;
        this.checkReadAccess();
        try {
            byte type = this.getType();
            switch (type) {
                case 2: {
                    ret = this.dis.readByte();
                    break;
                }
                case 9: {
                    String s = this.dis.readUTF();
                    ret = Byte.valueOf(s);
                    break;
                }
                default: {
                    throw new MessageFormatException("type conversion is invalid");
                }
            }
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public short readShort() throws JMSException {
        short ret = 0;
        this.checkReadAccess();
        try {
            byte type = this.getType();
            switch (type) {
                case 2: {
                    ret = this.dis.readByte();
                    break;
                }
                case 8: {
                    ret = this.dis.readShort();
                    break;
                }
                case 9: {
                    String s = this.dis.readUTF();
                    ret = Short.valueOf(s);
                    break;
                }
                default: {
                    throw new MessageFormatException("type conversion is invalid");
                }
            }
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public char readChar() throws JMSException {
        char ret = '\u0000';
        this.checkReadAccess();
        try {
            byte type = this.getType();
            switch (type) {
                case 3: {
                    ret = this.dis.readChar();
                    break;
                }
                case 9: {
                    String s = this.dis.readUTF();
                    ret = s.charAt(0);
                    break;
                }
                default: {
                    throw new MessageFormatException("type conversion is invalid");
                }
            }
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public int readInt() throws JMSException {
        int ret = 0;
        this.checkReadAccess();
        try {
            byte type = this.getType();
            switch (type) {
                case 2: {
                    ret = this.dis.readByte();
                    break;
                }
                case 8: {
                    ret = this.dis.readShort();
                    break;
                }
                case 6: {
                    ret = this.dis.readInt();
                    break;
                }
                case 9: {
                    String s = this.dis.readUTF();
                    ret = Integer.valueOf(s);
                    break;
                }
                default: {
                    throw new MessageFormatException("type conversion is invalid");
                }
            }
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public long readLong() throws JMSException {
        long ret = 0L;
        this.checkReadAccess();
        try {
            byte type = this.getType();
            switch (type) {
                case 2: {
                    ret = this.dis.readByte();
                    break;
                }
                case 8: {
                    ret = this.dis.readShort();
                    break;
                }
                case 6: {
                    ret = this.dis.readInt();
                    break;
                }
                case 7: {
                    ret = this.dis.readLong();
                    break;
                }
                case 9: {
                    String s = this.dis.readUTF();
                    ret = Long.valueOf(s);
                    break;
                }
                default: {
                    throw new MessageFormatException("type conversion is invalid");
                }
            }
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public float readFloat() throws JMSException {
        float ret = 0.0f;
        this.checkReadAccess();
        try {
            byte type = this.getType();
            switch (type) {
                case 5: {
                    ret = this.dis.readFloat();
                    break;
                }
                case 9: {
                    String s = this.dis.readUTF();
                    ret = Float.valueOf(s).floatValue();
                    break;
                }
                default: {
                    throw new MessageFormatException("type conversion is invalid");
                }
            }
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public double readDouble() throws JMSException {
        double ret = 0.0;
        this.checkReadAccess();
        try {
            byte type = this.getType();
            switch (type) {
                case 5: {
                    ret = this.dis.readFloat();
                    break;
                }
                case 4: {
                    ret = this.dis.readDouble();
                    break;
                }
                case 9: {
                    String s = this.dis.readUTF();
                    ret = Double.valueOf(s);
                    break;
                }
                default: {
                    throw new MessageFormatException("type conversion is invalid");
                }
            }
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public String readString() throws JMSException {
        String ret = null;
        this.checkReadAccess();
        try {
            byte type = this.getType();
            switch (type) {
                case 1: {
                    ret = String.valueOf(this.dis.readBoolean());
                    break;
                }
                case 2: {
                    ret = String.valueOf(this.dis.readByte());
                    break;
                }
                case 8: {
                    ret = String.valueOf(this.dis.readShort());
                    break;
                }
                case 3: {
                    ret = String.valueOf(this.dis.readChar());
                    break;
                }
                case 6: {
                    ret = String.valueOf(this.dis.readInt());
                    break;
                }
                case 7: {
                    ret = String.valueOf(this.dis.readLong());
                    break;
                }
                case 5: {
                    ret = String.valueOf(this.dis.readFloat());
                    break;
                }
                case 4: {
                    ret = String.valueOf(this.dis.readDouble());
                    break;
                }
                case 9: {
                    ret = this.dis.readUTF();
                    break;
                }
                default: {
                    throw new MessageFormatException("type conversion is invalid");
                }
            }
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public int readBytes(byte[] value) throws JMSException {
        int ret = -1;
        this.checkReadAccess();
        try {
            int type = 10;
            if (this.first_time_readBytes) {
                type = this.getType();
                this.available_bytes = this.getBytesLength();
            }
            switch (type) {
                case 10: {
                    if (this.first_time_readBytes && this.available_bytes == 0) {
                        return 0;
                    }
                    if (!this.first_time_readBytes && this.available_bytes == 0) {
                        return -1;
                    }
                    if (value.length > this.available_bytes) {
                        ret = this.dis.read(value, 0, this.available_bytes);
                        this.available_bytes = 0;
                        this.first_time_readBytes = true;
                        break;
                    }
                    if (value.length <= this.available_bytes) {
                        ret = this.dis.read(value, 0, value.length);
                        this.available_bytes -= value.length;
                        this.first_time_readBytes = false;
                    }
                    break;
                }
                default: {
                    throw new MessageFormatException("type conversion is invalid");
                }
            }
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public Object readObject() throws JMSException {
        Object ret = null;
        this.checkReadAccess();
        try {
            byte type = this.getType();
            switch (type) {
                case 1: {
                    ret = this.dis.readBoolean();
                    break;
                }
                case 2: {
                    ret = this.dis.readByte();
                    break;
                }
                case 8: {
                    ret = this.dis.readShort();
                    break;
                }
                case 3: {
                    ret = Character.valueOf(this.dis.readChar());
                    break;
                }
                case 6: {
                    ret = this.dis.readInt();
                    break;
                }
                case 7: {
                    ret = this.dis.readLong();
                    break;
                }
                case 5: {
                    ret = Float.valueOf(this.dis.readFloat());
                    break;
                }
                case 4: {
                    ret = this.dis.readDouble();
                    break;
                }
                case 9: {
                    ret = this.dis.readUTF();
                    break;
                }
                default: {
                    throw new MessageFormatException("type conversion is invalid");
                }
            }
        }
        catch (EOFException e1) {
            throw new MessageEOFException("at end of message");
        }
        catch (IOException e2) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e2);
            throw jmsEx;
        }
        return ret;
    }

    public void writeBoolean(boolean value) throws JMSException {
        try {
            this.dos.writeByte(1);
            this.dos.writeBoolean(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeByte(byte value) throws JMSException {
        try {
            this.dos.writeByte(2);
            this.dos.writeByte(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeShort(short value) throws JMSException {
        try {
            this.dos.writeByte(8);
            this.dos.writeShort(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeChar(char value) throws JMSException {
        try {
            this.dos.writeByte(3);
            this.dos.writeChar(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeInt(int value) throws JMSException {
        try {
            this.dos.writeByte(6);
            this.dos.writeInt(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeLong(long value) throws JMSException {
        try {
            this.dos.writeByte(7);
            this.dos.writeLong(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeFloat(float value) throws JMSException {
        try {
            this.dos.writeByte(5);
            this.dos.writeFloat(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeDouble(double value) throws JMSException {
        try {
            this.dos.writeByte(4);
            this.dos.writeDouble(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeString(String value) throws JMSException {
        try {
            this.dos.writeByte(9);
            this.dos.writeUTF(value);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.writeBytes(value, 0, value.length);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        try {
            this.dos.writeByte(10);
            this.dos.writeInt(length);
            this.dos.write(value, offset, length);
            this.setBufferIsDirty(true);
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Invalid type");
        }
    }

    public void reset() throws JMSException {
        try {
            if (this.bufferIsDirty) {
                this.dos.flush();
                this.dos.close();
                this.baos.close();
            }
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException");
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        if (this.baos != null) {
            this.buf = this.baos.toByteArray();
        } else if (this.buf == null) {
            this.buf = new byte[0];
        }
        this.bais = new ByteArrayInputStream(this.buf);
        this.dis = new DataInputStream(this.bais);
        this.first_time_readBytes = true;
        this.setBufferIsDirty(false);
        this.readMode = true;
    }

    @Override
    public void clearBody() throws JMSException {
        this.buf = null;
        this.bais = null;
        this.dis = null;
        this.readMode = false;
    }
}

