/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.resourceDefs.ejb;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.BASE64Encoder;
import com.sun.ts.lib.util.TestUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;

public class Client
extends ServiceEETest
implements Serializable {
    private Properties props = null;
    private String hostname = null;
    private int portnum = 0;
    private String contextPath = "/conn_resourcedefs_web";
    private String crdServletPath = this.contextPath + "/CRDTestServlet";
    private String aodServletPath = this.contextPath + "/AODTestServlet";
    private String username = "";
    private String password = "";
    private String appContextHostname;
    private String RARGlobalScopedJndiName = "java:global/env/EJBTestServlet_Global_ConnectorResource";
    private String RARModuleScopedJndiName = "java:module/env/EJBTestServlet_Module_ConnectorResource";
    private String RARCompScopedJndiName = "java:comp/env/EJBTestServlet_Comp_ConnectorResource";
    private String RARAppScopedJndiName = "java:app/env/EJBTestServlet_App_ConnectorResource";
    private String AODGlobalScopedJndiName = "java:global/env/EJBAdminObjectForGlobalScope";
    private String AODModuleScopedJndiName = "java:module/env/EJBAdminObjectForModuleScope";
    private String AODCompScopedJndiName = "java:comp/env/EJBAdminObjectForCompScope";
    private String AODAppScopedJndiName = "java:app/env/EJBAdminObjectForAppScope";
    private String servletAppContext = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
        try {
            this.hostname = p.getProperty("webServerHost");
            this.portnum = Integer.parseInt(p.getProperty("webServerPort"));
            this.username = p.getProperty("user");
            this.password = p.getProperty("password");
            this.appContextHostname = p.getProperty("logical.hostname.servlet");
            TestUtil.logMsg((String)("setup(): appContextHostname = " + this.appContextHostname));
            TestUtil.logMsg((String)("setup(): servletAppContext = " + this.servletAppContext));
        }
        catch (Exception e) {
            this.logErr("Error: got exception: ", e);
        }
    }

    public void cleanup() throws Exception {
    }

    public void ValidateGlobalResourceDef() throws Exception {
        String strMsg1 = "SUCCESS:  validateGlobalResourceDef passed.";
        String str = this.invokeServletAndGetResponse(this.crdServletPath, "POST", "ValidateGlobalResourceDef", this.RARGlobalScopedJndiName);
        TestUtil.logMsg((String)("ValidateGlobalResourceDef : str = " + str));
        int ii = str.indexOf(strMsg1);
        if (ii < 0) {
            throw new Exception("ValidateGlobalResourceDef : FAILED");
        }
        TestUtil.logMsg((String)"ValidateGlobalResourceDef : PASSED");
    }

    public void ValidateAppResourceDef() throws Exception {
        String strMsg1 = "SUCCESS:  validateAppResourceDef passed.";
        String str = this.invokeServletAndGetResponse(this.crdServletPath, "POST", "ValidateAppResourceDef", this.RARAppScopedJndiName);
        TestUtil.logMsg((String)("ValidateAppResourceDef : str = " + str));
        int ii = str.indexOf(strMsg1);
        if (ii < 0) {
            throw new Exception("ValidateAppResourceDef : FAILED");
        }
        TestUtil.logMsg((String)"ValidateAppResourceDef : PASSED");
    }

    public void ValidateModuleResourceDef() throws Exception {
        String strMsg1 = "SUCCESS:  validateModuleResourceDef passed.";
        String str = this.invokeServletAndGetResponse(this.crdServletPath, "POST", "ValidateModuleResourceDef", this.RARModuleScopedJndiName);
        TestUtil.logMsg((String)("ValidateModuleResourceDef : str = " + str));
        int ii = str.indexOf(strMsg1);
        if (ii < 0) {
            throw new Exception("ValidateModuleResourceDef : FAILED");
        }
        TestUtil.logMsg((String)"ValidateModuleResourceDef : PASSED");
    }

    public void ValidateCompResourceDef() throws Exception {
        String strMsg1 = "SUCCESS:  validateCompResourceDef passed.";
        String str = this.invokeServletAndGetResponse(this.crdServletPath, "POST", "ValidateCompResourceDef", this.RARCompScopedJndiName);
        TestUtil.logMsg((String)("ValidateCompResourceDef : str = " + str));
        int ii = str.indexOf(strMsg1);
        if (ii < 0) {
            throw new Exception("ValidateCompResourceDef : FAILED");
        }
        TestUtil.logMsg((String)"ValidateCompResourceDef : PASSED");
    }

    public void ValidateGlobalAdminObj() throws Exception {
        String strMsg1 = "SUCCESS:  validateGlobalAdminObj passed.";
        String str = this.invokeServletAndGetResponse(this.aodServletPath, "POST", "ValidateGlobalAdminObj", this.AODGlobalScopedJndiName);
        TestUtil.logMsg((String)("ValidateGlobalAdminObj : str = " + str));
        int ii = str.indexOf(strMsg1);
        if (ii < 0) {
            throw new Exception("ValidateGlobalAdminObj : FAILED");
        }
        TestUtil.logMsg((String)"ValidateGlobalAdminObj : PASSED");
    }

    public void ValidateAppAdminObj() throws Exception {
        String strMsg1 = "SUCCESS:  validateAppAdminObj passed.";
        String str = this.invokeServletAndGetResponse(this.aodServletPath, "POST", "ValidateAppAdminObj", this.AODAppScopedJndiName);
        TestUtil.logMsg((String)("ValidateAppAdminObj : str = " + str));
        int ii = str.indexOf(strMsg1);
        if (ii < 0) {
            throw new Exception("ValidateAppAdminObj : FAILED");
        }
        TestUtil.logMsg((String)"ValidateAppAdminObj : PASSED");
    }

    public void ValidateModuleAdminObj() throws Exception {
        String strMsg1 = "SUCCESS:  validateModuleAdminObj passed.";
        String str = this.invokeServletAndGetResponse(this.aodServletPath, "POST", "ValidateModuleAdminObj", this.AODModuleScopedJndiName);
        TestUtil.logMsg((String)("ValidateModuleAdminObj : str = " + str));
        int ii = str.indexOf(strMsg1);
        if (ii < 0) {
            throw new Exception("ValidateModuleAdminObj : FAILED");
        }
        TestUtil.logMsg((String)"ValidateModuleAdminObj : PASSED");
    }

    public void ValidateCompAdminObj() throws Exception {
        String strMsg1 = "SUCCESS:  validateCompAdminObj passed.";
        String str = this.invokeServletAndGetResponse(this.aodServletPath, "POST", "ValidateCompAdminObj", this.AODCompScopedJndiName);
        TestUtil.logMsg((String)("ValidateCompAdminObj : str = " + str));
        int ii = str.indexOf(strMsg1);
        if (ii < 0) {
            throw new Exception("ValidateCompAdminObj : FAILED");
        }
        TestUtil.logMsg((String)"ValidateCompAdminObj : PASSED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int invokeServlet(String sContext, String requestMethod) {
        int code = 200;
        TSURL ctsurl = new TSURL();
        if (!((String)sContext).startsWith("/")) {
            sContext = "/" + (String)sContext;
        }
        String url = ctsurl.getURLString("http", this.hostname, this.portnum, (String)sContext);
        try {
            URL newURL = new URL(url);
            String authData = this.username + ":" + this.password;
            TestUtil.logMsg((String)("authData : " + authData));
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            TestUtil.logMsg((String)("encoded authData : " + encodedAuthData));
            HttpURLConnection conn = (HttpURLConnection)newURL.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            conn.setRequestMethod(requestMethod);
            conn.connect();
            TestUtil.logMsg((String)("called HttpURLConnection.connect() for url: " + url));
            code = conn.getResponseCode();
            TestUtil.logMsg((String)("Got response code of: " + code));
            String str = conn.getResponseMessage();
            TestUtil.logMsg((String)("Got response string of: " + str));
            InputStream content = conn.getInputStream();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(content));){
                String line;
                while ((line = in.readLine()) != null) {
                    TestUtil.logMsg((String)line);
                }
            }
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Abnormal return status encountered while invoking " + (String)sContext));
            TestUtil.logMsg((String)("Exception Message was:  " + e.getMessage()));
        }
        return code;
    }

    private String invokeServletAndGetResponse(String sContext, String requestMethod) {
        return this.invokeServletAndGetResponse(sContext, requestMethod, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String invokeServletAndGetResponse(String sContext, String requestMethod, String testMethod, String rarJndiScope) {
        TSURL ctsurl = new TSURL();
        if (!((String)sContext).startsWith("/")) {
            sContext = "/" + (String)sContext;
        }
        if (rarJndiScope == null) {
            rarJndiScope = "NO_VAL_SET";
            TestUtil.logMsg((String)("rarJndiScope ws null so setting to " + rarJndiScope));
        }
        if (testMethod != null) {
            sContext = (String)sContext + "?method.under.test=" + testMethod + "&rar.jndi.scope=" + rarJndiScope;
        }
        TestUtil.logMsg((String)("sContext = " + (String)sContext));
        TestUtil.logMsg((String)("passing to servlet:  testMethod = " + testMethod));
        String url = ctsurl.getURLString("http", this.hostname, this.portnum, (String)sContext);
        Object retVal = null;
        try {
            URL newURL = new URL(url);
            String authData = this.username + ":" + this.password;
            TestUtil.logMsg((String)("authData : " + authData));
            BASE64Encoder encoder = new BASE64Encoder();
            String encodedAuthData = encoder.encode(authData.getBytes());
            TestUtil.logMsg((String)("encoded authData : " + encodedAuthData));
            HttpURLConnection conn = (HttpURLConnection)newURL.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Authorization", "Basic " + encodedAuthData.trim());
            conn.setRequestMethod(requestMethod);
            conn.connect();
            TestUtil.logMsg((String)("called HttpURLConnection.connect() for url: " + url));
            retVal = conn.getResponseMessage();
            TestUtil.logMsg((String)("Got response string of: " + (String)retVal));
            InputStream content = conn.getInputStream();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(content));){
                String line;
                while ((line = in.readLine()) != null) {
                    retVal = (String)retVal + line;
                    TestUtil.logMsg((String)line);
                }
            }
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Abnormal return status encountered while invoking " + (String)sContext));
            TestUtil.logMsg((String)("Exception Message was:  " + e.getMessage()));
        }
        return retVal;
    }

    private void printVerticalIndent() {
        TestUtil.logMsg((String)"**********************************************************");
        TestUtil.logMsg((String)"\n");
    }
}

