/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.testlogic.ejb.bb.argsemantics;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.ejb.calleebeans.SimpleArgument;
import com.sun.ts.tests.common.ejb.calleebeans.StatefulCallee;
import com.sun.ts.tests.common.ejb.calleebeans.StatefulCalleeHome;
import com.sun.ts.tests.common.ejb.calleebeans.StatefulCalleeLocal;
import com.sun.ts.tests.common.ejb.calleebeans.StatefulCalleeLocalHome;
import java.util.Properties;

public class TestLogic {
    public static final String prefix = "java:comp/env/";
    public static final String statefulRemoteLookup = "java:comp/env/ejb/StatefulCalleeRemote";
    public static final String statefulLocalLookup = "java:comp/env/ejb/StatefulCalleeLocal";
    public static final String statefulBiRemoteLookup = "java:comp/env/ejb/StatefulCalleeBothRemote";
    public static final String statefulBiLocalLookup = "java:comp/env/ejb/StatefulCalleeBothLocal";
    public static final int initialValue = 12;
    public static final int modifiedValue = 24;
    public static final int modifiedValue2 = 48;
    private static StatefulCallee ssfCalleeBean = null;
    private static StatefulCalleeLocal ssfCalleeLocalBean = null;

    public static boolean testStatefulRemote(TSNamingContext nctx, Properties props) {
        return TestLogic.testStatefulRemote(statefulRemoteLookup, nctx, props);
    }

    public static boolean testStatefulLocal(TSNamingContext nctx, Properties props) {
        return TestLogic.testStatefulLocal(statefulLocalLookup, nctx, props);
    }

    public static boolean testStatefulBoth(TSNamingContext nctx, Properties props) {
        boolean pass = TestLogic.testStatefulRemote(statefulBiRemoteLookup, nctx, props);
        return pass &= TestLogic.testStatefulLocal(statefulBiLocalLookup, nctx, props);
    }

    protected static boolean testStatefulRemote(String lookupName, TSNamingContext nctx, Properties props) {
        boolean pass;
        ssfCalleeBean = null;
        try {
            SimpleArgument arg = new SimpleArgument(12);
            TestUtil.logTrace("[TestLogic] Initial value is " + arg.getValue());
            TestUtil.logTrace("[TestLogic] Looking up Callee " + lookupName + " ...");
            StatefulCalleeHome home = (StatefulCalleeHome)nctx.lookup(lookupName, StatefulCalleeHome.class);
            ssfCalleeBean = home.create(props, arg);
            TestUtil.logTrace("[TestLogic] Value after create is " + arg.getValue());
            ssfCalleeBean.call(props, arg);
            TestUtil.logTrace("[TestLogic] Value after business method is " + arg.getValue());
            boolean bl = pass = arg.getValue() == 12;
            if (!pass) {
                TestUtil.logErr("[TestLogic] Argument has been modified to " + arg.getValue());
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr("[TestLogic] Unexpected exception", e);
        }
        return pass;
    }

    protected static boolean testStatefulLocal(String lookupName, TSNamingContext nctx, Properties props) {
        boolean pass;
        ssfCalleeLocalBean = null;
        try {
            SimpleArgument arg = new SimpleArgument(12);
            TestUtil.logTrace("[TestLogic] Initial value is " + arg.getValue());
            TestUtil.logTrace("[TestLogic] Looking up Callee " + lookupName + " ...");
            StatefulCalleeLocalHome home = (StatefulCalleeLocalHome)nctx.lookup(lookupName);
            ssfCalleeLocalBean = home.create(props, arg);
            TestUtil.logTrace("[TestLogic] Value after create is " + arg.getValue());
            boolean bl = pass = arg.getValue() == 24;
            if (!pass) {
                String msg = "Expected Argument to be set to 24";
                TestUtil.logErr("[TestLogic] " + msg);
                throw new Exception(msg);
            }
            ssfCalleeLocalBean.call(props, arg);
            TestUtil.logTrace("[TestLogic] Value after business method is " + arg.getValue());
            boolean bl2 = pass = arg.getValue() == 48;
            if (!pass) {
                TestUtil.logErr("[TestLogic] Expected argument to be set to 48");
            }
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr("[TestLogic] Unexpected exception", e);
        }
        return pass;
    }

    public static void cleanUpStatefulBean() {
        TestUtil.logTrace("cleanUpStatefulBean");
        try {
            if (ssfCalleeBean != null) {
                TestUtil.logTrace("cleanUp Session Stateful Remote Callee Bean");
                ssfCalleeBean.remove();
                ssfCalleeBean = null;
            }
            if (ssfCalleeLocalBean != null) {
                TestUtil.logTrace("cleanUp Session Stateful Local Callee Bean");
                ssfCalleeLocalBean.remove();
                ssfCalleeLocalBean = null;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Exception caught trying to remove Stateful Session beans", e);
        }
    }
}

