/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.misc.jndi.earjar;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.ejb30.common.helloejbjar.HelloRemoteIF;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.lite.basic.common.GlobalJNDITest;
import com.sun.ts.tests.ejb30.misc.jndi.earjar.TestIF;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Properties;
import javax.naming.Context;

public class Client
extends EETest {
    public static final String APPCLIENT_MODULE_NAME = "misc_jndi_earjar_client";
    public static final String TEST_BEAN_NAME = "TestBean";
    public static final String HELLO_EJB_MODULE_NAME = "ejb3_common_helloejbjar_standalone_component_ejb";
    public static final String HELLO_BEAN_NAME = "HelloBean";
    @EJB(lookup="java:global/misc_jndi_earjar/misc_jndi_earjar_ejb/TestBean")
    private static TestIF testBean;
    @Resource(lookup="java:module/ModuleName")
    private static String moduleNameInjected;
    @Resource(lookup="java:app/AppName")
    private static String appNameInjected;
    @Resource
    private static Validator validator;
    @Resource
    private static ValidatorFactory validatorFactory;
    protected Properties props;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) {
        this.props = p;
    }

    public void cleanup() {
    }

    private String lookupTestBeanAndAdd(String lookupName) {
        Helper.getLogger().info("About to look up " + lookupName);
        TestIF b = (TestIF)ServiceLocator.lookupNoTry(lookupName, new Context[0]);
        int x = 1;
        int y = 2;
        int expected = x + y;
        return Helper.assertEquals(null, expected, b.add(x, y));
    }

    public void beanValidator() {
        Helper.getLogger().info("Injected Validator: " + validator.toString());
        Helper.getLogger().info("Injected ValidatorFactory: " + validatorFactory.toString());
        ValidatorFactory vf = (ValidatorFactory)ServiceLocator.lookupNoTry("java:comp/ValidatorFactory", new Context[0]);
        Validator v = (Validator)ServiceLocator.lookupNoTry("java:comp/Validator", new Context[0]);
        Helper.getLogger().info("Looked up Validator: " + v.toString());
        Helper.getLogger().info("Looked up ValidatorFactory: " + vf.toString());
    }

    public void appNameModuleName() {
        StringBuilder sb = new StringBuilder();
        String lookup = "java:module/ModuleName";
        String expected = APPCLIENT_MODULE_NAME;
        String actual = (String)ServiceLocator.lookupNoTry(lookup, new Context[0]);
        Helper.assertEquals("Check " + lookup, expected, actual, sb);
        Helper.assertEquals("Check injected value ", expected, moduleNameInjected, sb);
        lookup = "java:app/AppName";
        expected = "misc_jndi_earjar";
        actual = (String)ServiceLocator.lookupNoTry(lookup, new Context[0]);
        Helper.assertEquals("Check " + lookup, expected, actual, sb);
        Helper.assertEquals("Check injected value ", expected, appNameInjected, sb);
        Helper.getLogger().info(sb.toString());
    }

    public void appNameModuleNameFromEJB() {
        Helper.getLogger().info(testBean.appNameModuleName());
    }

    public void globalJNDIHelloEJB() {
        String lookupName = GlobalJNDITest.getGlobalJNDIName(null, HELLO_EJB_MODULE_NAME, HELLO_BEAN_NAME, HelloRemoteIF.class);
        HelloRemoteIF h = (HelloRemoteIF)ServiceLocator.lookupNoTry(lookupName, new Context[0]);
        Helper.getLogger().info(h.getMessage().toString());
    }

    public void ejbRefHello() {
        String lookupName = "java:comp/env/ejb/hello";
        HelloRemoteIF h = (HelloRemoteIF)ServiceLocator.lookupNoTry(lookupName, new Context[0]);
        Helper.getLogger().info(h.getMessage().toString());
    }

    public void globalJNDIHelloEJB2() {
        Helper.getLogger().info(testBean.globalJNDIHelloEJB(null, HELLO_EJB_MODULE_NAME, HELLO_BEAN_NAME, HelloRemoteIF.class));
    }

    public void globalJNDI() {
        String lookupName = GlobalJNDITest.getGlobalJNDIName("misc_jndi_earjar", "misc_jndi_earjar_ejb", TEST_BEAN_NAME);
        Helper.getLogger().info(this.lookupTestBeanAndAdd(lookupName));
        lookupName = GlobalJNDITest.getGlobalJNDIName("misc_jndi_earjar", "misc_jndi_earjar_ejb", TEST_BEAN_NAME, TestIF.class);
        Helper.getLogger().info(this.lookupTestBeanAndAdd(lookupName));
    }

    public void appJNDI() {
        String lookupName = GlobalJNDITest.getAppJNDIName("misc_jndi_earjar_ejb", TEST_BEAN_NAME);
        Helper.getLogger().info(this.lookupTestBeanAndAdd(lookupName));
        lookupName = GlobalJNDITest.getAppJNDIName("misc_jndi_earjar_ejb", TEST_BEAN_NAME, TestIF.class);
        Helper.getLogger().info(this.lookupTestBeanAndAdd(lookupName));
    }

    public void globalJNDI2() {
        Helper.getLogger().info(testBean.globalJNDI("misc_jndi_earjar", "misc_jndi_earjar_ejb"));
    }

    public void appJNDI2() {
        Helper.getLogger().info(testBean.appJNDI("misc_jndi_earjar_ejb"));
    }

    public void moduleJNDI2() {
        Helper.getLogger().info(testBean.moduleJNDI());
    }
}

