/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.spec.core.urlresource.url;

import com.sun.ts.tests.jstl.common.client.AbstractUrlClient;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@Tags(value={@Tag(value="jstl"), @Tag(value="platform"), @Tag(value="web")})
@ExtendWith(value={ArquillianExtension.class})
public class JSTLClientIT
extends AbstractUrlClient {
    public static String packagePath = JSTLClientIT.class.getPackageName().replace(".", "/");

    public JSTLClientIT() {
        this.setContextRoot("/jstl_core_url_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jstl_core_url_web.war");
        archive.setWebXML(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/jstl_core_url_web.xml"));
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveUrlDisplayUrlTest.jsp")), "positiveUrlDisplayUrlTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveUrlValueVarTest.jsp")), "positiveUrlValueVarTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveUrlScopeTest.jsp")), "positiveUrlScopeTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveUrlNoCharEncodingTest.jsp")), "positiveUrlNoCharEncodingTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveUrlParamsBodyTest.jsp")), "positiveUrlParamsBodyTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveUrlAbsUrlNotRewrittenTest.jsp")), "positiveUrlAbsUrlNotRewrittenTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeUrlExcBodyContentTest.jsp")), "negativeUrlExcBodyContentTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeUrlContextUrlInvalidValueTest.jsp")), "negativeUrlContextUrlInvalidValueTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveUrlContextTest.jsp")), "positiveUrlContextTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveUrlRelUrlRewrittenTest.jsp")), "positiveUrlRelUrlRewrittenTest.jsp");
        archive.addAsLibrary((Archive)JSTLClientIT.getCommonJarArchive());
        return archive;
    }

    @Test
    public void positiveUrlDisplayUrlTest() throws Exception {
        TEST_PROPS.setProperty("testname", "positiveUrlDisplayUrlTest");
        TEST_PROPS.setProperty("request", "positiveUrlDisplayUrlTest.jsp");
        TEST_PROPS.setProperty("search_string", "/jstl_core_url_web/jstl");
        this.invoke();
    }

    @Test
    public void positiveUrlValueVarTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveUrlValueVarTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveUrlValueVarTest");
        this.invoke();
    }

    @Test
    public void positiveUrlScopeTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveUrlScopeTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveUrlScopeTest");
        this.invoke();
    }

    @Test
    public void positiveUrlNoCharEncodingTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveUrlNoCharEncodingTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveUrlNoCharEncodingTest");
        this.invoke();
    }

    @Test
    public void positiveUrlParamsBodyTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveUrlParamsBodyTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveUrlParamsBodyTest");
        this.invoke();
    }

    @Test
    public void positiveUrlAbsUrlNotRewrittenTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveUrlAbsUrlNotRewrittenTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveUrlAbsUrlNotRewrittenTest");
        this.invoke();
    }

    @Test
    public void negativeUrlExcBodyContentTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/negativeUrlExcBodyContentTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "negativeUrlExcBodyContentTest");
        this.invoke();
    }

    @Test
    public void negativeUrlContextUrlInvalidValueTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/negativeUrlContextUrlInvalidValueTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "negativeUrlContextUrlInvalidValueTest");
        this.invoke();
    }
}

