/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.temporal;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.temporal.A2_Field;
import ee.jakarta.tck.persistence.core.annotations.temporal.A2_Property;
import ee.jakarta.tck.persistence.core.annotations.temporal.A_Field;
import ee.jakarta.tck.persistence.core.annotations.temporal.A_Property;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 21L;
    Date date = null;
    Date date2 = null;
    Calendar calendar = null;
    Calendar calendar2 = null;
    A_Field aFieldRef;
    A_Property aPropertyRef;
    A2_Field a2FieldRef;
    A2_Property a2PropertyRef;
    List<Date> expectedDates;
    List<Calendar> expectedCalendars;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setupData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    public void basicFieldTest() throws Exception {
        boolean pass = false;
        try {
            A_Field a = (A_Field)this.getEntityManager().find(A_Field.class, (Object)"1");
            if (a != null) {
                if (this.aFieldRef.equals(a)) {
                    pass = true;
                } else {
                    this.logErr("Expected:" + this.aFieldRef.toString() + ", actual:" + a.toString());
                }
            } else {
                this.logErr("Find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("basicFieldTest failed");
        }
    }

    public void basicPropertyTest() throws Exception {
        boolean pass = false;
        try {
            A_Property a = (A_Property)this.getEntityManager().find(A_Property.class, (Object)"2");
            if (a != null) {
                if (this.aPropertyRef.equals(a)) {
                    this.logTrace("Received expected entity:" + a.toString());
                    pass = true;
                } else {
                    this.logErr("Expected:" + this.aPropertyRef.toString() + ", actual:" + a.toString());
                }
            } else {
                this.logErr("Find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("basicPropertyTest failed");
        }
    }

    public void fieldElementCollectionTemporalTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find the previously persisted Customer and Country and verify them");
            A_Field a = (A_Field)this.getEntityManager().find(A_Field.class, (Object)"1");
            if (a != null) {
                this.logTrace("Found A: " + a.toString());
                if (a.getDates().containsAll(this.expectedDates) && this.expectedDates.containsAll(a.getDates()) && a.getDates().size() == this.expectedDates.size()) {
                    this.logTrace("Received expected Dates:");
                    for (Date d : a.getDates()) {
                        this.logTrace("date:" + d);
                    }
                    pass = true;
                } else {
                    this.logErr("Did not get expected results.");
                    for (Date d : this.expectedDates) {
                        this.logErr("expected:" + d);
                    }
                    this.logErr("actual:");
                    for (Date d : a.getDates()) {
                        this.logErr("actual:" + d);
                    }
                }
            } else {
                this.logErr("Find returned null A");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("fieldElementCollectionTemporalTest failed");
        }
    }

    public void propertyElementCollectionTemporalTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find the previously persisted Customer and Country and verify them");
            A_Property a = (A_Property)this.getEntityManager().find(A_Property.class, (Object)"2");
            if (a != null) {
                this.logTrace("Found A2: " + a.toString());
                if (a.getDates().containsAll(this.expectedCalendars) && this.expectedCalendars.containsAll(a.getDates()) && a.getDates().size() == this.expectedCalendars.size()) {
                    this.logTrace("Received expected Dates:");
                    for (Calendar calendar : a.getDates()) {
                        this.logTrace("date:" + calendar);
                    }
                    pass = true;
                } else {
                    this.logErr("Did not get expected results.");
                    for (Date date : this.expectedDates) {
                        this.logErr("expected:" + date);
                    }
                    this.logErr("actual:");
                    for (Calendar calendar : a.getDates()) {
                        this.logErr("actual:" + calendar);
                    }
                }
            } else {
                this.logErr("Find returned null A2");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("propertyElementCollectionTemporalTest failed");
        }
    }

    public void idFieldTest() throws Exception {
        boolean pass = false;
        try {
            A2_Field a = (A2_Field)this.getEntityManager().find(A2_Field.class, (Object)this.date2);
            if (a != null) {
                if (this.a2FieldRef.equals(a)) {
                    pass = true;
                } else {
                    this.logErr("Expected:" + this.a2FieldRef.toString() + ", actual:" + a.toString());
                }
            } else {
                this.logErr("Find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("idFieldTest failed");
        }
    }

    public void idPropertyTest() throws Exception {
        boolean pass = false;
        try {
            A2_Property a = (A2_Property)this.getEntityManager().find(A2_Property.class, (Object)this.calendar2);
            if (a != null) {
                if (this.a2PropertyRef.equals(a)) {
                    this.logTrace("Received expected entity:" + a.toString());
                    pass = true;
                } else {
                    this.logErr("Expected:" + this.a2PropertyRef.toString() + ", actual:" + a.toString());
                }
            } else {
                this.logErr("Find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("idPropertyTest failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestData() {
        this.logTrace("createTestData");
        try {
            this.getEntityTransaction().begin();
            this.date = this.getSQLDate();
            LocalDate localDate = ((java.sql.Date)this.date).toLocalDate();
            this.date2 = this.getUtilDate("2000-02-14");
            String sDate2 = "2000-02-14";
            this.calendar = Calendar.getInstance();
            this.calendar.clear();
            this.calendar.set(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
            this.calendar2 = this.getCalDate(2001, 6, 27);
            String sCalendar2 = "2001-06-27";
            this.expectedDates = new ArrayList<Date>();
            this.expectedDates.add(this.getUtilDate("2000-02-14"));
            this.expectedDates.add(this.getUtilDate("2001-06-27"));
            this.expectedDates.add(this.getUtilDate("2002-07-07"));
            this.aFieldRef = new A_Field("1", this.date, this.calendar, this.expectedDates);
            this.expectedCalendars = new ArrayList<Calendar>();
            this.expectedCalendars.add(this.getCalDate(2000, 2, 14));
            this.expectedCalendars.add(this.getCalDate(2001, 6, 27));
            this.expectedCalendars.add(this.getCalDate(2002, 7, 7));
            this.aPropertyRef = new A_Property("2", this.date, this.calendar, this.expectedCalendars);
            this.getEntityManager().persist((Object)this.aFieldRef);
            this.getEntityManager().persist((Object)this.aPropertyRef);
            this.a2FieldRef = new A2_Field(this.date2, sDate2);
            this.a2PropertyRef = new A2_Property(this.calendar2, sCalendar2);
            this.getEntityManager().persist((Object)this.a2FieldRef);
            this.getEntityManager().persist((Object)this.a2PropertyRef);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception in createTestData:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM A_BASIC").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATE_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATES_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

