/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.assembly.util.shared.resref.single.appclient;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnectionFactory;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;

public class TestCode {
    private static final String prefix = "java:comp/env/";
    protected static final String dbLookup = "java:comp/env/jdbc/DB1";
    protected static final String urlLookup = "java:comp/env/url/URL";
    protected static final String queueLookup = "java:comp/env/jms/QueueConnectionFactory";
    protected static final String topicLookup = "java:comp/env/jms/TopicConnectionFactory";

    public static boolean testDatasource(TSNamingContext nctx) {
        try {
            TestUtil.logTrace((String)"[TestCode] looking up java:comp/env/jdbc/DB1");
            DataSource ds = (DataSource)nctx.lookup(dbLookup);
            TestUtil.logTrace((String)"[TestCode] get a new DB connection...");
            Connection connection = ds.getConnection();
            connection.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("RestTest: Caught exception: " + e), (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean testURL(TSNamingContext nctx) {
        try {
            TestUtil.logTrace((String)"[TestCode] looking up java:comp/env/url/URL");
            URL myUrl = (URL)nctx.lookup(urlLookup);
            TestUtil.logTrace((String)"[TestCode] get a new URL connection...");
            URLConnection urlConnection = myUrl.openConnection();
            Properties props = TestUtil.getResponseProperties((URLConnection)urlConnection);
            String resRef = props.getProperty("resourceref");
            if (null == resRef || !resRef.equals("true")) {
                TestUtil.logErr((String)"ResRef: Invalid connection!");
                return false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("RestTest: Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean testQueue(TSNamingContext nctx) {
        try {
            TestUtil.logTrace((String)"[TestCode] looking up java:comp/env/jms/QueueConnectionFactory");
            QueueConnectionFactory queueFact = (QueueConnectionFactory)nctx.lookup(queueLookup);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("RestTest: Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean testTopic(TSNamingContext nctx) {
        try {
            TestUtil.logTrace((String)"[TestCode] looking up java:comp/env/jms/TopicConnectionFactory");
            TopicConnectionFactory topicFact = (TopicConnectionFactory)nctx.lookup(topicLookup);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("RestTest: Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }
}

