/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.exception.sqlException;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class sqlExceptionClient
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.exception.sqlException";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private String drManager = null;
    private Properties sqlp = null;
    private boolean isThrown = false;
    private String sReason = null;
    private String sSqlState = null;
    private String sVendorCode = null;
    private String sUsr;
    private String sPass;
    private String sUrl;
    private int vendorCode = 0;
    private int maxVal = 0;
    private int minVal = 0;
    private int[] updateCount = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        sqlExceptionClient theTests = new sqlExceptionClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sUrl = p.getProperty("db1", "");
                this.sUsr = p.getProperty("user1", "");
                this.sPass = p.getProperty("password1", "");
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.rsSch = new rsSchema();
                this.dbSch.createData(p, this.conn);
                this.msg = new JDBCTestMsg();
                this.stmt = this.conn.createStatement();
                this.sReason = this.sqlp.getProperty("Reason_BatUpdExec");
                this.logTrace("Reason : " + this.sReason);
                this.sSqlState = this.sqlp.getProperty("SQLState_BatUpdExec");
                this.logTrace("SQLState : " + this.sSqlState);
                this.sVendorCode = this.sqlp.getProperty("VendorCode_BatUpdExec");
                this.logTrace("VendorCode : " + this.sVendorCode);
                this.sVendorCode = this.sVendorCode.trim();
                this.vendorCode = Integer.valueOf(this.sVendorCode);
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage());
                throw new Exception("Set Up Failed", ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup Failed");
        }
    }

    public void testSQLException01() throws Exception {
        try {
            this.isThrown = false;
            throw new SQLException();
        }
        catch (SQLException b) {
            TestUtil.printStackTrace((Throwable)b);
            this.isThrown = true;
            if (b.getMessage() != null || b.getSQLState() != null || b.getErrorCode() != 0) {
                this.msg.printTestError("SQLException() Constructor Fails", "Call to SQLException() Failed!");
            } else {
                this.msg.setMsg("SQLException() Constructor is implemented");
            }
            this.msg.printTestMsg();
        }
        catch (Exception ex) {
            this.msg.printError(ex, "Call to SQLException() Failed!");
        }
        if (!this.isThrown) {
            this.msg.printTestError("SQLException() not thrown", "Call to SQLException() Failed!");
        }
    }

    public void testSQLException02() throws Exception {
        try {
            this.isThrown = false;
            throw new SQLException(this.sReason);
        }
        catch (SQLException b) {
            TestUtil.printStackTrace((Throwable)b);
            this.isThrown = true;
            if (b.getSQLState() != null || b.getErrorCode() != 0) {
                this.msg.printTestError("SQLException(String) Constructor Fails", "Call to SQLException(String) Constructor Fails");
            } else if (!this.sReason.equals(b.getMessage())) {
                this.msg.printTestError("SQLException(String) Constructor Fails", "Call to SQLException(String) Constructor Fails");
            } else {
                this.msg.setMsg("SQLException Constructor implemented");
            }
            this.msg.printTestMsg();
        }
        catch (Exception ex) {
            this.msg.printError(ex, "Call to SQLException(String) Constructor Fails");
        }
        if (!this.isThrown) {
            this.msg.printTestError("SQLException(String) Constructor Fails", "Call to SQLException(String) Constructor Fails");
        }
    }

    public void testSQLException03() throws Exception {
        try {
            this.isThrown = false;
            throw new SQLException(this.sReason, this.sSqlState);
        }
        catch (SQLException b) {
            TestUtil.printStackTrace((Throwable)b);
            this.isThrown = true;
            if (b.getErrorCode() != 0) {
                this.msg.printTestError("SQLException(String,String) Constructor Fails", "Call to SQLException(String,String) Constructor Fails");
            } else if (!this.sSqlState.equals(b.getSQLState()) || !this.sReason.equals(b.getMessage())) {
                this.msg.printTestError("SQLException(String,String) Constructor Fails", "Call to SQLException(String,String) Constructor Fails");
            } else {
                this.msg.setMsg("Call to SQLException Passes");
            }
            this.msg.printTestMsg();
        }
        catch (Exception ex) {
            this.msg.printError(ex, "Call to SQLException(String,String) Constructor Fails");
        }
        if (!this.isThrown) {
            this.msg.printTestError("SQLException(String,String) not thrown", "Call to SQLException(String,String) Constructor Fails");
        }
    }

    public void testSQLException04() throws Exception {
        try {
            this.isThrown = false;
            throw new SQLException(this.sReason, this.sSqlState, this.vendorCode);
        }
        catch (SQLException b) {
            TestUtil.printStackTrace((Throwable)b);
            this.isThrown = true;
            if (!this.sReason.equals(b.getMessage()) || !this.sSqlState.equals(b.getSQLState()) || this.vendorCode != b.getErrorCode()) {
                this.msg.printTestError("SQLException(String,String,int) Constructor Fails", "Call to SQLException(String,String,int) Constructor Fails");
            } else {
                this.msg.setMsg("SQLException(String,String,int) Constructor is implemented");
            }
            this.msg.printTestMsg();
        }
        catch (Exception ex) {
            this.msg.printError(ex, "Call to SQLException(String,String,int) Constructor is Failed!");
        }
        if (!this.isThrown) {
            this.msg.printTestError("SQLException(String,String,int) Constructor not thrown", "Call to SQLException(String,String,int) Constructor is Failed!");
        }
    }

    public void testGetErrorCode() throws Exception {
        try {
            String sErrorQuery = this.sqlp.getProperty("Error_Query");
            this.stmt.executeQuery(sErrorQuery);
        }
        catch (SQLException b) {
            TestUtil.printStackTrace((Throwable)b);
            this.isThrown = true;
            this.maxVal = Integer.parseInt(this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn).trim());
            this.minVal = Integer.parseInt(this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn).trim());
            if (b.getErrorCode() <= this.maxVal && b.getErrorCode() >= this.minVal) {
                this.msg.setMsg("getErrorCode() method returns integer value");
            } else {
                this.msg.printTestError("getErrorCode() Method does not returns integer value", "Call to getErrorCode() method fails");
            }
            this.msg.printTestMsg();
        }
        catch (Exception ex) {
            this.msg.printError(ex, "call to getErrorCode() method fails");
        }
        if (!this.isThrown) {
            this.msg.printTestError("getErrorCode() Method does not returns integer value", "Call to getErrorCode() method fails");
        }
    }

    public void testGetSQLState() throws Exception {
        try {
            String sErrorQuery = this.sqlp.getProperty("Error_Query");
            this.stmt.executeQuery(sErrorQuery);
        }
        catch (SQLException b) {
            TestUtil.printStackTrace((Throwable)b);
            this.isThrown = true;
            if (b.getSQLState() instanceof String) {
                this.msg.setMsg("getSQLState() method returns String value");
            } else {
                this.msg.printTestError("getSQLState() method does not returns String Value", "call to getSQLState() method fails");
            }
            this.msg.printTestMsg();
        }
        catch (Exception ex) {
            this.msg.printError(ex, "call to getSQLState() method fails");
        }
        if (!this.isThrown) {
            this.msg.printTestError("SQLException not thrown", "call to getSQLState() method fails");
        }
    }

    public void testGetNextException() throws Exception {
        try {
            String sErrorQuery = this.sqlp.getProperty("Error_Query");
            this.stmt.executeQuery(sErrorQuery);
        }
        catch (SQLException b) {
            TestUtil.printStackTrace((Throwable)b);
            this.isThrown = true;
            b.setNextException(new SQLException(this.sReason, this.sSqlState, this.vendorCode));
            if (b.getNextException() instanceof SQLException) {
                this.msg.setMsg("getNextException() method returns SQLException object");
                this.msg.setMsg("String is " + b.getMessage());
            } else {
                this.msg.printTestError("getNextException() mMethod doesnot returns SQLException object", "call to getNextException() method fails");
            }
            this.msg.printTestMsg();
        }
        catch (Exception ex) {
            this.msg.printError(ex, "call to getNextException() method fails");
        }
        if (!this.isThrown) {
            this.msg.printTestError("SQLException not thrown", "call to getNextException() method fails");
        }
    }

    public void testSetNextException() throws Exception {
        try {
            String sErrorQuery = this.sqlp.getProperty("Error_Query");
            this.stmt.executeQuery(sErrorQuery);
        }
        catch (SQLException b) {
            TestUtil.printStackTrace((Throwable)b);
            this.isThrown = true;
            b.setNextException(new SQLException(this.sReason, this.sSqlState, this.vendorCode));
            if (b.getNextException() instanceof SQLException) {
                this.msg.setMsg("setNextException() method sets SQLException object");
                this.msg.setMsg("String is " + b.getMessage());
            } else {
                this.msg.printTestError("setNextException() Method doesnot sets SQLException object", "call to setNextException() method fails");
            }
            this.msg.printTestMsg();
        }
        catch (Exception ex) {
            this.msg.printError(ex, "call to setNextException() method fails");
        }
        if (!this.isThrown) {
            this.msg.printTestError("SQLException not thrown", "call to setNextException() method fails");
        }
    }

    public void cleanup() throws Exception {
        try {
            this.stmt.close();
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

