/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.selectorQueue;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TemporaryQueue;
import java.util.Properties;

public class MsgSelectorQueueTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.ee.selectorQueue.MsgSelectorQueueTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient Message msg = null;
    private transient QueueReceiver qReceiver = null;
    private transient TemporaryQueue tempQ = null;
    private transient QueueSender qSender = null;
    private transient QueueConnection qConnect;
    private transient QueueSession session;
    private transient QueueConnectionFactory qFactory;
    private boolean transacted = false;
    private Properties props = null;
    private long jms_timeout;
    private String jmsUser = null;
    private String jmsPassword = null;
    private String mode = null;

    public static void main(String[] args) {
        MsgSelectorQueueTests theTests = new MsgSelectorQueueTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void startTest(String selector, String headerValue) throws Exception {
        this.logTrace("startTest(): Creating receiver with message selector");
        this.tempQ = this.session.createTemporaryQueue();
        this.qReceiver = this.session.createReceiver((Queue)this.tempQ, selector);
        this.logTrace("Creating message");
        this.msg = this.session.createMessage();
        this.msg.setStringProperty("COM_SUN_JMS_TESTNAME", "MsgSelectorQueueTests");
        this.msg.setJMSType(headerValue);
    }

    private void finishTestReceive() throws Exception {
        this.logTrace("finishTestReceive(): Sending test message");
        this.msg.setBooleanProperty("first_message", true);
        this.qSender = this.session.createSender((Queue)this.tempQ);
        this.qSender.send(this.msg);
        this.logTrace("Attempt to receive message");
        Message msg1 = this.qReceiver.receive(this.jms_timeout);
        this.logTrace("Received message: " + msg1);
        if (msg1 == null) {
            throw new Exception("Did not receive message!");
        }
        if (!msg1.getBooleanProperty("first_message")) {
            this.logMsg("Received completely unexpected message.");
            throw new Exception("Received unexpected message -- not part of test");
        }
        this.logTrace("test passed");
    }

    private void sendFirstMessage() throws JMSException {
        this.logTrace("sendFirstMessage(): Sending message that does not match selector");
        this.msg.setBooleanProperty("second_message", false);
        this.qSender = this.session.createSender((Queue)this.tempQ);
        this.qSender.send(this.msg);
        this.msg = this.session.createMessage();
        this.msg.setStringProperty("COM_SUN_JMS_TESTNAME", "MsgSelectorQueueTests_2");
    }

    private void finishTest() throws Exception {
        TestUtil.logTrace((String)("time_out is " + this.jms_timeout));
        this.logTrace("finishTest: Sending message that should match selector");
        this.msg.setBooleanProperty("second_message", true);
        this.qSender = this.session.createSender((Queue)this.tempQ);
        this.qSender.send(this.msg);
        this.logTrace("Attempt to receive message. Should receive second message only.");
        Message msg1 = this.qReceiver.receive(this.jms_timeout);
        this.logTrace("Received message: " + msg1);
        if (msg1 == null) {
            throw new Exception("Did not receive message!");
        }
        if (msg1.getBooleanProperty("second_message")) {
            this.logTrace("test passed");
        } else if (!msg1.getBooleanProperty("second_message")) {
            throw new Exception("Incorrectly received non-matching message!");
        }
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.props = p;
            this.jms_timeout = Long.parseLong(this.props.getProperty("jms_timeout"));
            if (this.jms_timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            this.jmsUser = this.props.getProperty("user");
            this.jmsPassword = this.props.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            JmsTool tool = new JmsTool(7, this.jmsUser, this.jmsPassword, this.mode);
            this.qFactory = tool.getQueueConnectionFactory();
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            this.qConnect.start();
            this.session = this.qConnect.createQueueSession(this.transacted, 1);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            this.logTrace(" closing connection");
            this.qConnect.close();
            this.tempQ = null;
            this.session.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void selectorTest01() throws Exception {
        try {
            String selector = "JMSType='literal'";
            String value = "literal";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void selectorTest02() throws Exception {
        try {
            String selector = "JMSType='literal''s'";
            String value = "literal's";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void selectorTest03() throws Exception {
        try {
            String selector = "myProp0=-9223372036854775808L AND myProp1=9223372036854775807L";
            String value = "";
            TestUtil.logTrace((String)selector);
            this.startTest(selector, value);
            this.msg.setLongProperty("myProp0", Long.MIN_VALUE);
            this.msg.setLongProperty("myProp1", Long.MAX_VALUE);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void selectorTest04() throws Exception {
        try {
            String selector = "myProp0=-957 AND myProp1=+62";
            String value = "";
            this.startTest(selector, value);
            this.msg.setLongProperty("myProp0", -957L);
            this.msg.setLongProperty("myProp1", 62L);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void selectorTest05() throws Exception {
        try {
            String selector = "myProp=035";
            String value = "";
            this.startTest(selector, value);
            this.msg.setLongProperty("myProp", 29L);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void selectorTest06() throws Exception {
        try {
            String selector = "myProp=0x1d";
            String value = "";
            this.startTest(selector, value);
            this.msg.setLongProperty("myProp", 29L);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void selectorTest07() throws Exception {
        try {
            String selector = "myProp0=7E3 AND myProp1=-57.9E3";
            String value = "";
            this.startTest(selector, value);
            this.msg.setDoubleProperty("myProp0", 7000.0);
            this.msg.setDoubleProperty("myProp1", -57900.0);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void selectorTest08() throws Exception {
        try {
            String selector = "myProp=7000.";
            String value = "";
            this.startTest(selector, value);
            this.msg.setDoubleProperty("myProp", 7000.0);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void selectorTest09() throws Exception {
        try {
            String selector = "myProp0=.7e4";
            String value = "";
            this.startTest(selector, value);
            this.msg.setDoubleProperty("myProp0", 7000.0);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void selectorTest11() throws Exception {
        try {
            String selector = "myProp0=TRUE AND myProp1=FALSE";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myProp0", true);
            this.msg.setBooleanProperty("myProp1", false);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void selectorTest12() throws Exception {
        try {
            String selector = "myProp0=false AND myProp1=true";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myProp0", false);
            this.msg.setBooleanProperty("myProp1", true);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest01() throws Exception {
        try {
            String selector = "$myProp=TRUE AND _myProp=FALSE";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("$myProp", true);
            this.msg.setBooleanProperty("_myProp", false);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest02() throws Exception {
        try {
            String selector = "NULL = 0";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Caught expected exception");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest03() throws Exception {
        try {
            String selector = "TRUE = 0";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Caught expected exception");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest04() throws Exception {
        try {
            String selector = "FALSE = 0";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Caught expected exception");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest05() throws Exception {
        try {
            String selector = "NOT = 0";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Caught expected exception");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest06() throws Exception {
        try {
            String selector = "AND = 0";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Caught expected exception");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest07() throws Exception {
        try {
            String selector = "OR = 0";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Caught expected exception");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest08() throws Exception {
        try {
            String selector = "BETWEEN = 0";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Caught expected exception");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest09() throws Exception {
        try {
            String selector = "LIKE = 0";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Caught expected exception");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest10() throws Exception {
        try {
            String selector = "IN = 0";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Caught expected exception");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest11() throws Exception {
        try {
            String selector = "IS = 0";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Caught expected exception");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest12() throws Exception {
        try {
            String selector = "myProp=TRUE AND MYpROP=FALSE";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myProp", true);
            this.msg.setBooleanProperty("MYpROP", false);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest13() throws Exception {
        try {
            String selector = "myProp ='foo'";
            String value = "";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setStringProperty("myProp", "foo");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void identifierTest14() throws Exception {
        try {
            String selector = "ESCAPE = 0";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Caught expected exception");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void whitespaceTest1() throws Exception {
        try {
            String selector = "JMSType   =   'foo'";
            String value = "foo";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void whitespaceTest2() throws Exception {
        try {
            String selector = "JMSType\t=\t'foo'";
            String value = "foo";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void whitespaceTest3() throws Exception {
        try {
            String selector = "JMSType\f=\f'foo'";
            String value = "foo";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void whitespaceTest4() throws Exception {
        try {
            String selector = "JMSType\n= \n'foo'";
            String value = "foo";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void expressionTest1() throws Exception {
        try {
            String selector = "myProp";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myProp", true);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void expressionTest2() throws Exception {
        try {
            String selector = "myProp";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myProp", false);
            this.sendFirstMessage();
            this.msg.setBooleanProperty("myProp", true);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void expressionTest3() throws Exception {
        try {
            String selector = "myNullProp";
            String value = "";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setBooleanProperty("myNullProp", true);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void bracketingTest1() throws Exception {
        try {
            String selector = "(myTrueProp OR myFalseProp) AND myFalseProp";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myTrueProp", true);
            this.msg.setBooleanProperty("myFalseProp", false);
            this.sendFirstMessage();
            this.msg.setBooleanProperty("myTrueProp", true);
            this.msg.setBooleanProperty("myFalseProp", true);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void bracketingTest2() throws Exception {
        try {
            String selector = "TRUE OR (FALSE AND FALSE)";
            String value = "";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void bracketingTest3() throws Exception {
        try {
            String selector = "(myProp0 = true OR myProp1 = true) AND JMSType = 'not_foo'";
            String value = "foo";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myProp0", true);
            this.msg.setBooleanProperty("myProp1", false);
            this.sendFirstMessage();
            this.msg.setJMSType("not_foo");
            this.msg.setBooleanProperty("myProp0", true);
            this.msg.setBooleanProperty("myProp1", false);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void bracketingTest4() throws Exception {
        try {
            String selector = "(myProp1 = true AND JMSType = 'not_foo') OR myProp0 = true";
            String value = "foo";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myProp0", true);
            this.msg.setBooleanProperty("myProp1", false);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void comparisonTest01() throws Exception {
        try {
            String selector = "myProp0 = 'foo' AND myProp1 > 0 AND myProp2 >= 2 AND myProp3 >= 2 AND myProp4 < 5 AND myProp5 <= 6 AND myProp6 <= 6 AND myProp7 <> 7";
            String value = "";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp0", "foo");
            this.msg.setIntProperty("myProp1", 1);
            this.msg.setFloatProperty("myProp2", 2.0f);
            this.msg.setIntProperty("myProp3", 3);
            this.msg.setDoubleProperty("myProp4", 4.0);
            this.msg.setIntProperty("myProp5", 5);
            this.msg.setIntProperty("myProp6", 6);
            this.msg.setFloatProperty("myProp7", 0.0f);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void comparisonTest02() throws Exception {
        try {
            String selector = "myProp0 = 'foo' OR myProp1 > 0 OR myProp2 >= 2 OR myProp3 < 5 OR myProp4 <= 6 OR myProp5 <> 7";
            String value = "";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp0", "not_foo");
            this.msg.setIntProperty("myProp1", 0);
            this.msg.setFloatProperty("myProp2", 1.5f);
            this.msg.setDoubleProperty("myProp3", 5.0);
            this.msg.setIntProperty("myProp4", 7);
            this.msg.setFloatProperty("myProp5", 7.0f);
            this.sendFirstMessage();
            this.msg.setStringProperty("myProp0", "foo");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void comparisonTest03() throws Exception {
        try {
            String selector = "myProp0 < myProp1";
            String value = "";
            this.startTest(selector, value);
            this.msg.setIntProperty("myProp0", 0);
            this.msg.setDoubleProperty("myProp1", 1.5);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void comparisonTest04() throws Exception {
        try {
            String selector = "myProp > 'foo'";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException as expected.");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Test passed. Received expected exception.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void comparisonTest05() throws Exception {
        try {
            String selector = "myProp >= 'foo'";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException as expected.");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Test passed. Received expected exception.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void comparisonTest06() throws Exception {
        try {
            String selector = "myProp < 'foo'";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException as expected.");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Test passed. Received expected exception.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void comparisonTest07() throws Exception {
        try {
            String selector = "myProp <= 'foo'";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException as expected.");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Test passed. Received expected exception.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void comparisonTest08() throws Exception {
        try {
            String selector = "JMSType = 'foo' AND myProp <> 'not_foo'";
            String value = "foo";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp", "foo");
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void comparisonTest09() throws Exception {
        try {
            String selector = "'foo' > TRUE ";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException as expected.");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Test passed. Received expected exception.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void comparisonTest10() throws Exception {
        try {
            String selector = "'foo' >= TRUE ";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException as expected.");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Test passed. Received expected exception.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void comparisonTest11() throws Exception {
        try {
            String selector = "'foo' < TRUE ";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException as expected.");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Test passed. Received expected exception.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void comparisonTest12() throws Exception {
        try {
            String selector = "'foo' <= TRUE ";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException as expected.");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Test passed. Received expected exception.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void comparisonTest13() throws Exception {
        try {
            String selector = "myProp0 = TRUE AND myProp1 <> FALSE";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myProp0", true);
            this.msg.setBooleanProperty("myProp1", true);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void operatorTest1() throws Exception {
        try {
            String selector = "-myProp0 < 0 AND +myProp1 < 0";
            String value = "";
            this.startTest(selector, value);
            this.msg.setIntProperty("myProp0", 5);
            this.msg.setIntProperty("myProp1", -5);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void operatorTest2() throws Exception {
        try {
            String selector = "myProp0*2 = 10 AND myProp1/2 = -5";
            String value = "";
            this.startTest(selector, value);
            this.msg.setIntProperty("myProp0", 5);
            this.msg.setIntProperty("myProp1", -10);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void operatorTest3() throws Exception {
        try {
            String selector = "myProp0+5 = 0 AND myProp1-5 = 5";
            String value = "";
            this.startTest(selector, value);
            this.msg.setIntProperty("myProp0", -5);
            this.msg.setIntProperty("myProp1", 10);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void betweenTest1() throws Exception {
        try {
            String selector = "myProp0 BETWEEN 5 and 10 AND myProp1 BETWEEN -1 and 1 AND myProp2 BETWEEN 0 and 2";
            String value = "";
            this.startTest(selector, value);
            this.msg.setIntProperty("myProp0", 7);
            this.msg.setIntProperty("myProp1", -1);
            this.msg.setIntProperty("myProp2", 2);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void betweenTest2() throws Exception {
        try {
            String selector = "myProp0 BETWEEN  -4 and 5 OR myProp1 BETWEEN -5 and 4";
            String value = "";
            this.startTest(selector, value);
            this.msg.setIntProperty("myProp0", -5);
            this.msg.setIntProperty("myProp1", 5);
            this.sendFirstMessage();
            this.msg.setIntProperty("myProp0", 0);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void betweenTest3() throws Exception {
        try {
            String selector = "myProp0 NOT BETWEEN  -4 and 5 AND myProp1 NOT BETWEEN -5 and 4";
            String value = "";
            this.startTest(selector, value);
            this.msg.setIntProperty("myProp0", -5);
            this.msg.setIntProperty("myProp1", 5);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void betweenTest4() throws Exception {
        try {
            String selector = "myProp0 NOT BETWEEN 5 and 10 OR myProp1 NOT BETWEEN -1 and 1 OR myProp2 NOT BETWEEN 0 and 2";
            String value = "";
            this.startTest(selector, value);
            this.msg.setIntProperty("myProp0", 7);
            this.msg.setIntProperty("myProp1", -1);
            this.msg.setIntProperty("myProp2", 2);
            this.sendFirstMessage();
            this.msg.setIntProperty("myProp0", 0);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void betweenTest5() throws Exception {
        try {
            String selector = "myProp BETWEEN 5 and 10";
            String value = "";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp", "7");
            this.sendFirstMessage();
            this.msg.setIntProperty("myProp", 7);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void betweenTest6() throws Exception {
        try {
            String selector = "myProp BETWEEN 5 and 10";
            String value = "";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp", "seven");
            this.sendFirstMessage();
            this.msg.setIntProperty("myProp", 7);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void betweenTest7() throws Exception {
        try {
            String selector = "myProp BETWEEN 'foo' and 'test'";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Caught expected exception");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void inTest1() throws Exception {
        try {
            String selector = "JMSType IN ('foo','jms','test')";
            String value = "jms";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void inTest2() throws Exception {
        try {
            String selector = "JMSType IN ('foo','jms','test')";
            String value = "JMS";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setJMSType("jms");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void inTest3() throws Exception {
        try {
            String selector = "JMSType NOT IN ('foo','jms','test')";
            String value = "FOO";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void inTest4() throws Exception {
        try {
            String selector = "JMSType NOT IN ('foo','jms','test')";
            String value = "foo";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setJMSType("FOO");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void inTest5() throws Exception {
        try {
            String selector = "myNullProp IN ('foo','jms','test')";
            String value = "";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setStringProperty("myNullProp", "jms");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void inTest6() throws Exception {
        try {
            String selector = "myNullProp NOT IN ('foo','jms','test')";
            String value = "";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setStringProperty("myNullProp", "JMS");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void inTest7() throws Exception {
        try {
            String selector = "myProp NOT IN ('foo','jms','test')";
            String value = "";
            this.startTest(selector, value);
            this.msg.setIntProperty("myProp", 0);
            this.sendFirstMessage();
            this.msg.setStringProperty("myProp", "zero");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void inTest8() throws Exception {
        try {
            String selector = "myProp NOT IN (1,2,3)";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Caught expected exception");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest01() throws Exception {
        try {
            String selector = "JMSType LIKE 'jms'";
            String value = "jms";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest02() throws Exception {
        try {
            String selector = "JMSType LIKE 's_lector' AND myProp0 LIKE '_bcd' AND myProp1 LIKE '123_'";
            String value = "selector";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp0", "abcd");
            this.msg.setStringProperty("myProp1", "1234");
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest03() throws Exception {
        try {
            String selector = "JMSType LIKE 's%tor' AND myProp0 LIKE '%cd' AND myProp1 LIKE '1%' AND myProp2 LIKE 'AB%CD' AND myProp3 LIKE '%'";
            String value = "selector";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp0", "abcd");
            this.msg.setStringProperty("myProp1", "1234");
            this.msg.setStringProperty("myProp2", "ABCD");
            this.msg.setStringProperty("myProp3", "foo");
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest04() throws Exception {
        try {
            String selector = "JMSType LIKE 'A_fo_A%f%' ESCAPE 'A'";
            String value = "_foo%foo";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest05() throws Exception {
        try {
            String selector = "JMSType LIKE '123' OR myProp LIKE 'jms0'";
            String value = "1234";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp", "jms");
            this.sendFirstMessage();
            this.msg.setStringProperty("myProp", "jms0");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest06() throws Exception {
        try {
            String selector = "JMSType LIKE 'se_ector' OR myProp0 LIKE '_cd' OR myProp1 LIKE '12_'";
            String value = "seleector";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp0", "abcd");
            this.msg.setStringProperty("myProp1", "1234");
            this.sendFirstMessage();
            this.msg.setJMSType("selector");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest07() throws Exception {
        try {
            String selector = "JMSType LIKE '12%3'";
            String value = "1234";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setJMSType("12333");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest08() throws Exception {
        try {
            String selector = "JMSType LIKE 'A%fooA_' ESCAPE 'A'";
            String value = "_foo%";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setJMSType("%foo_");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest09() throws Exception {
        try {
            String selector = "JMSType NOT LIKE 'jms_foo'";
            String value = "jms";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest10() throws Exception {
        try {
            String selector = "JMSType NOT LIKE 's_ector' AND myProp0 NOT LIKE '_cd' AND myProp1 NOT LIKE '12_'";
            String value = "selector";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp0", "abcd");
            this.msg.setStringProperty("myProp1", "1234");
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest11() throws Exception {
        try {
            String selector = "myProp0 NOT LIKE '%cde' AND myProp1 NOT LIKE '01%' AND myProp2 NOT LIKE 'A%x%D'";
            String value = "";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp0", "abcd");
            this.msg.setStringProperty("myProp1", "1234");
            this.msg.setStringProperty("myProp2", "ABCD");
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest12() throws Exception {
        try {
            String selector = "JMSType NOT LIKE 'A_A_' ESCAPE 'A'";
            String value = "_A";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest13() throws Exception {
        try {
            String selector = "JMSType NOT LIKE '1234' OR myProp NOT LIKE 'jms'";
            String value = "1234";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp", "jms");
            this.sendFirstMessage();
            this.msg.setJMSType("foo");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest14() throws Exception {
        try {
            String selector = "JMSType NOT LIKE 'se_ector' OR myProp0 NOT LIKE '_bcd' OR myProp1 NOT LIKE '123_'";
            String value = "selector";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp0", "abcd");
            this.msg.setStringProperty("myProp1", "1234");
            this.sendFirstMessage();
            this.msg.setJMSType("foo");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest15() throws Exception {
        try {
            String selector = "JMSType NOT LIKE '12%'";
            String value = "1234";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setJMSType("foo");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest16() throws Exception {
        try {
            String selector = "JMSType NOT LIKE 'A_fooA%' ESCAPE 'A'";
            String value = "_foo%";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setJMSType("jms");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest17() throws Exception {
        try {
            String selector = "JMSType LIKE '\\__\\%%' ESCAPE '\\'";
            String value = "_a%b";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest18() throws Exception {
        try {
            String selector = "myNullProp LIKE '1_3'";
            String value = "";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setStringProperty("myNullProp", "123");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest19() throws Exception {
        try {
            String selector = "myNullProp NOT LIKE '1_3'";
            String value = "";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setStringProperty("myNullProp", "foo");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest20() throws Exception {
        try {
            String selector = "myProp LIKE '1_3'";
            String value = "";
            this.startTest(selector, value);
            this.msg.setIntProperty("myProp", 123);
            this.sendFirstMessage();
            this.msg.setStringProperty("myProp", "123");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void likeTest21() throws Exception {
        try {
            String selector = "myProp LIKE 7";
            String value = "";
            this.startTest(selector, value);
            throw new Exception("Did not receive InvalidSelectorException");
        }
        catch (InvalidSelectorException ise) {
            this.logTrace("Caught expected exception");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void isNullTest1() throws Exception {
        try {
            String selector = "myNullProp IS NULL";
            String value = "";
            this.startTest(selector, value);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void isNullTest2() throws Exception {
        try {
            String selector = "myProp IS NULL";
            String value = "";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp", "foo");
            this.sendFirstMessage();
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void isNullTest3() throws Exception {
        try {
            String selector = "myProp IS NOT NULL";
            String value = "";
            this.startTest(selector, value);
            this.msg.setFloatProperty("myProp", 10.0f);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void isNullTest4() throws Exception {
        try {
            String selector = "myNullProp IS NOT NULL";
            String value = "";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setStringProperty("myNullProp", "foo");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void caseTest1() throws Exception {
        try {
            String selector = "myProp0 is null and myProp1 like 'fooG_%' escape 'G' and myProp2 in ('a', 'b') and myProp3 not between 0 and 10 and (myProp4 or false)";
            String value = "";
            this.startTest(selector, value);
            this.msg.setStringProperty("myProp1", "foo_test");
            this.msg.setStringProperty("myProp2", "a");
            this.msg.setIntProperty("myProp3", 20);
            this.msg.setBooleanProperty("myProp4", true);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void precedenceTest1() throws Exception {
        try {
            String selector = "NOT myTrueProp AND myFalseProp";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myTrueProp", true);
            this.msg.setBooleanProperty("myFalseProp", false);
            this.sendFirstMessage();
            this.msg.setBooleanProperty("myTrueProp", false);
            this.msg.setBooleanProperty("myFalseProp", true);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void precedenceTest2() throws Exception {
        try {
            String selector = "myTrueProp AND NOT myFalseProp";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myTrueProp", true);
            this.msg.setBooleanProperty("myFalseProp", false);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void precedenceTest3() throws Exception {
        try {
            String selector = "myTrueProp OR myTrueProp AND myFalseProp";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myTrueProp", true);
            this.msg.setBooleanProperty("myFalseProp", false);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void precedenceTest4() throws Exception {
        try {
            String selector = "- myProp0 + myProp1 = 0";
            String value = "";
            this.startTest(selector, value);
            this.msg.setIntProperty("myProp0", 5);
            this.msg.setIntProperty("myProp1", 5);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void precedenceTest5() throws Exception {
        try {
            String selector = "myProp0+myProp1*myProp2-myProp3/myProp4 = 6";
            String value = "";
            this.startTest(selector, value);
            this.msg.setFloatProperty("myProp0", 1.0f);
            this.msg.setFloatProperty("myProp1", 2.0f);
            this.msg.setFloatProperty("myProp2", 3.0f);
            this.msg.setFloatProperty("myProp3", 4.0f);
            this.msg.setFloatProperty("myProp4", 4.0f);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void nullTest01() throws Exception {
        try {
            String selector = "myProp + 2 < 10";
            String value = "";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setIntProperty("myProp", 0);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void nullTest02() throws Exception {
        try {
            String selector = "myProp = 'foo'";
            String value = "";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setStringProperty("myProp", "foo");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void nullTest03() throws Exception {
        try {
            String selector = "myProp NOT IN ('a', 'b')";
            String value = "";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setStringProperty("myProp", "foo");
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void nullTest04() throws Exception {
        try {
            String selector = "myTrueProp AND myTrueProp";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myTrueProp", true);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void nullTest05() throws Exception {
        try {
            String selector = "(myTrueProp AND myFalseProp) OR (myTrueProp AND myNullProp) OR (myFalseProp AND myTrueProp) OR (myFalseProp AND myFalseProp) OR (myFalseProp AND myNullProp) OR (MyNullProp AND myTrueProp) OR (MyNullProp AND myFalseProp) OR (MyNullProp AND myNullProp)";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myTrueProp", true);
            this.msg.setBooleanProperty("myFalseProp", false);
            this.sendFirstMessage();
            this.msg.setBooleanProperty("myTrueProp", true);
            this.msg.setBooleanProperty("myFalseProp", true);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void nullTest06() throws Exception {
        try {
            String selector = "(myTrueProp OR myTrueProp) AND (myTrueProp OR myFalseProp) AND (myTrueProp OR myNullProp) AND (myFalseProp OR myTrueProp) AND (myNullProp OR myTrueProp)";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myTrueProp", true);
            this.msg.setBooleanProperty("myFalseProp", false);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void nullTest07() throws Exception {
        try {
            String selector = "(myFalseProp OR myFalseProp) OR (myFalseProp OR myNullProp) OR (myNullProp OR myFalseProp) OR (myNullProp OR myNullProp)";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myFalseProp", false);
            this.sendFirstMessage();
            this.msg.setBooleanProperty("myFalseProp", true);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void nullTest08() throws Exception {
        try {
            String selector = "NOT myFalseProp";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myFalseProp", false);
            this.finishTestReceive();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void nullTest09() throws Exception {
        try {
            String selector = "NOT myTrueProp";
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myTrueProp", true);
            this.sendFirstMessage();
            this.msg.setBooleanProperty("myTrueProp", false);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void nullTest10() throws Exception {
        try {
            String selector = "NOT myNullProp";
            String value = "";
            this.startTest(selector, value);
            this.sendFirstMessage();
            this.msg.setBooleanProperty("myNullProp", false);
            this.finishTest();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("test failed");
        }
    }

    public void nullTest11() throws Exception {
        try {
            String selector = null;
            String value = "";
            this.startTest(selector, value);
            this.msg.setBooleanProperty("myNullProp", false);
            this.finishTest();
        }
        catch (Exception e) {
            throw new Exception("test failed", e);
        }
    }
}

