/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.platform.managedbean299;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;
import com.sun.ts.tests.jaxrs.platform.managedbean299.ApplicationHolderSingleton;
import com.sun.ts.tests.jaxrs.platform.managedbean299.Resource;
import com.sun.ts.tests.jaxrs.platform.managedbean299.StringBuilderProvider;
import com.sun.ts.tests.jaxrs.platform.managedbean299.TSAppConfig;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jaxrs"), @Tag(value="platform"), @Tag(value="web")})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 6991563942877137460L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_platform_managedbean299_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_platform_managedbean299_web.war");
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("com/sun/ts/tests/jaxrs/platform/managedbean299/beans.xml");
        String beansXml = JAXRSClientIT.toString(inStream);
        archive.addClasses(new Class[]{Resource.class, TSAppConfig.class, ApplicationHolderSingleton.class, StringBuilderProvider.class});
        archive.addAsWebInfResource((Asset)new StringAsset(beansXml), "beans.xml");
        archive.addAsWebInfResource(JAXRSClientIT.class.getPackage(), "jaxrs_platform_managedbean299_web.xml", "web.xml");
        return archive;
    }

    @Test
    public void postConstructTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "root"));
        this.setProperty("SEARCH_STRING", "999");
        this.invoke();
    }

    @Test
    public void applicationCDIManagedBeanTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "app"));
        this.setProperty("SEARCH_STRING", "1000");
        this.invoke();
    }

    @Test
    public void providerCDIManagedBeanTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "provider"));
        this.setProperty("SEARCH_STRING", "1001");
        this.invoke();
    }

    @Test
    public void jaxrsInjectPriorPostConstructOnRootResourceTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "priorroot"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.valueOf(true));
        this.invoke();
    }

    @Test
    public void jaxrsInjectPriorPostConstructOnApplicationTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "priorapp"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.valueOf(true));
        this.invoke();
    }

    @Test
    public void jaxrsInjectPriorPostConstructOnProviderTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "priorprovider"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.valueOf(true));
        this.invoke();
    }

    @Test
    public void noInjectOrResourceKeywordTest() throws Exception {
        String req = this.buildRequest(JAXRSCommonClient.Request.GET, "nokeyword;matrix=", String.valueOf(6991563942877137460L));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, req);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.valueOf(6991563942877137460L));
        this.invoke();
    }
}

