/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.javamail.ee.multipart;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.javamail.ee.common.MailTestUtil;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="mail"), @Tag(value="platform")})
public class multipart_Test
extends ServiceEETest
implements Serializable {
    static String msgText1 = "This is a message body.\nHere's line two.";
    static String msgText2 = "This is the text in the message attachment.";
    private String transport_protocol = null;
    private String mailTo = null;
    private String user;
    private String password;
    private transient Session session;
    private String host;
    private transient MailTestUtil mailTestUtil;

    public static void main(String[] args) {
        multipart_Test theTests = new multipart_Test();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties props) throws Exception {
        try {
            this.mailTo = props.getProperty("mailuser1");
            if (this.mailTo.length() == 0) {
                throw new Exception("Invalid mailuser1 - the mail to property");
            }
            this.transport_protocol = props.getProperty("transport_protocol");
            if (this.transport_protocol.length() == 0) {
                throw new Exception("Invalid transport_protocol");
            }
            String protocol = TestUtil.getProperty((String)"javamail.protocol");
            this.host = TestUtil.getProperty((String)"javamail.server");
            this.user = TestUtil.getProperty((String)"javamail.username");
            this.password = TestUtil.getProperty((String)"javamail.password");
            String mailbox = TestUtil.getProperty((String)"javamail.mailbox");
            String rootPath = TestUtil.getProperty((String)"javamail.root.path");
            String smtpPortStr = TestUtil.getProperty((String)"smtp.port");
            int smtpPort = Integer.parseInt(smtpPortStr);
            TestUtil.logTrace((String)("SMTP Port = " + smtpPort));
            String imapPortStr = TestUtil.getProperty((String)"imap.port");
            int imapPort = Integer.parseInt(imapPortStr);
            TestUtil.logTrace((String)("IMAP Port = " + imapPort));
            this.mailTestUtil = new MailTestUtil();
            this.session = this.mailTestUtil.createSession(this.host, smtpPortStr, this.user, this.password);
        }
        catch (Exception e) {
            this.logErr("Exception : " + e.getMessage());
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testAddBodyPart1() throws Exception {
        String msgText = "Testing addBodyPart(BodyPart).\nPASS.";
        try {
            MimeMessage msg = new MimeMessage(this.session);
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(this.mailTo)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setSubject("TestAddBodyPart1()" + new Date());
            MimeBodyPart mbp1 = new MimeBodyPart();
            mbp1.setText(msgText1);
            MimeBodyPart mbp2 = new MimeBodyPart();
            mbp2.setText(msgText2, "us-ascii");
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbp1);
            mp.addBodyPart((BodyPart)mbp2);
            mp.addBodyPart((BodyPart)mbp1);
            if (mp.getCount() != 3) {
                throw new Exception("Multipart1: count incorrect- failed\n");
            }
            TestUtil.logTrace((String)"Multipart1: passed.\n");
            TestUtil.logTrace((String)("Count returned is : " + mp.getCount()));
            msg.setContent((Multipart)mp);
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Call to testAddBodyPart1 Failed!", e);
        }
    }

    public void testAddBodyPart2() throws Exception {
        try {
            MimeMessage msg = new MimeMessage(this.session);
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(this.mailTo)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setSubject("testAddBodyPart2()" + new Date());
            MimeBodyPart mbp1 = new MimeBodyPart();
            mbp1.setText(msgText1);
            MimeBodyPart mbp2 = new MimeBodyPart();
            mbp2.setText(msgText2, "us-ascii");
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbp1, 0);
            mp.addBodyPart((BodyPart)mbp2, 1);
            mp.addBodyPart((BodyPart)mbp1, 2);
            mp.addBodyPart((BodyPart)mbp2, 3);
            if (mp.getCount() != 4) {
                throw new Exception("Multipart2: count incorrect- failed\n");
            }
            TestUtil.logTrace((String)"Multipart2: passed.\n");
            TestUtil.logTrace((String)("Count returned is : " + mp.getCount()));
            msg.setContent((Multipart)mp);
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Call to testAddBodyPart2 Failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            this.logMsg("Cleanup ;");
        }
        catch (Exception e) {
            this.logErr("An error occurred in cleanup!", e);
        }
    }
}

