/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.derivedid.ex2b;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.derivedid.ex2b.DID2bDependent;
import ee.jakarta.tck.persistence.core.derivedid.ex2b.DID2bDependentId;
import ee.jakarta.tck.persistence.core.derivedid.ex2b.DID2bEmployee;
import ee.jakarta.tck.persistence.core.derivedid.ex2b.DID2bEmployeeId;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void DIDTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            DID2bEmployeeId eId1 = new DID2bEmployeeId("Java", "Duke");
            DID2bEmployeeId eId2 = new DID2bEmployeeId("C", "foo");
            DID2bEmployee employee1 = new DID2bEmployee(eId1);
            DID2bEmployee employee2 = new DID2bEmployee(eId2);
            DID2bDependent dep1 = new DID2bDependent(new DID2bDependentId("Obama", eId1), employee1);
            DID2bDependent dep2 = new DID2bDependent(new DID2bDependentId("Michelle", eId1), employee1);
            DID2bDependent dep3 = new DID2bDependent(new DID2bDependentId("John", eId2), employee2);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().flush();
            this.logTrace("persisted Employees and Dependents");
            DID2bDependent newDependent = (DID2bDependent)this.getEntityManager().find(DID2bDependent.class, (Object)new DID2bDependentId("Obama", new DID2bEmployeeId("Java", "Duke")));
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID2bDependent d where d.id.name='Obama' and d.emp.firstName='Java'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID2bDependent)depList.get(0);
                if (newDependent == dep1) {
                    pass1 = true;
                    this.logTrace("Received Expected Dependent");
                } else {
                    this.logErr("Searched Dependent not found");
                }
            } else {
                this.logErr("getEntityManager().createQuery returned null entry");
            }
            List depList2 = this.getEntityManager().createQuery("Select d from DID2bDependent d where d.id.name='Obama' and d.id.empPK.firstName='Java'").getResultList();
            DID2bDependent newDependent2 = null;
            if (depList2.size() > 0) {
                newDependent2 = (DID2bDependent)depList2.get(0);
                if (newDependent2 == dep1) {
                    pass2 = true;
                    this.logTrace("Received Expected Dependent");
                } else {
                    this.logErr("Searched Dependent not found");
                }
            } else {
                this.logErr("getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            this.getEntityTransaction().rollback();
        }
        if (!pass1 || !pass2) {
            throw new Exception("DTDTest failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID2BDEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID2BEMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

