/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.closedQueueConnection;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClosedQueueConnectionTestsIT {
    private static final String TestName = "com.sun.ts.tests.jms.core.appclient.closedQueueConnection.ClosedQueueConnectionTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClosedQueueConnectionTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    private void createAndCloseConnection(int type) throws Exception {
        if (type == 0 || type == 2) {
            this.tool = new JmsTool(type, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Closing queue Connection");
            this.tool.getDefaultQueueConnection().close();
        }
        logger.log(System.Logger.Level.TRACE, "Connection closed");
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'users' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' is null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void closedQueueConnectionSetClientIDTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call setClientID");
            try {
                this.tool.getDefaultQueueConnection().setClientID("foo");
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSetClientIDTest", e);
        }
    }

    @Test
    public void closedQueueConnectionSetExceptionListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call setExceptionListener");
            try {
                ExceptionListener foo = new ExceptionListener(){

                    public void onException(JMSException jmsE) {
                    }
                };
                this.tool.getDefaultQueueConnection().setExceptionListener(foo);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSetExceptionListenerTest", e);
        }
    }

    @Test
    public void closedQueueConnectionGetMessageListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call getMessageListener");
            try {
                MessageListener foo = this.tool.getDefaultQueueReceiver().getMessageListener();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionGetMessageListenerTest", e);
        }
    }

    @Test
    public void closedQueueConnectionSetMessageListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call setMessageListener");
            try {
                MessageListener foo = new MessageListener(){

                    public void onMessage(Message m) {
                    }
                };
                this.tool.getDefaultQueueReceiver().setMessageListener(foo);
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionSetMessageListenerTest", e);
        }
    }

    @Test
    public void closedQueueConnectionGetExceptionListenerTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call getExceptionListener");
            try {
                ExceptionListener foo = this.tool.getDefaultQueueConnection().getExceptionListener();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionGetExceptionListenerTest", e);
        }
    }

    @Test
    public void closedQueueConnectionStopTest() throws Exception {
        boolean passed = false;
        try {
            this.createAndCloseConnection(0);
            logger.log(System.Logger.Level.TRACE, "Try to call stop");
            try {
                this.tool.getDefaultQueueConnection().stop();
                logger.log(System.Logger.Level.TRACE, "Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new Exception("closedQueueConnectionStopTest", e);
        }
    }

    @Test
    public void closedQueueConnectionAckTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            QueueSession qSession = null;
            QueueReceiver qReceiver = null;
            QueueSender qSender = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueSession().close();
            logger.log(System.Logger.Level.TRACE, "Creating new session");
            qSession = this.tool.getDefaultQueueConnection().createQueueSession(false, 2);
            qReceiver = qSession.createReceiver(this.tool.getDefaultQueue());
            qSender = qSession.createSender(this.tool.getDefaultQueue());
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating 1 TextMessage");
            messageSent = qSession.createTextMessage();
            messageSent.setText("Message from closedQueueConnectionAckTest");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "closedQueueConnectionAckTest");
            logger.log(System.Logger.Level.INFO, "Sending a TextMessage");
            qSender.send((Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving TextMessage");
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "Closing DefaultQueueConnection");
            qReceiver.close();
            qSender.close();
            qSession.close();
            this.tool.getDefaultQueueConnection().close();
            try {
                if (messageReceived == null) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Didnot receive any message!!");
                } else {
                    messageReceived.acknowledge();
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Should not be here!");
                }
            }
            catch (IllegalStateException is) {
                logger.log(System.Logger.Level.INFO, "Pass: IllegalStateException thrown by acknowledge as expected");
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Expected IllegalStateException, got", (Throwable)e);
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueConnectionAckTest");
        }
    }
}

