/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.messageProducer;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MessageProducerTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.messageProducer.MessageProducerTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(MessageProducerTestsIT.class.getName());
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;

    @BeforeEach
    public void setup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "In setup");
            this.jmsUser = System.getProperty("user");
            this.jmsPassword = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in must be > 0");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        if (this.tool != null) {
            try {
                if (this.tool.getDefaultConnection() != null) {
                    logger.log(System.Logger.Level.TRACE, "Closing default Connection");
                    this.tool.getDefaultConnection().close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection in cleanup: ", (Throwable)e);
            }
        }
    }

    private void flushTheQueue() throws Exception {
        try {
            if (this.tool != null && this.tool.getDefaultConnection() != null) {
                this.cleanup();
            }
            this.tool = new JmsTool(13, this.jmsUser, this.jmsPassword, this.mode);
            logger.log(System.Logger.Level.TRACE, "Closing default Connection");
            this.tool.getDefaultConnection().close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error closing connection and creating JmsTool: ", (Throwable)e);
        }
        finally {
            try {
                this.tool.flushDestination();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error flush Destination: ", (Throwable)e);
            }
        }
    }

    @Test
    public void sendQueueTest1() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String testName = "sendQueueTest1";
            String testMessage = "Just a test from sendQueueTest1";
            boolean pass = true;
            MessageProducer msgproducer = null;
            this.tool = new JmsTool(13, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultProducer().close();
            msgproducer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.tool.getDefaultConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText(testMessage);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            logger.log(System.Logger.Level.INFO, "Sending message");
            msgproducer.send(this.tool.getDefaultDestination(), (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("didn't get any message");
            }
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
        finally {
            try {
                this.flushTheQueue();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error flushing Queue", (Throwable)e);
            }
        }
    }

    @Test
    public void sendQueueTest2() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String testName = "sendQueueTest2";
            String testMessage = "Just a test from sendQueueTest2";
            boolean pass = true;
            MessageProducer msgproducer = null;
            this.tool = new JmsTool(13, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultProducer().close();
            msgproducer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.tool.getDefaultConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText(testMessage);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            logger.log(System.Logger.Level.INFO, "Sending message");
            msgproducer.send(this.tool.getDefaultDestination(), (Message)messageSent, 1, 3, 0L);
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "didn't get any message");
                pass = false;
            } else if (!messageReceived.getText().equals(messageSent.getText()) || messageReceived.getJMSDeliveryMode() != 1 || messageReceived.getJMSPriority() != 3) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "didn't get the right message.");
                logger.log(System.Logger.Level.ERROR, "text =" + messageReceived.getText());
                logger.log(System.Logger.Level.ERROR, "DeliveryMode =" + messageReceived.getJMSDeliveryMode());
                logger.log(System.Logger.Level.ERROR, "Priority =" + messageReceived.getJMSPriority());
            }
            if (!pass) {
                throw new Exception(testName + " falied");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
        finally {
            try {
                this.flushTheQueue();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error flushing Queue", (Throwable)e);
            }
        }
    }

    @Test
    public void sendQueueTest3() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String testName = "sendQueueTest3";
            String testMessage = "Just a test from sendQueueTest3";
            boolean pass = true;
            this.tool = new JmsTool(13, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultConnection().start();
            if (!((Queue)this.tool.getDefaultProducer().getDestination()).getQueueName().equals(((Queue)this.tool.getDefaultDestination()).getQueueName())) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getDestination test failed: " + ((Queue)this.tool.getDefaultProducer().getDestination()).getQueueName());
            }
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText(testMessage);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            logger.log(System.Logger.Level.INFO, "Sending message");
            this.tool.getDefaultProducer().send((Message)messageSent, 1, 3, 0L);
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "didn't get any message");
                pass = false;
            } else if (!messageReceived.getText().equals(messageSent.getText()) || messageReceived.getJMSDeliveryMode() != 1 || messageReceived.getJMSPriority() != 3) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "didn't get the right message.");
                logger.log(System.Logger.Level.ERROR, "text =" + messageReceived.getText());
                logger.log(System.Logger.Level.ERROR, "DeliveryMode =" + messageReceived.getJMSDeliveryMode());
                logger.log(System.Logger.Level.ERROR, "Priority =" + messageReceived.getJMSPriority());
            }
            if (!pass) {
                throw new Exception(testName + " falied");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
        finally {
            try {
                this.flushTheQueue();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error flushing Queue", (Throwable)e);
            }
        }
    }

    @Test
    public void sendTopicTest4() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String testName = "sendTopicTest4";
            String testMessage = "Just a test from sendTopicTest4";
            boolean pass = true;
            MessageProducer msgproducer = null;
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultProducer().close();
            msgproducer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
            this.tool.getDefaultConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText(testMessage);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            logger.log(System.Logger.Level.INFO, "Sending message");
            msgproducer.send(this.tool.getDefaultDestination(), (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("didn't get any message");
            }
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
    }

    @Test
    public void sendTopicTest5() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String testName = "sendTopicTest5";
            String testMessage = "Just a test from sendTopicTest5";
            boolean pass = true;
            MessageProducer msgproducer = null;
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultProducer().close();
            msgproducer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
            this.tool.getDefaultConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText(testMessage);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            logger.log(System.Logger.Level.INFO, "Sending message");
            msgproducer.send(this.tool.getDefaultDestination(), (Message)messageSent, 1, 3, 0L);
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "didn't get any message");
                pass = false;
            } else if (!messageReceived.getText().equals(messageSent.getText()) || messageReceived.getJMSDeliveryMode() != 1 || messageReceived.getJMSPriority() != 3) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "didn't get the right message.");
                logger.log(System.Logger.Level.ERROR, "text =" + messageReceived.getText());
                logger.log(System.Logger.Level.ERROR, "DeliveryMode =" + messageReceived.getJMSDeliveryMode());
                logger.log(System.Logger.Level.ERROR, "Priority =" + messageReceived.getJMSPriority());
            }
            if (!pass) {
                throw new Exception(testName + " falied");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
    }

    @Test
    public void sendTopicTest6() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String testName = "sendTopicTest6";
            String testMessage = "Just a test from sendTopicTest6";
            boolean pass = true;
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultConnection().start();
            if (!((Topic)this.tool.getDefaultProducer().getDestination()).getTopicName().equals(((Topic)this.tool.getDefaultDestination()).getTopicName())) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getDestination test failed: " + ((Topic)this.tool.getDefaultProducer().getDestination()).getTopicName());
            }
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText(testMessage);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            logger.log(System.Logger.Level.INFO, "Sending message");
            this.tool.getDefaultProducer().send((Message)messageSent, 1, 3, 0L);
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "didn't get any message");
                pass = false;
            } else if (!messageReceived.getText().equals(messageSent.getText()) || messageReceived.getJMSDeliveryMode() != 1 || messageReceived.getJMSPriority() != 3) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "didn't get the right message.");
                logger.log(System.Logger.Level.ERROR, "text =" + messageReceived.getText());
                logger.log(System.Logger.Level.ERROR, "DeliveryMode =" + messageReceived.getJMSDeliveryMode());
                logger.log(System.Logger.Level.ERROR, "Priority =" + messageReceived.getJMSPriority());
            }
            if (!pass) {
                throw new Exception(testName + " falied");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
    }
}

