/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.objectMsgQueue;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Message;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.ObjectMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ObjectMsgQueueTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.objectMsgQueue.ObjectMsgQueueTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ObjectMsgQueueTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'numConsumers' is null");
            }
            if (this.password == null) {
                throw new Exception("'numProducers' is null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void messageObjectCopyQTest() throws Exception {
        boolean pass = true;
        try {
            ObjectMessage messageSentObject = null;
            ObjectMessage messageReceivedObject = null;
            StringBuffer sBuff = new StringBuffer("This is");
            String initial = "This is";
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSentObject = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentObject.setObject((Serializable)sBuff);
            sBuff.append("a test ");
            messageSentObject.setStringProperty("COM_SUN_JMS_TESTNAME", "messageObjectCopyQTest");
            this.tool.getDefaultQueueSender().send((Message)messageSentObject);
            messageReceivedObject = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "Ensure that changing the object did not change the message");
            StringBuffer s = (StringBuffer)messageReceivedObject.getObject();
            logger.log(System.Logger.Level.TRACE, "s is " + s);
            if (s.toString().equals(initial)) {
                logger.log(System.Logger.Level.TRACE, "Pass: msg was not changed");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: msg was changed!");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("messageObjectCopyQTest");
        }
    }

    @Test
    public void notWritableTest() throws Exception {
        boolean pass = true;
        StringBuffer sBuff = new StringBuffer("This is");
        String testName = "notWritableTest";
        try {
            ObjectMessage messageSentObject = null;
            ObjectMessage messageReceivedObject = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSentObject = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentObject.setObject((Serializable)sBuff);
            messageSentObject.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().send((Message)messageSentObject);
            messageReceivedObject = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            try {
                messageReceivedObject.setObject((Serializable)sBuff);
                logger.log(System.Logger.Level.ERROR, "Error: expected MessageNotWriteableException not thrown");
                pass = false;
            }
            catch (MessageNotWriteableException ex) {
                logger.log(System.Logger.Level.TRACE, "Got expected MessageNotWriteableException");
            }
            if (!pass) {
                throw new Exception(testName);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, testName + " failed: ", (Throwable)e);
            throw new Exception(testName);
        }
    }
}

