/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.objectMsgTopic;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ObjectMsgTopicTestIT {
    private static final String testName = "com.sun.ts.tests.jms.core.objectMsgTopic.ObjectMsgTopicTestIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ObjectMsgTopicTestIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void messageObjectCopyTopicTest() throws Exception {
        boolean pass = true;
        try {
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            StringBuffer sBuff = new StringBuffer("This is");
            String initial = "This is";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)sBuff);
            sBuff.append("a test ");
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "messageObjectCopyTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "Ensure that changing the object did not change the message");
            StringBuffer s = (StringBuffer)messageReceivedObjectMsg.getObject();
            logger.log(System.Logger.Level.TRACE, "s is " + s);
            if (s.toString().equals(initial)) {
                logger.log(System.Logger.Level.TRACE, "Pass: msg was not changed");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: msg was changed!");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("messageObjectCopyTopicTest");
        }
    }
}

