/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.jmsconsumertests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.core20.appclient.jmsconsumertests.MyMessageListener;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.core20.appclient.jmsconsumertests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private transient JmsTool tool = null;
    transient ConnectionFactory cf = null;
    transient JMSContext context = null;
    transient JMSContext contextToSendMsg = null;
    transient JMSContext contextToCreateMsg = null;
    transient JMSConsumer consumer = null;
    transient JMSProducer producer = null;
    transient Destination destination = null;
    transient Queue queue = null;
    transient Topic topic = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    boolean queueTest = false;
    boolean topicTest = false;

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            logger.log(System.Logger.Level.INFO, "Didn't get expected exception");
            throw new Exception("Didn't get expected exception");
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Close JMSContext objects");
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
            if (this.contextToSendMsg != null) {
                this.contextToSendMsg.close();
                this.contextToSendMsg = null;
            }
            if (this.contextToCreateMsg != null) {
                this.contextToCreateMsg.close();
                this.contextToCreateMsg = null;
            }
            logger.log(System.Logger.Level.INFO, "Close JMSConsumer objects");
            if (this.consumer != null) {
                this.consumer.close();
                this.consumer = null;
            }
            logger.log(System.Logger.Level.INFO, "Closing default Connection");
            this.tool.getDefaultConnection().close();
            if (this.queueTest) {
                logger.log(System.Logger.Level.INFO, "Flush any messages left on Queue");
                this.tool.flushDestination();
            }
            this.tool.closeAllResources();
            this.producer = null;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("cleanup failed!", e);
        }
    }

    @Test
    public void queueSendRecvMessageListenerTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON QUEUE");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.tool.getDefaultConnection().close();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            this.queueTest = true;
            logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.contextToSendMsg = this.cf.createContext(this.user, this.password, 1);
            this.contextToCreateMsg = this.cf.createContext(this.user, this.password, 1);
            logger.log(System.Logger.Level.INFO, "Create JMSProducer");
            this.producer = this.contextToSendMsg.createProducer();
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            MyMessageListener listener = new MyMessageListener();
            this.consumer.setMessageListener((MessageListener)listener);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.contextToCreateMsg.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendRecvMessageListenerTest");
            logger.log(System.Logger.Level.INFO, "Send the TestMessage via JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; i < 60; ++i) {
                TestUtil.sleepSec((int)2);
                if (listener.isComplete()) {
                    listener.setComplete(false);
                    actTextMessage = (TextMessage)listener.getMessage();
                    logger.log(System.Logger.Level.INFO, "Received TextMessage after polling loop " + (i + 1));
                    break;
                }
                logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage (actTextMessage=NULL)");
            }
            logger.log(System.Logger.Level.INFO, "Check value of TextMessage returned");
            if (!actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.ERROR, "Received [" + actTextMessage.getText() + "] expected [" + expTextMessage.getText() + "]");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Retreive MessageListener by calling consumer.getMessageListener()");
            MessageListener messageListener = this.consumer.getMessageListener();
            if (messageListener == null) {
                logger.log(System.Logger.Level.ERROR, "getMessageListener() returned NULL");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueSendRecvMessageListenerTest", e);
        }
        if (!pass) {
            throw new Exception("queueSendRecvMessageListenerTest failed");
        }
    }

    @Test
    public void topicSendRecvMessageListenerTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON TOPIC");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.tool.getDefaultConnection().close();
            this.destination = this.tool.getDefaultDestination();
            this.topic = (Topic)this.destination;
            this.topicTest = true;
            logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.contextToSendMsg = this.cf.createContext(this.user, this.password, 1);
            this.contextToCreateMsg = this.cf.createContext(this.user, this.password, 1);
            logger.log(System.Logger.Level.INFO, "Create JMSProducer");
            this.producer = this.contextToSendMsg.createProducer();
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            MyMessageListener listener = new MyMessageListener();
            this.consumer.setMessageListener((MessageListener)listener);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.contextToCreateMsg.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendRecvMessageListenerTest");
            logger.log(System.Logger.Level.INFO, "Send the TestMessage via JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 1; i < 60; ++i) {
                TestUtil.sleepSec((int)2);
                if (listener.isComplete()) {
                    listener.setComplete(false);
                    actTextMessage = (TextMessage)listener.getMessage();
                    logger.log(System.Logger.Level.INFO, "Received TextMessage after polling loop " + i);
                    break;
                }
                logger.log(System.Logger.Level.INFO, "Completed polling loop " + i);
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage (actTextMessage=NULL)");
            }
            logger.log(System.Logger.Level.INFO, "Check value of TextMessage returned");
            if (!actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.ERROR, "Received [" + actTextMessage.getText() + "] expected [" + expTextMessage.getText() + "]");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Retreive MessageListener by calling consumer.getMessageListener()");
            MessageListener messageListener = this.consumer.getMessageListener();
            if (messageListener == null) {
                logger.log(System.Logger.Level.ERROR, "getMessageListener() returned NULL");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicSendRecvMessageListenerTest", e);
        }
        if (!pass) {
            throw new Exception("topicSendRecvMessageListenerTest failed");
        }
    }
}

