/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.jmscontexttopictests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidDestinationRuntimeException;
import jakarta.jms.InvalidSelectorRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.core20.jmscontexttopictests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private transient JmsTool tool = null;
    private transient JmsTool tool2 = null;
    private transient ConnectionFactory cf = null;
    private transient ConnectionFactory cf2 = null;
    private transient Topic topic = null;
    private transient Destination destination = null;
    private transient Topic topic2 = null;
    private transient Destination destination2 = null;
    private transient JMSContext context = null;
    private transient JMSContext context2 = null;
    private transient JMSProducer producer = null;
    private transient JMSProducer producer2 = null;
    private transient JMSConsumer consumer = null;
    private transient JMSConsumer consumer2 = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    String vehicle;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    ArrayList connections = null;

    private boolean verifyMetaData(ConnectionMetaData data) {
        String tmp;
        boolean pass = true;
        try {
            String tmp2 = data.getJMSVersion();
            logger.log(System.Logger.Level.TRACE, "JMSVersion=" + tmp2);
            if (!tmp2.equals("3.1")) {
                logger.log(System.Logger.Level.ERROR, "Error: incorrect JMSVersion=" + tmp2);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp3 = data.getJMSMajorVersion();
            logger.log(System.Logger.Level.TRACE, "JMSMajorVersion=" + tmp3);
            if (tmp3 != 3) {
                logger.log(System.Logger.Level.ERROR, "Error: incorrect JMSMajorVersion=" + tmp3);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp4 = data.getJMSMinorVersion();
            logger.log(System.Logger.Level.TRACE, "JMSMinorVersion=" + tmp4);
            if (tmp4 != 1) {
                logger.log(System.Logger.Level.ERROR, "Error: incorrect JMSMinorVersion=" + tmp4);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSMinorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getJMSProviderName();
            logger.log(System.Logger.Level.TRACE, "JMSProviderName=" + tmp);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSProviderName: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getProviderVersion();
            logger.log(System.Logger.Level.TRACE, "JMSProviderVersion=" + tmp);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp5 = data.getProviderMajorVersion();
            logger.log(System.Logger.Level.TRACE, "ProviderMajorVersion=" + tmp5);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp6 = data.getProviderMinorVersion();
            logger.log(System.Logger.Level.TRACE, "ProviderMinorVersion=" + tmp6);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderMinorVersion: ", (Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean chkMessageID(String id) {
        String[] status = new String[]{"Pass", "Fail"};
        boolean retcode = true;
        int index = 0;
        if (id != null && !id.startsWith("ID:")) {
            index = 1;
            retcode = false;
        }
        logger.log(System.Logger.Level.TRACE, "Results: " + status[index]);
        return retcode;
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            String lookupDurableTopicFactory = "DURABLE_SUB_CONNECTION_FACTORY";
            String lookupNormalTopicFactory = "MyTopicConnectionFactory";
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            this.vehicle = System.getProperty("vehicle");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.connections = new ArrayList(5);
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_T and normal topic connection factory");
            this.tool = new JmsTool(14, this.user, this.password, lookupNormalTopicFactory, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.tool.getDefaultConnection().close();
            this.destination = this.tool.getDefaultDestination();
            this.topic = (Topic)this.destination;
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.producer = this.context.createProducer();
            this.consumer = this.context.createConsumer((Destination)this.topic);
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_T and durable topic connection factory");
            this.tool2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.tool2.getDefaultConnection().close();
            this.cf2 = this.tool2.getConnectionFactory();
            this.destination2 = this.tool2.getDefaultDestination();
            this.topic2 = (Topic)this.destination2;
            this.context2 = this.cf2.createContext(this.user, this.password, 1);
            this.producer2 = this.context2.createProducer();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Close JMSContext Objects");
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
            if (this.context2 != null) {
                this.context2.close();
                this.context2 = null;
            }
            this.producer2 = null;
            this.producer = null;
            logger.log(System.Logger.Level.INFO, "Close JMSConsumer Objects");
            if (this.consumer != null) {
                this.consumer.close();
                this.consumer = null;
            }
            if (this.tool != null) {
                this.tool.closeAllResources();
                this.tool = null;
            }
            if (this.tool2 != null) {
                this.tool2.closeAllResources();
                this.tool2 = null;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("cleanup failed!", e);
        }
    }

    private void cleanupSubscription(JMSConsumer consumer, JMSContext context, String subName) {
        if (consumer != null) {
            try {
                logger.log(System.Logger.Level.TRACE, "Closing durable consumer: " + consumer);
                consumer.close();
                consumer = null;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Exception during JMSConsumer.close: ", (Throwable)e);
            }
        }
        if (context != null) {
            try {
                logger.log(System.Logger.Level.TRACE, "Unsubscribing \"" + subName + "\"");
                context.unsubscribe(subName);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Exception during JMSContext.unsubscribe: ", (Throwable)e);
            }
        }
    }

    @Test
    public void createTemporayTopicTest() throws Exception {
        boolean pass = true;
        JMSConsumer consumer = null;
        try {
            String sendMessage = "a text message";
            logger.log(System.Logger.Level.INFO, "Creating TemporaryTopic");
            TemporaryTopic tempTopic = this.context.createTemporaryTopic();
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer for TemporaryTopic.");
            consumer = this.context.createConsumer((Destination)tempTopic);
            logger.log(System.Logger.Level.INFO, "Send message to temporary topic");
            this.producer.send((Destination)tempTopic, sendMessage);
            logger.log(System.Logger.Level.INFO, "Receive message from temporaty topic");
            String recvMessage = (String)consumer.receiveBody(String.class, this.timeout);
            logger.log(System.Logger.Level.INFO, "Checking received message");
            if (recvMessage == null) {
                throw new Exception("Did not receive Message");
            }
            logger.log(System.Logger.Level.INFO, "Verify correct message received.");
            if (!recvMessage.equals(sendMessage)) {
                logger.log(System.Logger.Level.ERROR, "unexpected message: received " + recvMessage + " , expected " + sendMessage);
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "received correct message: " + recvMessage + " as expected");
            }
            logger.log(System.Logger.Level.INFO, "Attempting to delete temporary topic with an open consumer should not be allowed");
            try {
                tempTopic.delete();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TemporaryTopic.delete() didn't throw expected Exception");
            }
            catch (JMSException em) {
                logger.log(System.Logger.Level.TRACE, "Received expected JMSException: ");
            }
            logger.log(System.Logger.Level.INFO, "Now close the open consumer");
            try {
                consumer.close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception closing JMSConsumer: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Attempting to delete temporary topic with no open consumer should be allowed");
            try {
                tempTopic.delete();
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Received unexpected Exception: ", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("createTemporayTopicTest");
        }
        finally {
            try {
                if (consumer != null) {
                    consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("createTemporayTopicTest failed");
        }
    }

    @Test
    public void getMetaDataTest() throws Exception {
        boolean pass = true;
        ConnectionMetaData data = null;
        try {
            data = this.context.getMetaData();
            if (!this.verifyMetaData(data)) {
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getMetaDataTest failed");
        }
    }

    @Test
    public void getSessionModeTest() throws Exception {
        boolean pass = true;
        JMSContext context = null;
        try {
            context = this.cf.createContext(this.user, this.password);
            int expSessionMode = 1;
            logger.log(System.Logger.Level.INFO, "Calling getSessionMode and expect " + expSessionMode + " to be returned");
            int actSessionMode = context.getSessionMode();
            if (actSessionMode != expSessionMode) {
                logger.log(System.Logger.Level.ERROR, "getSessionMode() returned " + actSessionMode + ", expected " + expSessionMode);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("getSessionModeTest");
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception exception) {}
        }
        int[] expSessionMode = new int[]{0, 1, 2, 3};
        for (int i = 0; i < expSessionMode.length; ++i) {
            if (!(!this.vehicle.equals("ejb") && !this.vehicle.equals("jsp") && !this.vehicle.equals("servlet") || expSessionMode[i] != 0 && expSessionMode[i] != 2)) continue;
            try {
                logger.log(System.Logger.Level.INFO, "Creating context with session mode (" + expSessionMode[i] + ")");
                context = this.cf.createContext(this.user, this.password, expSessionMode[i]);
                logger.log(System.Logger.Level.INFO, "Calling getSessionMode and expect " + expSessionMode[i] + " to be returned");
                int actSessionMode = context.getSessionMode();
                if (actSessionMode == expSessionMode[i]) continue;
                logger.log(System.Logger.Level.ERROR, "getSessionMode() returned " + actSessionMode + ", expected " + expSessionMode[i]);
                pass = false;
                continue;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("getSessionModeTest");
            }
            finally {
                try {
                    if (context != null) {
                        context.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new Exception("getSessionModeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getTransactedTest() throws Exception {
        boolean actTransacted;
        boolean pass = true;
        JMSContext context = null;
        try {
            context = this.cf.createContext(this.user, this.password, 1);
            boolean expTransacted = false;
            logger.log(System.Logger.Level.INFO, "Calling getTransacted and expect " + expTransacted + " to be returned");
            actTransacted = context.getTransacted();
            if (actTransacted != expTransacted) {
                logger.log(System.Logger.Level.ERROR, "getTransacted() returned " + actTransacted + ", expected " + expTransacted);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception e) {}
        }
        if (this.vehicle.equals("appclient") || this.vehicle.equals("standalone")) {
            try {
                context = this.cf.createContext(this.user, this.password, 0);
                boolean expTransacted = true;
                logger.log(System.Logger.Level.INFO, "Calling getTransacted and expect " + expTransacted + " to be returned");
                actTransacted = context.getTransacted();
                if (actTransacted != expTransacted) {
                    logger.log(System.Logger.Level.ERROR, "getTransacted() returned " + actTransacted + ", expected " + expTransacted);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("getTransactedTest");
            }
            finally {
                try {
                    if (context != null) {
                        context.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new Exception("getTransactedTest failed");
        }
    }

    @Test
    public void setGetAutoStartTest() throws Exception {
        boolean actAutoStart;
        boolean expAutoStart;
        boolean pass = true;
        try {
            expAutoStart = true;
            logger.log(System.Logger.Level.INFO, "Calling getAutoStart and expect " + expAutoStart + " to be returned");
            actAutoStart = this.context.getAutoStart();
            if (actAutoStart != expAutoStart) {
                logger.log(System.Logger.Level.ERROR, "getAutoStart() returned " + actAutoStart + ", expected " + expAutoStart);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        try {
            expAutoStart = false;
            logger.log(System.Logger.Level.INFO, "Calling setAutoStart(" + expAutoStart + ")");
            this.context.setAutoStart(expAutoStart);
            logger.log(System.Logger.Level.INFO, "Calling getAutoStart and expect " + expAutoStart + " to be returned");
            actAutoStart = this.context.getAutoStart();
            if (actAutoStart != expAutoStart) {
                logger.log(System.Logger.Level.ERROR, "getAutoStart() returned " + actAutoStart + ", expected " + expAutoStart);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setGetAutoStartTest");
        }
        if (!pass) {
            throw new Exception("setGetAutoStartTest failed");
        }
    }

    @Test
    public void createConsumerTest() throws Exception {
        boolean pass = true;
        JMSConsumer consumerSelect = null;
        try {
            int i;
            TextMessage tempMsg = null;
            Object msgs = null;
            logger.log(System.Logger.Level.INFO, "Create selective JMSConsumer with selector [\"lastMessage=TRUE\"]");
            consumerSelect = this.context.createConsumer(this.destination, "lastMessage=TRUE");
            logger.log(System.Logger.Level.INFO, "Send 3 to Topic");
            for (i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createConsumerTest" + i);
                if (i == 3) {
                    logger.log(System.Logger.Level.INFO, "Set boolean property lastMessage=true");
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    logger.log(System.Logger.Level.INFO, "Set boolean property lastMessage=false");
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send(this.destination, (Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Receive last message with selective JMSConsumer and boolean property lastMessage=true");
            tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            if (tempMsg == null) {
                logger.log(System.Logger.Level.ERROR, "JMSConsumer.receive() returned NULL");
                logger.log(System.Logger.Level.ERROR, "Message 3 missing from Topic");
                pass = false;
            } else if (!tempMsg.getText().equals("Message 3")) {
                logger.log(System.Logger.Level.ERROR, "Received [" + tempMsg.getText() + "] expected [Message 3]");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Received expected message: " + tempMsg.getText());
            }
            logger.log(System.Logger.Level.INFO, "Try receiving one more message (should get none)");
            tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "JMSConsumer received message " + tempMsg.getText() + " (Expected None)");
                logger.log(System.Logger.Level.ERROR, "JMSConsumer with selector should have returned just 1 message");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Received no more messages (CORRECT)");
            }
            consumerSelect.close();
            consumerSelect = null;
            logger.log(System.Logger.Level.INFO, "Receive rest of messages with normal JMSConsumer");
            for (int msgCount = 1; msgCount <= 3; ++msgCount) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
                if (tempMsg == null) {
                    logger.log(System.Logger.Level.ERROR, "JMSConsumer.receive() returned NULL");
                    logger.log(System.Logger.Level.ERROR, "Message " + msgCount + " missing from Topic");
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    logger.log(System.Logger.Level.ERROR, "Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]");
                    pass = false;
                    continue;
                }
                logger.log(System.Logger.Level.INFO, "Received message: " + tempMsg.getText());
            }
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "Try receiving one more message (should get none)");
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "JMSConsumer received message " + tempMsg.getText() + " (Expected None)");
                logger.log(System.Logger.Level.ERROR, "JMSConsumer should have returned just 2 messages");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Received no more messages (CORRECT)");
            }
            logger.log(System.Logger.Level.INFO, "Create selective JMSConsumer with selector [\"lastMessage=TRUE\"] and noLocal=false");
            consumerSelect = this.context.createConsumer((Destination)this.topic, "lastMessage=TRUE", false);
            logger.log(System.Logger.Level.INFO, "Send 3 to Topic");
            for (i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createConsumerTest" + i);
                if (i == 3) {
                    logger.log(System.Logger.Level.INFO, "Set boolean property lastMessage=true");
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    logger.log(System.Logger.Level.INFO, "Set boolean property lastMessage=false");
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send(this.destination, (Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Receive last message with selective JMSConsumer and boolean property lastMessage=true");
            tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            if (tempMsg == null) {
                logger.log(System.Logger.Level.ERROR, "JMSConsumer.receive() returned NULL");
                logger.log(System.Logger.Level.ERROR, "Message 3 missing from Topic");
                pass = false;
            } else if (!tempMsg.getText().equals("Message 3")) {
                logger.log(System.Logger.Level.ERROR, "Received [" + tempMsg.getText() + "] expected [Message 3]");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Received expected message: " + tempMsg.getText());
            }
            logger.log(System.Logger.Level.INFO, "Try receiving one more message (should get none)");
            tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "JMSConsumer received message " + tempMsg.getText() + " (Expected None)");
                logger.log(System.Logger.Level.ERROR, "JMSConsumer with selector should have returned just 1 message");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Received no more messages (CORRECT)");
            }
            consumerSelect.close();
            consumerSelect = null;
            logger.log(System.Logger.Level.INFO, "Create selective JMSConsumer with selector [\"lastMessage=TRUE\"] and noLocal=true");
            consumerSelect = this.context.createConsumer((Destination)this.topic, "lastMessage=TRUE", true);
            logger.log(System.Logger.Level.INFO, "Send 3 to Topic");
            for (i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createConsumerTest" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send(this.destination, (Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Try receiving a message with selective JMSConsumer (should get none)");
            tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            if (tempMsg == null) {
                logger.log(System.Logger.Level.INFO, "Received no message (CORRECT)");
            } else {
                logger.log(System.Logger.Level.ERROR, "JMSConsumer received message " + tempMsg.getText() + " (Expected None)");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("createConsumerTest");
        }
        finally {
            try {
                if (consumerSelect != null) {
                    consumerSelect.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("createConsumerTest failed");
        }
    }

    @Test
    public void createDurableConsumerTest1() throws Exception {
        boolean pass = true;
        String message1 = "Where are you!";
        String message2 = "Who are you!";
        String durableSubscriptionName = "createDurableConsumerTest1";
        try {
            TextMessage expTextMessage = null;
            logger.log(System.Logger.Level.INFO, "Create a Durable Subscription and a MessageConsumer for it");
            this.consumer2 = this.context2.createDurableConsumer(this.topic, durableSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Send TextMessage message1 to Topic");
            expTextMessage = this.context2.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTest1");
            this.producer2.send(this.destination2, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "TextMessage message1 sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage message1");
            TextMessage actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage message1");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Close durable MessageConsumer");
            this.consumer2.close();
            logger.log(System.Logger.Level.INFO, "Send TextMessage message2 to Topic");
            expTextMessage = this.context2.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTest1");
            this.producer2.send(this.destination2, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "TextMessage message2 sent");
            logger.log(System.Logger.Level.INFO, "Recreate a Durable Subscription and a MessageConsumer for it");
            this.consumer2 = this.context2.createDurableConsumer(this.topic, durableSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage message2");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage message2");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("createDurableConsumerTest1", e);
        }
        finally {
            try {
                this.cleanupSubscription(this.consumer2, this.context2, durableSubscriptionName);
                this.producer2 = null;
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("createDurableConsumerTest1 failed");
        }
    }

    @Test
    public void createDurableConsumerTest2() throws Exception {
        TextMessage tempMsg;
        boolean pass = true;
        String message = "Where are you!";
        String durableSubscriptionName = "createDurableConsumerTest2";
        try {
            logger.log(System.Logger.Level.INFO, "Create a Durable Subscription and a MessageConsumer with message selector, noLocal=false");
            this.consumer2 = this.context2.createDurableConsumer(this.topic, durableSubscriptionName, "lastMessage = TRUE", false);
            logger.log(System.Logger.Level.INFO, "Send 3 messages to Topic");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTest2" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer2.send(this.destination2, (Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            logger.log(System.Logger.Level.INFO, "This is noLacal=false case so expect to get just last message");
            TextMessage expTextMessage = this.context2.createTextMessage("Message 3");
            TextMessage actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("createDurableConsumerTest2", e);
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create a Durable Subscription and a MessageConsumer with message selector, noLocal=true");
            this.consumer2 = this.context2.createDurableConsumer(this.topic, durableSubscriptionName, "lastMessage = TRUE", true);
            logger.log(System.Logger.Level.INFO, "Send 3 messages to Topic");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.context2.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTest2" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer2.send(this.destination2, (Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                logger.log(System.Logger.Level.ERROR, "Message was delivered when noLocal=true");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createDurableConsumerTest2", e);
        }
        finally {
            try {
                this.cleanupSubscription(this.consumer2, this.context2, durableSubscriptionName);
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("createDurableConsumerTest2 failed");
        }
    }

    @Test
    public void createSharedDurableConsumerTest1() throws Exception {
        boolean pass = true;
        String message1 = "Message1!";
        String message2 = "Message2!";
        String durableSubscriptionName = "createSharedDurableConsumerTest1";
        try {
            this.consumer.close();
            TextMessage expTextMessage = null;
            logger.log(System.Logger.Level.INFO, "Create a shared Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.context2.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Create 2nd JMSConsumer for it");
            this.consumer2 = this.context2.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Send TextMessage message1 to Topic");
            expTextMessage = this.context2.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTest1");
            this.producer2.send(this.destination2, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "TextMessage message1 sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage message1 from consumer1");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage message1");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Close 1st shared durable JMSConsumer");
            this.consumer.close();
            logger.log(System.Logger.Level.INFO, "Send TextMessage message2 to Topic");
            expTextMessage = this.context2.createTextMessage(message2);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTest1");
            this.producer2.send(this.destination2, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "TextMessage message2 sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage message2 from consumer2");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage message2");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Now there should be no more messages to receive from topic");
            logger.log(System.Logger.Level.INFO, "Recreate Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.context2.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Try and receive a message from consumer1 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                logger.log(System.Logger.Level.ERROR, "Consumer1 received a message (FAIL)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Consumer1 didn't receive a message (PASS)");
            }
            logger.log(System.Logger.Level.INFO, "Try and receive a message from consumer2 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                logger.log(System.Logger.Level.ERROR, "Consumer2 received a message (FAIL)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Consumer2 didn't receive a message (PASS)");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createSharedDurableConsumerTest1", e);
        }
        finally {
            try {
                this.producer2 = null;
                if (this.consumer != null) {
                    this.consumer.close();
                }
                this.cleanupSubscription(this.consumer2, this.context2, durableSubscriptionName);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        if (!pass) {
            throw new Exception("createSharedDurableConsumerTest1 failed");
        }
    }

    @Test
    public void createSharedDurableConsumerTest2() throws Exception {
        boolean pass = true;
        String durableSubscriptionName = "createSharedDurableConsumerTest2";
        try {
            this.consumer.close();
            logger.log(System.Logger.Level.INFO, "Create shared Durable Subscription and 1st JMSConsumer with message selector");
            this.consumer = this.context2.createSharedDurableConsumer(this.topic, durableSubscriptionName, "lastMessage = TRUE");
            logger.log(System.Logger.Level.INFO, "Create 2nd JMSConsumer with message selector");
            this.consumer2 = this.context2.createSharedDurableConsumer(this.topic, durableSubscriptionName, "lastMessage = TRUE");
            logger.log(System.Logger.Level.INFO, "Send 3 messages to Topic");
            for (int i = 1; i <= 3; ++i) {
                TextMessage tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTest2" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer2.send(this.destination2, (Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Receive TextMessage from consumer1");
            TextMessage expTextMessage = this.context2.createTextMessage("Message 3");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createSharedDurableConsumerTest2", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        if (!pass) {
            throw new Exception("createSharedDurableConsumerTest2 failed");
        }
    }

    @Test
    public void createSharedDurableConsumerTest3() throws Exception {
        boolean pass = true;
        String message1 = "Message1!";
        String message2 = "Message2!";
        String durableSubscriptionName = "createSharedDurableConsumerTest3";
        try {
            this.consumer.close();
            TextMessage expTextMessage = null;
            logger.log(System.Logger.Level.INFO, "Create a shared Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.context.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Create 2nd JMSConsumer for it");
            this.consumer2 = this.context.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Send TextMessage message1 to Topic");
            expTextMessage = this.context.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTest3");
            this.producer2.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "TextMessage message1 sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage message1 from consumer1");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage message1");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Close 1st shared durable JMSConsumer");
            this.consumer.close();
            logger.log(System.Logger.Level.INFO, "Send TextMessage message2 to Topic");
            expTextMessage = this.context.createTextMessage(message2);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTest3");
            this.producer2.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "TextMessage message2 sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage message2 from consumer2");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage message2");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Now there should be no more messages to receive from topic");
            logger.log(System.Logger.Level.INFO, "Recreate Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.context.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Try and receive a message from consumer1 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                logger.log(System.Logger.Level.ERROR, "Consumer1 received a message (FAIL)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Consumer1 didn't receive a message (PASS)");
            }
            logger.log(System.Logger.Level.INFO, "Try and receive a message from consumer2 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                logger.log(System.Logger.Level.ERROR, "Consumer2 received a message (FAIL)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Consumer2 didn't receive a message (PASS)");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createSharedDurableConsumerTest3", e);
        }
        finally {
            try {
                this.producer2 = null;
                if (this.consumer != null) {
                    this.consumer.close();
                }
                this.cleanupSubscription(this.consumer2, this.context, durableSubscriptionName);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        if (!pass) {
            throw new Exception("createSharedDurableConsumerTest3 failed");
        }
    }

    @Test
    public void createSharedConsumerTest1() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        String sharedSubscriptionName = "createSharedConsumerTest1";
        try {
            TextMessage expTextMessage = null;
            logger.log(System.Logger.Level.INFO, "Create a shared non-durable Subscription and a JMSConsumer for it");
            this.consumer.close();
            this.consumer = this.context.createSharedConsumer(this.topic, sharedSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Create a second JMSConsumer for the Subscription");
            this.consumer2 = this.context.createSharedConsumer(this.topic, sharedSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Send message to Topic");
            expTextMessage = this.context.createTextMessage(message);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName);
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Message sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage from consumer1");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Attempt to Receive TextMessage from consumer2 - there should be none");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                throw new Exception("Did receive TextMessage - unexpected.");
            }
            logger.log(System.Logger.Level.INFO, "Did not receive TextMessage - expected.");
            logger.log(System.Logger.Level.INFO, "Send another message to Topic");
            expTextMessage = this.context.createTextMessage(message);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName);
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Message sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage from consumer2");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Attempt to Receive TextMessage from consumer1 - there should be none");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                throw new Exception("Did receive TextMessage - unexpected.");
            }
            logger.log(System.Logger.Level.INFO, "Did not receive TextMessage - expected.");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createSharedConsumerTest1", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.INFO, "Ignoring exception closing consumers: " + e);
            }
        }
        if (!pass) {
            throw new Exception("createSharedConsumerTest1 failed");
        }
    }

    @Test
    public void createSharedConsumerTest2() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        String sharedSubscriptionName = "createSharedConsumerTest2";
        try {
            logger.log(System.Logger.Level.INFO, "Create a shared non-durable Subscription and a JMSConsumer for it");
            this.consumer.close();
            this.consumer = this.context.createSharedConsumer(this.topic, sharedSubscriptionName, "lastMessage = TRUE");
            logger.log(System.Logger.Level.INFO, "Create a second JMSConsumer for the Subscription");
            this.consumer2 = this.context.createSharedConsumer(this.topic, sharedSubscriptionName, "lastMessage = TRUE");
            logger.log(System.Logger.Level.INFO, "Send 3 to Topic");
            for (int i = 1; i <= 3; ++i) {
                TextMessage tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send(this.destination, (Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Receive TextMessage from consumer1");
            TextMessage expTextMessage = this.context.createTextMessage("Message 3");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Attempt to Receive TextMessage from consumer2 - there should be none");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                throw new Exception("Did receive TextMessage - unexpected.");
            }
            logger.log(System.Logger.Level.INFO, "Did not receive TextMessage - expected.");
            logger.log(System.Logger.Level.INFO, "Send 3 to Topic");
            for (int i = 1; i <= 3; ++i) {
                TextMessage tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send(this.destination, (Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Receive TextMessage from consumer2");
            expTextMessage = this.context.createTextMessage("Message 3");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Attempt to Receive TextMessage from consumer1 - there should be none");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                throw new Exception("Did receive TextMessage - unexpected.");
            }
            logger.log(System.Logger.Level.INFO, "Did not receive TextMessage - expected.");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createSharedConsumerTest2", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.INFO, "Ignoring exception closing consumers: " + e);
            }
        }
        if (!pass) {
            throw new Exception("createSharedConsumerTest2 failed");
        }
    }

    @Test
    public void multipleCloseContextTest() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Call close on JMSContext created in setup.");
            this.context.close();
            logger.log(System.Logger.Level.TRACE, "Call close on a JMSContext a second time");
            this.context.close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
            throw new Exception("multipleCloseContextTest");
        }
    }

    @Test
    public void simpleDurableConsumerTest() throws Exception {
        block10: {
            String durableSubscriptionName = "simpleDurableConsumerTest";
            try {
                TextMessage messageSent = null;
                TextMessage messageReceived = null;
                logger.log(System.Logger.Level.INFO, "Create DurableConsumer with subscriber name");
                this.consumer2 = this.context2.createDurableConsumer(this.topic, durableSubscriptionName);
                logger.log(System.Logger.Level.INFO, "Creating and sending 1 message");
                messageSent = this.context2.createTextMessage("just a test");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", durableSubscriptionName);
                this.producer.send(this.destination, (Message)messageSent);
                logger.log(System.Logger.Level.INFO, "Receiving message");
                messageReceived = (TextMessage)this.consumer2.receive(this.timeout);
                if (messageReceived.getText().equals(messageSent.getText())) {
                    logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
                    logger.log(System.Logger.Level.INFO, "Received correct message");
                    break block10;
                }
                throw new Exception("didn't get the right message");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
                throw new Exception("simpleDurableConsumerTest");
            }
            finally {
                try {
                    this.cleanupSubscription(this.consumer2, this.context2, durableSubscriptionName);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Test
    public void inactiveDurableConsumerTopicRecTest() throws Exception {
        block11: {
            String durableSubscriptionName = "inactiveDurableConsumerTopicRecTest";
            try {
                TextMessage messageSent = null;
                TextMessage messageSent2 = null;
                TextMessage messageReceived = null;
                logger.log(System.Logger.Level.INFO, "Create a Durable Subscription and a JMSConsumer for it");
                this.consumer2 = this.context2.createDurableConsumer(this.topic2, durableSubscriptionName);
                logger.log(System.Logger.Level.TRACE, "Creating and sending 1 message");
                messageSent = this.context2.createTextMessage("just a test");
                messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", durableSubscriptionName);
                this.producer2.send(this.destination2, (Message)messageSent);
                logger.log(System.Logger.Level.TRACE, "Receiving message");
                messageReceived = (TextMessage)this.consumer2.receive(this.timeout);
                if (!messageReceived.getText().equals(messageSent.getText())) {
                    throw new Exception("didn't get the right message");
                }
                logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
                logger.log(System.Logger.Level.INFO, "Received correct message");
                this.consumer2.close();
                logger.log(System.Logger.Level.TRACE, "Creating and sending another message");
                messageSent2 = this.context2.createTextMessage("test that messages are durable");
                messageSent2.setStringProperty("COM_SUN_JMS_TESTNAME", durableSubscriptionName);
                this.producer2.send(this.destination2, (Message)messageSent2);
                logger.log(System.Logger.Level.INFO, "Create a Durable Subscription and a JMSConsumer for it");
                this.consumer2 = this.context2.createDurableConsumer(this.topic2, durableSubscriptionName);
                messageReceived = (TextMessage)this.consumer2.receive(this.timeout);
                if (messageReceived.getText().equals(messageSent2.getText())) {
                    logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
                    logger.log(System.Logger.Level.TRACE, "Received correct message");
                    break block11;
                }
                throw new Exception("Received incorrect message.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
                throw new Exception("inactiveDurableConsumerTopicRecTest");
            }
            finally {
                try {
                    this.cleanupSubscription(this.consumer2, this.context2, durableSubscriptionName);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void durableConsumerTopicNoLocalTest() throws Exception {
        JMSConsumer tConNoLocal = null;
        String subscriptionName = "DurableConsumerTopicNoLocalTestSubscription";
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            int i;
            int num = 10;
            Message messageSent = null;
            Message messageReceived = null;
            logger.log(System.Logger.Level.INFO, "Create normal Consumer");
            this.consumer2 = this.context2.createConsumer((Destination)this.topic);
            logger.log(System.Logger.Level.INFO, "Create DurableConsumer with no_local=true");
            tConNoLocal = this.context2.createDurableConsumer(this.topic, subscriptionName, "", true);
            logger.log(System.Logger.Level.INFO, "Sending " + num + " messages to topic");
            messageSent = this.context2.createMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableConsumerTopicNoLocalTest");
            for (i = 0; i < num; ++i) {
                this.producer2.send(this.destination2, messageSent);
            }
            logger.log(System.Logger.Level.INFO, "Attempting to receive messages from normal consumer");
            for (i = 0; i < num; ++i) {
                messageReceived = this.consumer2.receive(this.timeout);
                if (messageReceived == null) {
                    throw new Exception("Should have received message");
                }
                if (messageReceived.getBooleanProperty("lastMessage")) throw new Exception("Received incorrect message lastMessage=true");
                logger.log(System.Logger.Level.INFO, "Received correct message lastMessage=false");
            }
            logger.log(System.Logger.Level.INFO, "Attempting to receive messages from (no_local=true) consumer");
            messageReceived = tConNoLocal.receive(this.timeout);
            if (messageReceived != null) throw new Exception("Received unexpected message (incorrect)");
            logger.log(System.Logger.Level.INFO, "Did not receive message (correct)");
            logger.log(System.Logger.Level.INFO, "Sending " + num + " messages to topic");
            for (i = 0; i < num; ++i) {
                this.producer2.send(this.destination2, messageSent);
            }
            logger.log(System.Logger.Level.INFO, "Close DurableConsumer with no_local=true");
            tConNoLocal.close();
            logger.log(System.Logger.Level.INFO, "Create DurableConsumer with no_local=false");
            tConNoLocal = this.context2.createDurableConsumer(this.topic, subscriptionName, "", false);
            messageReceived = tConNoLocal.receive(this.timeout);
            if (messageReceived != null) throw new Exception("No_local=false consumer received message (unexpected)");
            logger.log(System.Logger.Level.INFO, "No_local=false consumer did not receive any message (expected)");
            logger.log(System.Logger.Level.INFO, "Sending " + num + " messages to topic");
            messageSent = this.context2.createMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableConsumerTopicNoLocalTest");
            for (i = 0; i < num; ++i) {
                this.producer2.send(this.destination2, messageSent);
            }
            logger.log(System.Logger.Level.INFO, "Attempting to receive messages from (no_local=false) consumer");
            for (i = 0; i < num; ++i) {
                messageReceived = tConNoLocal.receive(this.timeout);
                if (messageReceived == null) {
                    throw new Exception("Should have received message");
                }
                if (messageReceived.getBooleanProperty("lastMessage")) throw new Exception("Received incorrect message lastMessage=true");
                logger.log(System.Logger.Level.INFO, "Received correct message lastMessage=false");
            }
            messageReceived = tConNoLocal.receive(this.timeout);
            if (messageReceived != null) {
                throw new Exception("Received unexpected final message");
            }
        }
        catch (Exception e) {
            try {
                logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
                throw new Exception("durableConsumerTopicNoLocalTest2");
            }
            catch (Throwable throwable) {
                try {
                    if (this.consumer2 != null) {
                        this.consumer2.close();
                    }
                    this.cleanupSubscription(tConNoLocal, this.context2, subscriptionName);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (this.consumer2 != null) {
                this.consumer2.close();
            }
            this.cleanupSubscription(tConNoLocal, this.context2, subscriptionName);
            return;
        }
        catch (Exception num) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void durableConsumerChangeSelectorTest() throws Exception {
        JMSConsumer durableCon = null;
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent2332 = null;
            TextMessage messageReceived = null;
            logger.log(System.Logger.Level.INFO, "Create DurableConsumer with MessageSelector=TEST='test' and no_local=false");
            durableCon = this.context2.createDurableConsumer(this.topic, "durableConsumerChangeSelectorTest", "TEST = 'test'", false);
            logger.log(System.Logger.Level.INFO, "Send and receive the message");
            messageSent2332 = this.context2.createTextMessage();
            messageSent2332.setStringProperty("TEST", "test");
            messageSent2332.setStringProperty("COM_SUN_JMS_TESTNAME", "durableConsumerChangeSelectorTest");
            messageSent2332.setText("For default topic ");
            this.producer2.send(this.destination2, (Message)messageSent2332);
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = (TextMessage)durableCon.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent2332.getText())) throw new Exception("didn't get the right message");
            logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.INFO, "Received correct message");
            durableCon.close();
            logger.log(System.Logger.Level.INFO, "Create DurableConsumer with new MessageSelector=TEST='new one' and no_local=false");
            durableCon = this.context2.createDurableConsumer(this.topic, "durableConsumerChangeSelectorTest", "TEST = 'new one'", false);
            messageSent2332.setBooleanProperty("lastMessage", false);
            this.producer2.send(this.destination2, (Message)messageSent2332);
            messageSent2332 = this.context2.createTextMessage();
            messageSent2332.setStringProperty("TEST", "new one");
            messageSent2332.setStringProperty("COM_SUN_JMS_TESTNAME", "durableConsumerChangeSelectorTest");
            messageSent2332.setText("For new topic");
            messageSent2332.setBooleanProperty("lastMessage", true);
            this.producer2.send(this.destination2, (Message)messageSent2332);
            messageReceived = (TextMessage)durableCon.receive(this.timeout);
            if (messageReceived == null) throw new Exception("didn't get any message");
            if (!messageReceived.getText().equals(messageSent2332.getText())) throw new Exception("didn't get the right message");
            if (!messageReceived.getBooleanProperty("lastMessage")) throw new Exception("didn't get the right message");
            logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.INFO, "Received correct message");
        }
        catch (Exception e) {
            try {
                logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
                throw new Exception("durableConsumerChangeSelectorTest");
            }
            catch (Throwable throwable) {
                try {
                    this.cleanupSubscription(durableCon, this.context2, "durableConsumerChangeSelectorTest");
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.cleanupSubscription(durableCon, this.context2, "durableConsumerChangeSelectorTest");
            return;
        }
        catch (Exception messageSent2332) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void durableConsumerChangeSelectorTest2() throws Exception {
        JMSConsumer durableCon = null;
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent3332 = null;
            TextMessage messageSent2 = null;
            TextMessage messageReceived = null;
            logger.log(System.Logger.Level.INFO, "Create durable subscription with MessageSelector=\"TEST='test'\",");
            logger.log(System.Logger.Level.INFO, "TopicName=" + this.topic.getTopicName() + " and SubscriptionName=durableConsumerChangeSelectorTest2");
            durableCon = this.context2.createDurableConsumer(this.topic, "durableConsumerChangeSelectorTest2", "TEST = 'test'", false);
            logger.log(System.Logger.Level.INFO, "Create/Send first message with string property \"TEST = 'test'\"");
            messageSent3332 = this.context2.createTextMessage();
            messageSent3332.setStringProperty("TEST", "test");
            messageSent3332.setStringProperty("COM_SUN_JMS_TESTNAME", "durableConsumerChangeSelectorTest2");
            messageSent3332.setText("Message #1 with string property TEST='test'");
            this.producer2.send(this.destination, (Message)messageSent3332);
            logger.log(System.Logger.Level.INFO, "Create/Send second message with string property \"TEST = 'test again'\"");
            messageSent2 = this.context2.createTextMessage();
            messageSent2.setStringProperty("TEST", "test again");
            messageSent2.setStringProperty("COM_SUN_JMS_TESTNAME", "durableConsumerChangeSelectorTest2");
            messageSent2.setText("Message #2 with string property TEST='test again'");
            this.producer2.send(this.destination, (Message)messageSent2);
            logger.log(System.Logger.Level.INFO, "Try receiving first message (should get message)");
            messageReceived = (TextMessage)durableCon.receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.INFO, "Did not receive any message (incorrect)");
                throw new Exception("didn't receive any message");
            }
            if (!messageReceived.getText().equals(messageSent3332.getText())) {
                logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.INFO, "Received correct first message");
            logger.log(System.Logger.Level.INFO, "Try receiving second message (should not get message)");
            messageReceived = (TextMessage)durableCon.receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.INFO, "Did not receive second message (correct)");
                logger.log(System.Logger.Level.INFO, "Close durable subscription");
                durableCon.close();
                logger.log(System.Logger.Level.INFO, "Create new durable subscription with MessageSelector=\"TEST='test again'\",");
                logger.log(System.Logger.Level.INFO, "TopicName=" + this.topic.getTopicName() + " and SubscriptionName=durableConsumerChangeSelectorTest2");
                durableCon = this.context2.createDurableConsumer(this.topic, "durableConsumerChangeSelectorTest2", "TEST = 'test again'", false);
                messageReceived = (TextMessage)durableCon.receive(this.timeout);
                if (messageReceived != null) {
                    logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
                    throw new Exception("received unexpected message");
                }
            } else {
                if (messageReceived.getText().equals(messageSent2.getText())) {
                    logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
                    throw new Exception("received second message (unexpected)");
                }
                logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
                throw new Exception("received unexpected message");
            }
            logger.log(System.Logger.Level.INFO, "Did not receive any messages (correct)");
        }
        catch (Exception e) {
            try {
                logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
                throw new Exception("durableConsumerChangeSelectorTest2");
            }
            catch (Throwable throwable) {
                try {
                    this.cleanupSubscription(durableCon, this.context2, "durableConsumerChangeSelectorTest2");
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.cleanupSubscription(durableCon, this.context2, "durableConsumerChangeSelectorTest2");
            return;
        }
        catch (Exception messageSent3332) {
            return;
        }
    }

    @Test
    public void verifyClientIDOnAdminConfiguredIDTest() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "Get client id from an administratively configured client id");
            String cid = this.context2.getClientID();
            if (cid == null) {
                logger.log(System.Logger.Level.ERROR, "getClientID returned null (expected cts)");
                pass = false;
            } else if (!cid.equals("cts")) {
                logger.log(System.Logger.Level.ERROR, "getClientID() returned " + cid + ", expected cts");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "getClientID returned cts (Correct)");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected: " + e);
            throw new Exception("verifyClientIDOnAdminConfiguredIDTest");
        }
        if (!pass) {
            throw new Exception("verifyClientIDOnAdminConfiguredIDTest failed");
        }
    }

    @Test
    public void invalidDestinationRuntimeExceptionTests() throws Exception {
        boolean pass = true;
        Destination invalidDestination = null;
        Topic invalidTopic = null;
        String message = "Where are you!";
        byte[] bytesMsgSend = message.getBytes();
        HashMap<String, Object> mapMsgSend = new HashMap<String, Object>();
        mapMsgSend.put("StringValue", "sendAndRecvTest7");
        mapMsgSend.put("BooleanValue", true);
        mapMsgSend.put("IntValue", 10);
        try {
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "invalidDestinationRuntimeExceptionTests");
            logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, Message) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling send(Destination, Message) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, (Message)expTextMessage);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, String) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling send(Destination, String) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, message);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, Serializable) for InvalidDestinationRuntimeException");
            logger.log(System.Logger.Level.INFO, "Send ObjectMessage");
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage");
            ObjectMessage om = this.context.createObjectMessage();
            StringBuffer sb = new StringBuffer(message);
            om.setObject((Serializable)sb);
            om.setStringProperty("COM_SUN_JMS_TESTNAME", "invalidDestinationRuntimeExceptionTests");
            try {
                logger.log(System.Logger.Level.INFO, "Calling send(Destination, Serializable) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, (Message)om);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, byte[]) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling send(Destination, byte[]) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, bytesMsgSend);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, Map) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling send(Destination, Map) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, mapMsgSend);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createConsumer(Destination) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createConsumer(Destination) -> expect InvalidDestinationRuntimeException");
                this.context.createConsumer(invalidDestination);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createConsumer(Destination, String) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createConsumer(Destination, String) -> expect InvalidDestinationRuntimeException");
                this.context.createConsumer(invalidDestination, "lastMessage = TRUE");
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createConsumer(Destination, String, boolean) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createConsumer(Destination, String, boolean) -> expect InvalidDestinationRuntimeException");
                this.context.createConsumer(invalidDestination, "lastMessage = TRUE", false);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createDurableConsumer(Topic, String) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createDurableConsumer(Topic, String) -> expect InvalidDestinationRuntimeException");
                this.context.createDurableConsumer(invalidTopic, "InvalidDestinationRuntimeException");
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createDurableConsumer(Topic, String, String, boolean) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createDurableConsumer(Topic, String, String, boolean) -> expect InvalidDestinationRuntimeException");
                this.context.createDurableConsumer(invalidTopic, "InvalidDestinationRuntimeException", "lastMessage = TRUE", false);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createSharedDurableConsumer(Topic, String) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createSharedDurableConsumer(Topic, String) -> expect InvalidDestinationRuntimeException");
                this.context.createSharedDurableConsumer(invalidTopic, "InvalidDestinationRuntimeException");
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createSharedDurableConsumer(Topic, String, String) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createSharedDurableConsumer(Topic, String, String) -> expect InvalidDestinationRuntimeException");
                this.context.createSharedDurableConsumer(invalidTopic, "InvalidDestinationRuntimeException", "lastMessage = TRUE");
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.unsubscribe(String) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.unsubscribe(String) -> expect InvalidDestinationRuntimeException");
                this.context.unsubscribe("InvalidSubscriptionName");
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createSharedConsumer(Topic, String) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createSharedConsumer(Topic, String) for InvalidDestinationRuntimeException");
                this.context.createSharedConsumer(invalidTopic, "InvalidDestinationRuntimeException");
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createSharedConsumer(Topic, String, String) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createSharedConsumer(Topic, String, String) for InvalidDestinationRuntimeException");
                this.context.createSharedConsumer(invalidTopic, "InvalidDestinationRuntimeException", "lastMessage = TRUE");
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("invalidDestinationRuntimeExceptionTests", e);
        }
        if (!pass) {
            throw new Exception("invalidDestinationRuntimeExceptionTests failed");
        }
    }

    @Test
    public void invalidSelectorRuntimeExceptionTests() throws Exception {
        boolean pass = true;
        String invalidMessageSelector = "=TEST 'test'";
        try {
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createConsumer(Destination, String) for InvalidSelectorRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createConsumer(Destination, String) -> expect InvalidSelectorRuntimeException");
                this.context.createConsumer((Destination)this.topic, invalidMessageSelector);
            }
            catch (InvalidSelectorRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidSelectorRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidSelectorRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createConsumer(Destination, String, boolean) for InvalidSelectorRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createConsumer(Destination, String, boolean) -> expect InvalidSelectorRuntimeException");
                this.context.createConsumer((Destination)this.topic, invalidMessageSelector, false);
            }
            catch (InvalidSelectorRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidSelectorRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidSelectorRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createDurableConsumer(Topic, String, String, boolean) for InvalidSelectorRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createDurableConsumer(Topic, String, String, boolean) -> expect InvalidSelectorRuntimeException");
                this.context2.createDurableConsumer(this.topic, "InvalidSelectorRuntimeException", invalidMessageSelector, false);
            }
            catch (InvalidSelectorRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidSelectorRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidSelectorRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createSharedDurableConsumer(Topic, String, String) for InvalidSelectorRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createSharedDurableConsumer(Topic, String, String) -> expect InvalidSelectorRuntimeException");
                this.context.createSharedDurableConsumer(this.topic, "InvalidSelectorRuntimeException", invalidMessageSelector);
            }
            catch (InvalidSelectorRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidSelectorRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidSelectorRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createSharedConsumer(Topic, String, String) for InvalidSelectorRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createSharedConsumer(Topic, String, String) for InvalidSelectorRuntimeException");
                this.context.createSharedConsumer(this.topic, "InvalidSelectorRuntimeException", invalidMessageSelector);
            }
            catch (InvalidSelectorRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidSelectorRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidSelectorRuntimeException, received " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("invalidSelectorRuntimeExceptionTests", e);
        }
        if (!pass) {
            throw new Exception("invalidSelectorRuntimeExceptionTests failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jMSRuntimeExceptionTests() throws Exception {
        Topic mytopic;
        boolean pass = true;
        String message = "Where are you!";
        if (this.vehicle.equals("ejb") || this.vehicle.equals("jsp") || this.vehicle.equals("servlet")) {
            try {
                logger.log(System.Logger.Level.INFO, "Calling createContext must throw JMSRuntimeException for EJB/WEB container");
                this.context.createContext(1);
                logger.log(System.Logger.Level.ERROR, "Didn't throw JMSRuntimeException");
                pass = false;
            }
            catch (JMSRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected JMSRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected JMSRuntimeException, received " + e);
                pass = false;
            }
        }
        try {
            if (this.consumer != null) {
                this.consumer.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            logger.log(System.Logger.Level.INFO, "Try and set an invalid priority of -1");
            this.producer.setPriority(-1);
            logger.log(System.Logger.Level.ERROR, "Didn't throw JMSRuntimeException");
            pass = false;
        }
        catch (JMSRuntimeException e) {
            logger.log(System.Logger.Level.INFO, "Caught expected JMSRuntimeException");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Expected JMSRuntimeException, received " + e);
            pass = false;
        }
        try {
            logger.log(System.Logger.Level.INFO, "Try and set an delivery mode to live of -1");
            this.producer.setDeliveryMode(-1);
            logger.log(System.Logger.Level.ERROR, "Didn't throw JMSRuntimeException");
            pass = false;
        }
        catch (JMSRuntimeException e) {
            logger.log(System.Logger.Level.INFO, "Caught expected JMSRuntimeException");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Expected JMSRuntimeException, received " + e);
            pass = false;
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create shared consumer");
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.createSharedConsumer(Topic, String)");
            this.consumer = this.context2.createSharedConsumer(this.topic, "dummySubSCJMSRuntime");
            logger.log(System.Logger.Level.INFO, "Create second shared consumer with same name but different topic");
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.createSharedConsumer(Topic, String)");
            mytopic = this.tool.createNewTopic("MY_TOPIC2");
            this.consumer2 = this.context2.createSharedConsumer(mytopic, "dummySubSCJMSRuntime");
            logger.log(System.Logger.Level.INFO, "Verify that JMSRuntimeException is thrown");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSRuntimeException");
        }
        catch (JMSRuntimeException ex) {
            logger.log(System.Logger.Level.INFO, "Got expected JMSRuntimeException from JMSContext.createSharedConsumer(Topic, String)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception ex) {}
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create shared consumer");
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.createSharedConsumer(Topic, String, String)");
            this.consumer = this.context2.createSharedConsumer(this.topic, "dummySubSCJMSRuntime", "TEST = 'test'");
            logger.log(System.Logger.Level.INFO, "Create second shared consumer with same name but different topic");
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.createSharedConsumer(Topic, String, String)");
            mytopic = this.tool.createNewTopic("MY_TOPIC2");
            this.consumer2 = this.context2.createSharedConsumer(mytopic, "dummySubSCJMSRuntime", "TEST = 'test'");
            logger.log(System.Logger.Level.INFO, "Verify that JMSRuntimeException is thrown");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSRuntimeException");
        }
        catch (JMSRuntimeException ex) {
            logger.log(System.Logger.Level.INFO, "Got expected JMSRuntimeException from JMSContext.createSharedConsumer(Topic, String, String)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception ex) {}
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create shared durable subscription");
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.createSharedDurableConsumer(Topic, String, String)");
            this.consumer = this.context2.createSharedDurableConsumer(this.topic, "dummySubSJMSRuntime", "TEST = 'test'");
            logger.log(System.Logger.Level.INFO, "Create second shared durable subscription with same name but different other args");
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.createSharedDurableConsumer(Topic, String, String)");
            this.consumer2 = this.context2.createSharedDurableConsumer(this.topic, "dummySubSJMSRuntime", "TEST = 'test2'");
            logger.log(System.Logger.Level.INFO, "Verify that JMSRuntimeException is thrown");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSRuntimeException");
        }
        catch (JMSRuntimeException ex) {
            logger.log(System.Logger.Level.INFO, "Got expected JMSRuntimeException from JMSContext.createSharedDurableConsumer(Topic, String, String)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.context2, "dummySubSJMSRuntime");
            }
            catch (Exception ex) {}
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create durable subscription");
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.createDurableConsumer(Topic, String)");
            this.consumer = this.context2.createDurableConsumer(this.topic, "dummySubDJMSRuntime");
            logger.log(System.Logger.Level.INFO, "Create second durable subscription with same name but different topic");
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.createDurableConsumer(Topic, String)");
            mytopic = this.tool.createNewTopic("MY_TOPIC2");
            this.consumer2 = this.context2.createDurableConsumer(mytopic, "dummySubDJMSRuntime");
            logger.log(System.Logger.Level.INFO, "Verify that JMSRuntimeException is thrown");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSRuntimeException");
        }
        catch (JMSRuntimeException ex) {
            logger.log(System.Logger.Level.INFO, "Got expected JMSRuntimeException from JMSContext.createDurableConsumer(Topic, String)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.context2, "dummySubDJMSRuntime");
            }
            catch (Exception ex) {}
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create shared durable subscription");
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.createSharedDurableConsumer(Topic, String)");
            this.consumer = this.context2.createSharedDurableConsumer(this.topic, "dummySubSDJMSRuntime");
            logger.log(System.Logger.Level.INFO, "Create second shared durable subscription with same name but different topic");
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.createSharedDurableConsumer(Topic, String)");
            mytopic = this.tool.createNewTopic("MY_TOPIC2");
            this.consumer2 = this.context2.createSharedDurableConsumer(mytopic, "dummySubSDJMSRuntime");
            logger.log(System.Logger.Level.INFO, "Verify that JMSRuntimeException is thrown");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSRuntimeException");
        }
        catch (JMSRuntimeException ex) {
            logger.log(System.Logger.Level.INFO, "Got expected JMSRuntimeException from JMSContext.createSharedDurableConsumer(Topic, String)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.context2, "dummySubSDJMSRuntime");
            }
            catch (Exception ex) {}
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create durable subscription");
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.createDurableConsumer(Topic, String, String, boolean)");
            this.consumer = this.context2.createDurableConsumer(this.topic, "dummySubDJMSRuntime", "TEST = 'test'", true);
            logger.log(System.Logger.Level.INFO, "Create second durable subscription with same name but different other args");
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.createDurableConsumer(Topic, String, String, boolean)");
            this.consumer2 = this.context2.createDurableConsumer(this.topic, "dummySubDJMSRuntime", "TEST = 'test2'", false);
            logger.log(System.Logger.Level.INFO, "Verify that JMSRuntimeException is thrown");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSRuntimeException");
        }
        catch (JMSRuntimeException ex) {
            logger.log(System.Logger.Level.INFO, "Got expected JMSRuntimeException from JMSContext.createDurableConsumer(Topic, String, String, boolean)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.context2, "dummySubDJMSRuntime");
            }
            catch (Exception ex) {}
        }
        if (!pass) {
            throw new Exception("jMSRuntimeExceptionTests failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void illegalStateRuntimeExceptionTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTest");
            logger.log(System.Logger.Level.TRACE, "Sending message to the Topic");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            try {
                logger.log(System.Logger.Level.TRACE, "JMSContext.commit() on non-transacted session must throw IllegalStateRuntimeException");
                this.context.commit();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: JMSContext.commit() didn't throw expected IllegalStateRuntimeException");
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateRuntimeException from JMSContext.commit()");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTest");
            logger.log(System.Logger.Level.TRACE, "Sending message to the Topic");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            try {
                logger.log(System.Logger.Level.TRACE, "JMSContext.rollback() on non-transacted session must throw IllegalStateRuntimeException");
                this.context.rollback();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: JMSContext.rollback() didn't throw expected IllegalStateRuntimeException");
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateRuntimeException from JMSContext.rollback()");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTest");
            logger.log(System.Logger.Level.TRACE, "Sending message to the Topic");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            if (this.vehicle.equals("appclient") || this.vehicle.equals("standalone")) {
                JMSContext contextTX = this.cf.createContext(this.user, this.password, 0);
                JMSProducer producerTX = contextTX.createProducer();
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                expTextMessage = contextTX.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTest");
                logger.log(System.Logger.Level.INFO, "Sending message to the Queue");
                logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, Message)");
                producerTX.send(this.destination, (Message)expTextMessage);
                try {
                    logger.log(System.Logger.Level.INFO, "JMSContext.recover() on a transacted session must throw IllegalStateRuntimeException");
                    contextTX.recover();
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Error: JMSContext.recover() didn't throw expected IllegalStateRuntimeException");
                }
                catch (IllegalStateRuntimeException e) {
                    logger.log(System.Logger.Level.INFO, "Got expected IllegalStateRuntimeException from JMSContext.recover()");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                    pass = false;
                }
                contextTX.close();
                try {
                    logger.log(System.Logger.Level.INFO, "Create JMSContext with CLIENT_ACKNOWLEDGE");
                    JMSContext msgcontext = this.cf.createContext(this.user, this.password, 2);
                    logger.log(System.Logger.Level.INFO, "Close JMSContext");
                    msgcontext.close();
                    logger.log(System.Logger.Level.INFO, "Call JMSContext.acknowledge() on a closed session which is illegal");
                    msgcontext.acknowledge();
                    logger.log(System.Logger.Level.ERROR, "Didn't throw IllegalStateRuntimeException");
                    pass = false;
                }
                catch (IllegalStateRuntimeException e) {
                    logger.log(System.Logger.Level.INFO, "Got expected IllegalStateRuntimeException from JMSContext.acknowledge()");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught expected exception" + e);
                    pass = false;
                }
            }
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception contextTX) {
                // empty catch block
            }
            try {
                this.consumer = null;
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createDurableConsumer(Topic, String)");
                logger.log(System.Logger.Level.INFO, "Create Durable Consumer with client id unset (expect IllegalStateRuntimeException)");
                this.consumer = this.context.createDurableConsumer(this.topic, "dummySubDIllegalState1");
                logger.log(System.Logger.Level.ERROR, "No exception occurred - expected IllegalStateRuntimeException");
                pass = false;
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            finally {
                try {
                    if (this.consumer != null) {
                        this.cleanupSubscription(this.consumer, this.context, "dummySubDIllegalState1");
                    }
                }
                catch (Exception e) {}
            }
            try {
                this.consumer = null;
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createDurableConsumer(Topic, String, String, boolean)");
                logger.log(System.Logger.Level.INFO, "Create Durable Consumer with client id unset, nolocal=false (expect IllegalStateRuntimeException)");
                this.consumer = this.context.createDurableConsumer(this.topic, "dummySubDIllegalState2", "lastMessage = TRUE", false);
                logger.log(System.Logger.Level.ERROR, "No exception occurred - expected IllegalStateRuntimeException");
                pass = false;
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception" + e);
                pass = false;
            }
            finally {
                try {
                    if (this.consumer != null) {
                        this.cleanupSubscription(this.consumer, this.context, "dummySubDIllegalState2");
                    }
                }
                catch (Exception e) {}
            }
            try {
                this.consumer = null;
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createDurableConsumer(Topic, String, String, boolean)");
                logger.log(System.Logger.Level.INFO, "Create Durable Consumer with client id unset, nolocal=true (expect IllegalStateRuntimeException)");
                this.consumer = this.context.createDurableConsumer(this.topic, "dummySubDIllegalState2", "lastMessage = TRUE", true);
                logger.log(System.Logger.Level.ERROR, "No exception occurred - expected IllegalStateRuntimeException");
                pass = false;
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception" + e);
                pass = false;
            }
            finally {
                try {
                    if (this.consumer != null) {
                        this.cleanupSubscription(this.consumer, this.context, "dummySubDIllegalState2");
                    }
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
            throw new Exception("illegalStateRuntimeExceptionTest");
        }
        if (!pass) {
            throw new Exception("illegalStateRuntimeExceptionTest");
        }
    }
}

