/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgTypesQ3;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.commonee.MDB_Q_Test;
import jakarta.ejb.EJB;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MDBClientIT {
    @EJB(name="ejb/MDB_MSGQ3_Test")
    private static MDB_Q_Test hr;
    private Properties props = new Properties();
    private static final System.Logger logger;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.props.put("jms_timeout", System.getProperty("jms_property"));
            this.props.put("user", System.getProperty("user"));
            this.props.put("password", System.getProperty("password"));
            if (hr == null) {
                throw new Exception("@EJB injection failed");
            }
            hr.setup(this.props);
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "Setup ok;");
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    @Test
    public void mdbMsgClearBodyQueueTextTest() throws Exception {
        String testCase1 = "msgClearBodyQueueTextTestCreate";
        String testCase2 = "msgClearBodyQueueTextTest";
        try {
            System.out.println("client - run testcase msgClearBodyQueueTextTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from msgClearBodyQueueTextTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: msgClearBodyQueueTextTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMsgClearBodyQueueObjectTest() throws Exception {
        String testCase1 = "msgClearBodyQueueObjectTestCreate";
        String testCase2 = "msgClearBodyQueueObjectTest";
        try {
            System.out.println("client - run testcase msgClearBodyQueueObjectTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from msgClearBodyQueueObjectTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: msgClearBodyQueueObjectTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMsgClearBodyQueueMapTest() throws Exception {
        String testCase1 = "msgClearBodyQueueMapTestCreate";
        String testCase2 = "msgClearBodyQueueMapTest";
        try {
            System.out.println("client - run testcase msgClearBodyQueueMapTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from msgClearBodyQueueMapTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: msgClearBodyQueueMapTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMsgClearBodyQueueBytesTest() throws Exception {
        String testCase1 = "msgClearBodyQueueBytesTestCreate";
        String testCase2 = "msgClearBodyQueueBytesTest";
        try {
            System.out.println("client - run testcase msgClearBodyQueueBytesTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from msgClearBodyQueueBytesTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: msgClearBodyQueueBytesTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMsgClearBodyQueueStreamTest() throws Exception {
        String testCase1 = "msgClearBodyQueueStreamTestCreate";
        String testCase2 = "msgClearBodyQueueStreamTest";
        try {
            System.out.println("client - run testcase msgClearBodyQueueStreamTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from msgClearBodyQueueStreamTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: msgClearBodyQueueStreamTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMsgResetQueueTest() throws Exception {
        String testCase = "msgResetQueueTest";
        try {
            System.out.println("client - run testcase msgResetQueueTest");
            hr.askMDBToRunATest(testCase);
            System.out.println("client - Check for response from msgResetQueueTest");
            if (!hr.checkOnResponse(testCase)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: msgResetQueueTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbReadNullCharNotValidQueueMapTest() throws Exception {
        String testCase1 = "readNullCharNotValidQueueMapTestCreate";
        String testCase2 = "readNullCharNotValidQueueMapTest";
        try {
            System.out.println("client - run testcase readNullCharNotValidQueueMapTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from readNullCharNotValidQueueMapTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: readNullCharNotValidQueueMapTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbReadNullCharNotValidQueueStreamTest() throws Exception {
        String testCase1 = "readNullCharNotValidQueueStreamTestCreate";
        String testCase2 = "readNullCharNotValidQueueStreamTest";
        try {
            System.out.println("client - run testcase readNullCharNotValidQueueStreamTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from readNullCharNotValidQueueStreamTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: readNullCharNotValidQueueStreamTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "End  of client cleanup;");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    static {
        logger = System.getLogger(MDBClientIT.class.getName());
    }
}

