/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgTypesT1;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.commonee.MDB_T_Test;
import jakarta.ejb.EJB;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MDBClientIT {
    @EJB(name="ejb/MDB_MSGT1_Test")
    private static MDB_T_Test hr;
    private Properties props = new Properties();
    private static final System.Logger logger;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.props.put("jms_timeout", System.getProperty("jms_property"));
            this.props.put("user", System.getProperty("user"));
            this.props.put("password", System.getProperty("password"));
            if (hr == null) {
                throw new Exception("@EJB injection failed");
            }
            hr.setup(this.props);
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "Setup ok;");
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    @Test
    public void mdbBytesMsgNullStreamTopicTest() throws Exception {
        String testCase = "bytesMsgNullStreamTopicTest";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to run bytesMsgNullStreamTopicTest");
            hr.askMDBToRunATest(testCase);
            if (!hr.checkOnResponse(testCase)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbBytesMsgNullStreamTopicTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbBytesMessageTopicTestsFullMsg() throws Exception {
        String testCase1 = "bytesMessageTopicTestsFullMsgCreate";
        String testCase2 = "bytesMessageTopicTestsFullMsg";
        try {
            System.out.println("client - run testcase bytesMessageTopicTestsFullMsgCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from bytesMessageTopicTestsFullMsg");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: bytesMessageTopicTestsFullMsg failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageFullMsgTopicTest() throws Exception {
        String testCase1 = "mapMessageFullMsgTopicTestCreate";
        String testCase2 = "mapMessageFullMsgTopicTest";
        try {
            System.out.println("client - run testcase mapMessageFullMsgTopicTestCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageFullMsgTopicTest");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageFullMsgTopicTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionTopicTestsBoolean() throws Exception {
        String testCase1 = "mapMessageConversionTopicTestsBooleanCreate";
        String testCase2 = "mapMessageConversionTopicTestsBoolean";
        try {
            System.out.println("client - run testcase mapMessageConversionTopicTestsBooleanCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionTopicTestsBoolean");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionTopicTestsBoolean failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionTopicTestsByte() throws Exception {
        String testCase1 = "mapMessageConversionTopicTestsByteCreate";
        String testCase2 = "mapMessageConversionTopicTestsByte";
        try {
            System.out.println("client - run testcase mapMessageConversionTopicTestsByteCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionTopicTestsByte");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionTopicTestsByte failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionTopicTestsShort() throws Exception {
        String testCase1 = "mapMessageConversionTopicTestsShortCreate";
        String testCase2 = "mapMessageConversionTopicTestsShort";
        try {
            System.out.println("client - run testcase mapMessageConversionTopicTestsShortCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionTopicTestsShort");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionTopicTestsShort failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionTopicTestsChar() throws Exception {
        String testCase1 = "mapMessageConversionTopicTestsCharCreate";
        String testCase2 = "mapMessageConversionTopicTestsChar";
        try {
            System.out.println("client - run testcase mapMessageConversionTopicTestsCharCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionTopicTestsChar");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionTopicTestsChar failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionTopicTestsInt() throws Exception {
        String testCase1 = "mapMessageConversionTopicTestsIntCreate";
        String testCase2 = "mapMessageConversionTopicTestsInt";
        try {
            System.out.println("client - run testcase mapMessageConversionTopicTestsIntCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionTopicTestsInt");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionTopicTestsInt failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionTopicTestsLong() throws Exception {
        String testCase1 = "mapMessageConversionTopicTestsLongCreate";
        String testCase2 = "mapMessageConversionTopicTestsLong";
        try {
            System.out.println("client - run testcase mapMessageConversionTopicTestsLongCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionTopicTestsLong");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionTopicTestsLong failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionTopicTestsFloat() throws Exception {
        String testCase1 = "mapMessageConversionTopicTestsFloatCreate";
        String testCase2 = "mapMessageConversionTopicTestsFloat";
        try {
            System.out.println("client - run testcase mapMessageConversionTopicTestsFloatCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionTopicTestsFloat");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionTopicTestsFloat failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionTopicTestsDouble() throws Exception {
        String testCase1 = "mapMessageConversionTopicTestsDoubleCreate";
        String testCase2 = "mapMessageConversionTopicTestsDouble";
        try {
            System.out.println("client - run testcase mapMessageConversionTopicTestsDoubleCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionTopicTestsDouble");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionTopicTestsDouble failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionTopicTestsString() throws Exception {
        String testCase1 = "mapMessageConversionTopicTestsStringCreate";
        String testCase2 = "mapMessageConversionTopicTestsString";
        try {
            System.out.println("client - run testcase mapMessageConversionTopicTestsStringCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionTopicTestsString");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionTopicTestsString failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionTopicTestsBytes() throws Exception {
        String testCase1 = "mapMessageConversionTopicTestsBytesCreate";
        String testCase2 = "mapMessageConversionTopicTestsBytes";
        try {
            System.out.println("client - run testcase mapMessageConversionTopicTestsBytesCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionTopicTestsBytes");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionTopicTestsBytes failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbMapMessageConversionTopicTestsInvFormatString() throws Exception {
        String testCase1 = "mapMessageConversionTopicTestsInvFormatStringCreate";
        String testCase2 = "mapMessageConversionTopicTestsInvFormatString";
        try {
            System.out.println("client - run testcase mapMessageConversionTopicTestsInvFormatStringCreate");
            hr.askMDBToRunATest(testCase1);
            System.out.println("client - Check for response from mapMessageConversionTopicTestsInvFormatString");
            if (!hr.checkOnResponse(testCase2)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mapMessageConversionTopicTestsInvFormatString failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "End  of client cleanup;");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    static {
        logger = System.getLogger(MDBClientIT.class.getName());
    }
}

