/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_rec;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.Properties;

public class MsgBeanForTopic
implements MessageDrivenBean,
MessageListener {
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory qcFactory;
    private QueueConnection connection = null;
    private Properties p = null;
    private static final System.Logger logger = System.getLogger(MsgBeanForTopic.class.getName());

    public MsgBeanForTopic() {
        logger.log(System.Logger.Level.TRACE, "In MsgBeanForTopic::MsgBeanForTopic()!");
    }

    public void ejbCreate() {
        logger.log(System.Logger.Level.TRACE, "In MsgBeanForTopic::ejbCreate() !!");
        this.p = new Properties();
    }

    public void onMessage(Message msg) {
        try {
            JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
            logger.log(System.Logger.Level.TRACE, "In MsgBeanForTopic::onMessage() : " + msg);
            this.sendReply(msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReply(Message msg) {
        try {
            TSNamingContext context = new TSNamingContext();
            this.qcFactory = (QueueConnectionFactory)context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            this.connection = this.qcFactory.createQueueConnection();
            Queue replyQueue = (Queue)context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.connection.start();
            QueueSession session = this.connection.createQueueSession(true, 0);
            TextMessage reply = session.createTextMessage();
            QueueSender replier = session.createSender(replyQueue);
            reply.setText("MDB Responding to message receipt");
            reply.setStringProperty("Verify", msg.getStringProperty("Verify"));
            replier.send((Message)reply);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception ee) {
                    TestUtil.printStackTrace((Throwable)ee);
                }
            }
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        logger.log(System.Logger.Level.TRACE, "In MsgBeanForTopicForQueue::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        logger.log(System.Logger.Level.TRACE, "In MsgBeanForTopicForQueue::remove()!!");
    }
}

