/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_sndQ;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import com.sun.ts.tests.jms.ee.mdb.mdb_sndQ.MDB_SNDQ_Test;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.PostActivate;
import jakarta.ejb.PrePassivate;
import jakarta.ejb.Remote;
import jakarta.ejb.Remove;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import java.util.Properties;

@Stateful
@Remote(value={MDB_SNDQ_Test.class})
public class MDB_SNDQ_TestEJB {
    @Resource
    private SessionContext sessionContext;
    @Resource(name="jms/MDB_QUEUE")
    private transient Queue Dest;
    @Resource(name="jms/MDB_QUEUE_REPLY")
    private transient Queue receiveDest;
    @Resource(name="jms/MyQueueConnectionFactory")
    private transient ConnectionFactory cf;
    private transient Connection Conn;
    private Properties p = null;
    private long timeout;
    private String jmsUser;
    private String jmsPassword;
    private static final System.Logger logger = System.getLogger(MDB_SNDQ_TestEJB.class.getName());

    public void setup(Properties props) {
        logger.log(System.Logger.Level.TRACE, "MDB_SNDQ_TestEJB.askMDBToSendAMessage()");
        this.p = props;
        try {
            TestUtil.init((Properties)props);
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.jmsUser = System.getProperty("user");
            this.jmsPassword = System.getProperty("password");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.jmsUser == null) {
                throw new Exception("'user' is null");
            }
            if (this.jmsPassword == null) {
                throw new Exception("'password' is null");
            }
            if (this.cf == null || this.Dest == null || this.receiveDest == null || this.sessionContext == null) {
                throw new Exception("@Resource injection failed");
            }
        }
        catch (Exception e) {
            throw new EJBException("@setup failed: ", e);
        }
    }

    public boolean askMDBToSendAMessage(String typeOfMessage) {
        logger.log(System.Logger.Level.TRACE, "MDB_SNDQ_TestEJB.askMDBToSendAMessage()");
        boolean ok = true;
        String myMessage = "I want you to send a message";
        try {
            this.Conn = this.cf.createConnection(this.jmsUser, this.jmsPassword);
            Session session = this.Conn.createSession(true, 0);
            this.Conn.start();
            MessageProducer mSender = session.createProducer((Destination)this.Dest);
            TextMessage msg = session.createTextMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.setText(myMessage);
            msg.setStringProperty("MessageType", typeOfMessage);
            mSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("@askMDBToSendAMessage: Error!", e);
        }
        finally {
            try {
                if (this.Conn != null) {
                    this.Conn.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error closing connection in askMDBToSendAMessage", (Throwable)e);
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkOnResponse(String prop) {
        boolean status = false;
        try {
            logger.log(System.Logger.Level.TRACE, "MDB_SNDQ_TestEJB.checkOnResponse()");
            this.Conn = this.cf.createConnection(this.jmsUser, this.jmsPassword);
            this.Conn.start();
            Session session = this.Conn.createSession(true, 0);
            status = this.recvMessageInternal(session, prop);
            logger.log(System.Logger.Level.TRACE, "Close the session");
            session.close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error in checkOnResponse", (Throwable)e);
        }
        finally {
            try {
                if (this.Conn != null) {
                    this.Conn.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error closing connection in checkOnResponse", (Throwable)e);
            }
        }
        return status;
    }

    private boolean recvMessageInternal(Session session, String prop) throws JMSException {
        boolean retcode = false;
        logger.log(System.Logger.Level.TRACE, "MDB_SNDQ_TestEJB.recvMessageInternal()");
        MessageConsumer rcvr = session.createConsumer((Destination)this.receiveDest);
        Message msgRec = null;
        for (int i = 0; i < 10; ++i) {
            logger.log(System.Logger.Level.TRACE, "@recvMessageInternal trying to receive the message: " + i);
            msgRec = rcvr.receive(this.timeout);
            if (msgRec != null) break;
        }
        if (msgRec != null) {
            if (msgRec.getStringProperty("MessageType").equals(prop)) {
                logger.log(System.Logger.Level.TRACE, "Success: received Msg from Q!  " + msgRec.getStringProperty("MessageType"));
                logger.log(System.Logger.Level.TRACE, "Pass: we got the expected msg back! ");
                retcode = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Fail: we didnt get the expected msg back! ");
                logger.log(System.Logger.Level.ERROR, "Msg from Q:  " + msgRec.getStringProperty("MessageType"));
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Fail: we didnt get the expected msg back! ");
        }
        return retcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThereSomethingInTheQueue() {
        logger.log(System.Logger.Level.TRACE, "MDB_SNDQ_TestEJB.isThereSomethingInTheQueue()");
        QueueBrowser qBrowser = null;
        Enumeration msgs = null;
        boolean ret = false;
        try {
            this.Conn = this.cf.createConnection(this.jmsUser, this.jmsPassword);
            this.Conn.start();
            Session session = this.Conn.createSession(true, 0);
            qBrowser = session.createBrowser(this.receiveDest);
            msgs = qBrowser.getEnumeration();
            if (msgs.hasMoreElements()) {
                ret = true;
            }
            qBrowser.close();
            session.close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error in isThereSomethingInTheQueue", (Throwable)e);
        }
        finally {
            try {
                if (this.Conn != null) {
                    this.Conn.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error closing connection in isThereSomethingInTheQueue", (Throwable)e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanTheQueue() {
        logger.log(System.Logger.Level.TRACE, "MDB_SNDQ_TestEJB.cleanTheQueue()");
        QueueBrowser qBrowser = null;
        Enumeration msgs = null;
        int numMsgs = 0;
        TextMessage msgRec = null;
        MessageConsumer rcvr = null;
        try {
            this.Conn = this.cf.createConnection(this.jmsUser, this.jmsPassword);
            Session session = this.Conn.createSession(true, 0);
            this.Conn.start();
            qBrowser = session.createBrowser(this.receiveDest);
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                msgs.nextElement();
                ++numMsgs;
            }
            qBrowser.close();
            rcvr = session.createConsumer((Destination)this.receiveDest);
            block12: for (int n = 0; n < numMsgs; ++n) {
                for (int i = 0; i < 10; ++i) {
                    msgRec = (TextMessage)rcvr.receive(this.timeout);
                    if (msgRec != null) {
                        logger.log(System.Logger.Level.TRACE, "Removed message from Destination: " + n);
                        continue block12;
                    }
                    logger.log(System.Logger.Level.TRACE, "Attempt no: " + i + " Trying to delete message: " + n);
                }
            }
            session.close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error in cleanTheQueue", (Throwable)e);
        }
        finally {
            try {
                if (this.Conn != null) {
                    this.Conn.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error closing connection in cleanTheQueue", (Throwable)e);
            }
        }
    }

    @Remove
    public void remove() {
        logger.log(System.Logger.Level.TRACE, "MDB_SNDQ_TestEJB.remove()");
    }

    @PostActivate
    public void activate() {
        logger.log(System.Logger.Level.TRACE, "MDB_SNDQ_TestEJB.activate()");
        try {
            TSNamingContext context = new TSNamingContext();
            this.cf = (ConnectionFactory)context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            logger.log(System.Logger.Level.TRACE, "looked up connection factory object");
            this.Dest = (Queue)context.lookup("java:comp/env/jms/MDB_QUEUE");
            logger.log(System.Logger.Level.TRACE, "looked up the Destination");
            this.receiveDest = (Queue)context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error looking up Queue, Reply Queue, and ConnectionFactory objects", (Throwable)e);
            throw new EJBException("@activate: Error!", e);
        }
    }

    @PrePassivate
    public void passivate() {
        logger.log(System.Logger.Level.TRACE, "MDB_SNDQ_TestEJB.passivate()");
        this.receiveDest = null;
        this.Conn = null;
        this.Dest = null;
        this.cf = null;
    }
}

