/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_sndQ;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Properties;

public class MsgBean
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private ConnectionFactory cf = null;
    private Destination Dest = null;
    private MessageProducer mSender = null;
    private Session sess = null;
    private static final System.Logger logger = System.getLogger(MsgBean.class.getName());

    public MsgBean() {
        logger.log(System.Logger.Level.TRACE, "@MsgBean()!");
    }

    public void ejbCreate() {
        logger.log(System.Logger.Level.TRACE, "@MsgBean-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.cf = (ConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.cf == null) {
                logger.log(System.Logger.Level.ERROR, "error looking up ConnectionFactory");
            }
            logger.log(System.Logger.Level.TRACE, "got a ConnectionFactory!!");
            this.Dest = (Destination)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.Dest == null) {
                logger.log(System.Logger.Level.ERROR, "Dest error");
            }
            logger.log(System.Logger.Level.TRACE, "got a Dest ");
            this.p = new Properties();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "MDB ejbCreate Error!", (Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
        logger.log(System.Logger.Level.TRACE, "@onMessage! " + msg);
        Connection Conn = null;
        try {
            if (msg.getObjectProperty("properties") != null) {
                this.initLogging((Properties)msg.getObjectProperty("properties"));
            }
            if ((Conn = this.cf.createConnection()) == null) {
                logger.log(System.Logger.Level.ERROR, "connection error");
            } else {
                Conn.start();
                this.sess = Conn.createSession(true, 0);
            }
            logger.log(System.Logger.Level.TRACE, "started the connection !!");
            if (msg.getStringProperty("MessageType").equals("TextMessage")) {
                this.sendATextMessage();
            } else if (msg.getStringProperty("MessageType").equals("BytesMessage")) {
                this.sendABytesMessage();
            } else if (msg.getStringProperty("MessageType").equals("MapMessage")) {
                this.sendAMapMessage();
            } else if (msg.getStringProperty("MessageType").equals("StreamMessage")) {
                this.sendAStreamMessage();
            } else if (msg.getStringProperty("MessageType").equals("ObjectMessage")) {
                this.sendAnObjectMessage();
            } else {
                logger.log(System.Logger.Level.TRACE, "@onMessage - invalid message type found in StringProperty");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught in onMessage!", (Throwable)e);
        }
        finally {
            if (Conn != null) {
                try {
                    Conn.close();
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)e);
                }
            }
        }
    }

    public void initLogging(Properties p) {
        try {
            TestUtil.init((Properties)p);
            logger.log(System.Logger.Level.TRACE, "MsgBean initLogging OK.");
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.INFO, "MsgBean initLogging failed.");
            throw new EJBException(e.getMessage());
        }
    }

    private void sendATextMessage() {
        logger.log(System.Logger.Level.TRACE, "@sendATextMessage");
        try {
            String myMsg = "I am sending a text message as requested";
            this.mSender = this.sess.createProducer(this.Dest);
            TextMessage msg = this.sess.createTextMessage();
            msg.setText(myMsg);
            msg.setStringProperty("MessageType", "TextMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught sending a TextMessage!", (Throwable)e);
        }
    }

    private void sendABytesMessage() {
        logger.log(System.Logger.Level.TRACE, "@sendABytesMessage");
        try {
            byte aByte = 10;
            this.mSender = this.sess.createProducer(this.Dest);
            BytesMessage msg = this.sess.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.writeByte(aByte);
            msg.setStringProperty("MessageType", "BytesMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught sending a BytesMessage!", (Throwable)e);
        }
    }

    private void sendAMapMessage() {
        logger.log(System.Logger.Level.TRACE, "@sendAMapMessage");
        try {
            String myMsg = "I am sending a map message as requested";
            this.mSender = this.sess.createProducer(this.Dest);
            MapMessage msg = this.sess.createMapMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.setString("MapMessage", myMsg);
            msg.setStringProperty("MessageType", "MapMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught sending a MapMessage!", (Throwable)e);
        }
    }

    private void sendAStreamMessage() {
        logger.log(System.Logger.Level.TRACE, "@sendAStreamMessage");
        try {
            String myMsg = "I am sending a stream message as requested";
            this.mSender = this.sess.createProducer(this.Dest);
            StreamMessage msg = this.sess.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.writeString(myMsg);
            msg.setStringProperty("MessageType", "StreamMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught sending a StreamMessage!", (Throwable)e);
        }
    }

    private void sendAnObjectMessage() {
        logger.log(System.Logger.Level.TRACE, "@sendAnObjectMessage");
        try {
            String myMsg = "I am sending a text message as requested";
            this.mSender = this.sess.createProducer(this.Dest);
            ObjectMessage msg = this.sess.createObjectMessage();
            JmsUtil.addPropsToMessage((Message)msg, (Properties)this.p);
            msg.setObject((Serializable)((Object)myMsg));
            msg.setStringProperty("MessageType", "ObjectMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception caught sending an ObjectMessage!", (Throwable)e);
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        logger.log(System.Logger.Level.TRACE, "In MsgBean::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        logger.log(System.Logger.Level.TRACE, "In MsgBean::remove()!!");
    }
}

