/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_synchrec;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MDBClientIT {
    private TSNamingContextInterface context = null;
    private Properties props = new Properties();
    private Queue mdbRcvrQueue;
    private Queue rcvrQueue;
    private QueueConnection qConnect;
    private Queue cmtQ;
    private QueueSession session;
    private QueueConnectionFactory qFactory;
    private QueueSender qSender;
    private String jmsUser = null;
    private String jmsPassword = null;
    private TextMessage msg = null;
    long timeout;
    private static final System.Logger logger = System.getLogger(MDBClientIT.class.getName());

    @BeforeEach
    public void setup() throws Exception {
        this.jmsUser = System.getProperty("user");
        this.jmsPassword = System.getProperty("password");
        try {
            this.timeout = Integer.parseInt(System.getProperty("jms_timeout"));
            logger.log(System.Logger.Level.TRACE, "in client setup");
            this.context = new TSNamingContext();
            logger.log(System.Logger.Level.TRACE, "Client: Do lookups!");
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            this.cmtQ = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE");
            this.rcvrQueue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.mdbRcvrQueue = (Queue)this.context.lookup("java:comp/env/jms/MY_QUEUE");
            this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
            this.session = this.qConnect.createQueueSession(false, 1);
            this.qConnect.start();
            this.cleanTheQueue(this.rcvrQueue);
            this.cleanTheQueue(this.mdbRcvrQueue);
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    @Test
    public void test1() throws Exception {
        String TestCase = "syncRecTest1";
        int TestNum = 1;
        String mdbMessage = "my mdb message";
        try {
            this.createTestMessage(TestCase, TestNum);
            this.qSender = this.session.createSender(this.mdbRcvrQueue);
            JmsUtil.addPropsToMessage((Message)this.msg, (Properties)this.props);
            this.msg.setStringProperty("TestCase", mdbMessage);
            this.qSender.send((Message)this.msg);
            this.msg.setStringProperty("COM_SUN_JMS_TESTNAME", TestCase);
            this.qSender = this.session.createSender(this.cmtQ);
            this.qSender.send((Message)this.msg);
            TestCase = "mdbResponse";
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("syncRecTest1 - ");
            }
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            this.msg = null;
            if (this.qConnect != null) {
                this.qConnect.close();
            }
            logger.log(System.Logger.Level.INFO, "End  of client cleanup;");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void createTestMessage(String TestCase, int num) {
        String myMessage = "MDB synchronous receive test";
        try {
            this.msg = this.session.createTextMessage();
            this.msg.setStringProperty("user", this.jmsUser);
            this.msg.setStringProperty("password", this.jmsPassword);
            this.msg.setText(myMessage);
            this.msg.setIntProperty("TestCaseNum", num);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.INFO, "Error setting user and password in jms msg");
        }
    }

    public boolean checkOnResponse(String prop) {
        boolean status = false;
        try {
            logger.log(System.Logger.Level.TRACE, "@checkOnResponse");
            for (int i = 0; i < 10 && !(status = this.getMessage(this.session, prop)); ++i) {
            }
            logger.log(System.Logger.Level.TRACE, "Close the session");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return status;
    }

    private boolean getMessage(QueueSession session, String prop) throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "top of getMessage");
            boolean gotit = false;
            String selector = "TestCase = 'mdbResponse'";
            QueueReceiver rcvr = session.createReceiver(this.rcvrQueue, selector);
            Message msgRec = null;
            msgRec = rcvr.receive(this.timeout);
            if (msgRec == null) {
                logger.log(System.Logger.Level.TRACE, "No message to receive!!!");
            } else {
                logger.log(System.Logger.Level.TRACE, "Success: getMessage received a msg!!!");
                gotit = this.recvMessageInternal(msgRec, prop);
            }
            return gotit;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "exception: ", (Throwable)e);
            throw new Exception("getMessage threw an exception!");
        }
    }

    private boolean recvMessageInternal(Message msgRec, String prop) throws JMSException {
        boolean retcode = false;
        logger.log(System.Logger.Level.TRACE, "@recvMessageInternal");
        if (msgRec != null) {
            logger.log(System.Logger.Level.TRACE, "Msg: " + msgRec.toString());
            logger.log(System.Logger.Level.TRACE, "TestCase: " + msgRec.getStringProperty("TestCase"));
            logger.log(System.Logger.Level.TRACE, "Status: " + msgRec.getStringProperty("Status"));
            logger.log(System.Logger.Level.TRACE, "=================================================");
            logger.log(System.Logger.Level.TRACE, "Msg: " + msgRec.toString());
            if (msgRec.getStringProperty("TestCase").equals(prop) && msgRec.getStringProperty("Status").equals("Pass")) {
                logger.log(System.Logger.Level.TRACE, "TestCase: " + msgRec.getStringProperty("TestCase"));
                logger.log(System.Logger.Level.TRACE, "Status from msg: " + msgRec.getStringProperty("Status"));
                logger.log(System.Logger.Level.TRACE, "Pass: we got the expected msg back! ");
                retcode = true;
            } else if (msgRec.getStringProperty("Status").equals("Fail")) {
                logger.log(System.Logger.Level.TRACE, "TestCase: " + msgRec.getStringProperty("TestCase"));
                logger.log(System.Logger.Level.TRACE, "Status from msg: " + msgRec.getStringProperty("Status"));
                logger.log(System.Logger.Level.TRACE, "Fail: Error(s) occurred! ");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: we didnt get the expected msg back! ");
                logger.log(System.Logger.Level.TRACE, "TestCase:  " + msgRec.getStringProperty("TestCase"));
            }
        } else if (msgRec == null) {
            logger.log(System.Logger.Level.TRACE, "Fail: we didnt get the expected msg back! ");
        }
        return retcode;
    }

    private void cleanTheQueue(Queue q) {
        try {
            logger.log(System.Logger.Level.TRACE, "Check if any messages left in queue");
            QueueReceiver qR = this.session.createReceiver(q);
            Message msg = qR.receive(this.timeout);
            while (msg != null) {
                logger.log(System.Logger.Level.TRACE, "Cleaned up a message in QUEUE!");
                msg = qR.receive(this.timeout);
            }
            qR.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.TRACE, "Error in cleanTheQueue");
        }
    }
}

