/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_synchrec;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.Properties;

public class MsgBean
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    protected MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private Queue queueS = null;
    private QueueSender mSender = null;
    private boolean result = false;
    private static final System.Logger logger = System.getLogger(MsgBean.class.getName());

    public MsgBean() {
        logger.log(System.Logger.Level.TRACE, "@MsgBean()!");
    }

    public void ejbCreate() {
        logger.log(System.Logger.Level.TRACE, "In Message Bean ======================================EJBCreate");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MY_QUEUE");
            this.queueS = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        long timeout = 10000L;
        QueueSession qSession = null;
        Object messageSent = null;
        TextMessage msgRec = null;
        String mdbMessage = "my mdb message";
        String testName = null;
        Object qSender = null;
        QueueReceiver rcvr = null;
        boolean result = false;
        JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
        logger.log(System.Logger.Level.TRACE, "In Message Bean ======================================onMessage");
        try {
            testName = "mdbResponse";
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                throw new EJBException("MDB connection Error!");
            }
            this.qConnection.start();
            qSession = this.qConnection.createQueueSession(true, 0);
            logger.log(System.Logger.Level.TRACE, "will run TestCase: " + testName);
            rcvr = qSession.createReceiver(this.queueR);
            logger.log(System.Logger.Level.TRACE, "Verify the synchronous receive");
            logger.log(System.Logger.Level.TRACE, "HHHHHHHHHHHHH+++++++++  Trying to receive message from the Queue: ");
            msgRec = (TextMessage)rcvr.receive(timeout);
            if (msgRec != null) {
                logger.log(System.Logger.Level.TRACE, "mdb received a msg from MY_QUEUE");
                if (msgRec.getStringProperty("TestCase").equals(mdbMessage)) {
                    logger.log(System.Logger.Level.TRACE, "Success: Correct msg recvd from MY_QUEUE");
                    result = true;
                }
            }
            JmsUtil.sendTestResults((String)testName, (boolean)result, (QueueSession)qSession, (Queue)this.queueS);
            logger.log(System.Logger.Level.TRACE, "Mdb test results send to queue reply");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        logger.log(System.Logger.Level.TRACE, "@MsgBean:setMessageDrivenContext()!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        logger.log(System.Logger.Level.TRACE, "@ejbRemove()");
    }
}

