/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.ejbweb;

import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee20.cditests.ejbweb.EjbClientIF;
import jakarta.ejb.EJB;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private URL url = null;
    private URLConnection urlConn = null;
    private String SERVLET = "/cditestsejbweb_web/ServletTest";
    @EJB(name="ejb/CDITestsEjbWebClntBean")
    static EjbClientIF ejbclient;
    private static final long serialVersionUID = 1L;
    long timeout;
    String user;
    String password;
    String mode;
    private static final System.Logger logger;

    @BeforeEach
    public void setup() throws Exception {
        boolean pass = true;
        try {
            this.timeout = Integer.parseInt(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            this.hostname = System.getProperty("webServerHost");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            if (this.hostname == null) {
                throw new Exception("'webServerHost' is null");
            }
            try {
                this.portnum = Integer.parseInt(System.getProperty("webServerPort"));
            }
            catch (Exception e) {
                throw new Exception("'webServerPort' in must be a number");
            }
            logger.log(System.Logger.Level.INFO, "AppClient DEBUG: ejbclient=" + ejbclient);
            if (ejbclient == null) {
                throw new Exception("setup failed: ejbclient injection failure");
            }
        }
        catch (Exception e) {
            throw new Exception("setup failed:", e);
        }
        logger.log(System.Logger.Level.INFO, "setup ok");
    }

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "cleanup ok");
    }

    @Test
    public void sendRecvQueueTestUsingCDIFromServlet() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------------------------------");
            logger.log(System.Logger.Level.INFO, "sendRecvQueueTestUsingCDIFromServlet");
            logger.log(System.Logger.Level.INFO, "------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            logger.log(System.Logger.Level.INFO, "Servlet URL: " + this.url);
            this.props.setProperty("TEST", "sendRecvQueueTestUsingCDIFromServlet");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = System.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Servlet");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Servlet");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Servlet");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvQueueTestUsingCDIFromServlet failed");
        }
    }

    @Test
    public void sendRecvTopicTestUsingCDIFromServlet() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------------------------------");
            logger.log(System.Logger.Level.INFO, "sendRecvTopicTestUsingCDIFromServlet");
            logger.log(System.Logger.Level.INFO, "------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            logger.log(System.Logger.Level.INFO, "Servlet URL: " + this.url);
            this.props.setProperty("TEST", "sendRecvTopicTestUsingCDIFromServlet");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = System.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Servlet");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Servlet");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Servlet");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvTopicTestUsingCDIFromServlet failed");
        }
    }

    @Test
    public void sendRecvUsingCDIDefaultFactoryFromServlet() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "-----------------------------------------");
            logger.log(System.Logger.Level.INFO, "sendRecvUsingCDIDefaultFactoryFromServlet");
            logger.log(System.Logger.Level.INFO, "-----------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            logger.log(System.Logger.Level.INFO, "Servlet URL: " + this.url);
            this.props.setProperty("TEST", "sendRecvUsingCDIDefaultFactoryFromServlet");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = System.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Servlet");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Servlet");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Servlet");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvUsingCDIDefaultFactoryFromServlet failed");
        }
    }

    @Test
    public void verifySessionModeOnCDIJMSContextFromServlet() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "-------------------------------------------");
            logger.log(System.Logger.Level.INFO, "verifySessionModeOnCDIJMSContextFromServlet");
            logger.log(System.Logger.Level.INFO, "-------------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            logger.log(System.Logger.Level.INFO, "Servlet URL: " + this.url);
            this.props.setProperty("TEST", "verifySessionModeOnCDIJMSContextFromServlet");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = System.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Servlet");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Servlet");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Servlet");
            pass = false;
        }
        if (!pass) {
            throw new Exception("verifySessionModeOnCDIJMSContextFromServlet failed");
        }
    }

    @Test
    public void testRestrictionsOnCDIJMSContextFromServlet() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------------------------------------");
            logger.log(System.Logger.Level.INFO, "testRestrictionsOnCDIJMSContextFromServlet");
            logger.log(System.Logger.Level.INFO, "------------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            logger.log(System.Logger.Level.INFO, "Servlet URL: " + this.url);
            this.props.setProperty("TEST", "testRestrictionsOnCDIJMSContextFromServlet");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = System.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Servlet");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Servlet");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Servlet");
            pass = false;
        }
        if (!pass) {
            throw new Exception("testRestrictionsOnCDIJMSContextFromServlet failed");
        }
    }

    @Test
    public void sendRecvQueueTestUsingCDIFromEjb() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "--------------------------------");
            logger.log(System.Logger.Level.INFO, "sendRecvQueueTestUsingCDIFromEjb");
            logger.log(System.Logger.Level.INFO, "--------------------------------");
            boolean passEjb = ejbclient.echo("sendRecvQueueTestUsingCDIFromEjb");
            if (!passEjb) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvQueueTestUsingCDIFromEjb failed");
        }
    }

    @Test
    public void sendRecvTopicTestUsingCDIFromEjb() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "--------------------------------");
            logger.log(System.Logger.Level.INFO, "sendRecvTopicTestUsingCDIFromEjb");
            logger.log(System.Logger.Level.INFO, "--------------------------------");
            boolean passEjb = ejbclient.echo("sendRecvTopicTestUsingCDIFromEjb");
            if (!passEjb) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvTopicTestUsingCDIFromEjb failed");
        }
    }

    @Test
    public void sendRecvUsingCDIDefaultFactoryFromEjb() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "-------------------------------------");
            logger.log(System.Logger.Level.INFO, "sendRecvUsingCDIDefaultFactoryFromEjb");
            logger.log(System.Logger.Level.INFO, "-------------------------------------");
            boolean passEjb = ejbclient.echo("sendRecvUsingCDIDefaultFactoryFromEjb");
            if (!passEjb) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvUsingCDIDefaultFactoryFromServlet failed");
        }
    }

    @Test
    public void verifySessionModeOnCDIJMSContextFromEjb() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "---------------------------------------");
            logger.log(System.Logger.Level.INFO, "verifySessionModeOnCDIJMSContextFromEjb");
            logger.log(System.Logger.Level.INFO, "---------------------------------------");
            boolean passEjb = ejbclient.echo("verifySessionModeOnCDIJMSContextFromEjb");
            if (!passEjb) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("verifySessionModeOnCDIJMSContextFromEjb failed");
        }
    }

    @Test
    public void testRestrictionsOnCDIJMSContextFromEjb() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "--------------------------------------");
            logger.log(System.Logger.Level.INFO, "testRestrictionsOnCDIJMSContextFromEjb");
            logger.log(System.Logger.Level.INFO, "--------------------------------------");
            boolean passEjb = ejbclient.echo("testRestrictionsOnCDIJMSContextFromEjb");
            if (!passEjb) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("testRestrictionsOnCDIJMSContextFromEjb failed");
        }
    }

    @Test
    public void testActiveJTAUsingCDIAcross2MethodsFromEjb() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------------------------------------");
            logger.log(System.Logger.Level.INFO, "testActiveJTAUsingCDIAcross2MethodsFromEjb");
            logger.log(System.Logger.Level.INFO, "------------------------------------------");
            boolean passEjb = ejbclient.echo("testActiveJTAUsingCDICallMethod1FromEjb");
            if (!passEjb) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Ejb");
            }
            passEjb = ejbclient.echo("testActiveJTAUsingCDICallMethod2FromEjb");
            if (!passEjb) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new Exception("testActiveJTAUsingCDIAcross2MethodsFromEjb failed");
        }
    }

    @Test
    public void sendRecvQueueTestUsingCDIFromManagedBean() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "----------------------------------------");
            logger.log(System.Logger.Level.INFO, "sendRecvQueueTestUsingCDIFromManagedBean");
            logger.log(System.Logger.Level.INFO, "----------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            logger.log(System.Logger.Level.INFO, "Servlet URL: " + this.url);
            this.props.setProperty("TEST", "sendRecvQueueTestUsingCDIFromManagedBean");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = System.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from ManagedBean");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from ManagedBean");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from ManagedBean");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvQueueTestUsingCDIFromManagedBean failed");
        }
    }

    @Test
    public void sendRecvTopicTestUsingCDIFromManagedBean() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "----------------------------------------");
            logger.log(System.Logger.Level.INFO, "sendRecvTopicTestUsingCDIFromManagedBean");
            logger.log(System.Logger.Level.INFO, "----------------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            logger.log(System.Logger.Level.INFO, "Servlet URL: " + this.url);
            this.props.setProperty("TEST", "sendRecvTopicTestUsingCDIFromManagedBean");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = System.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "CDI injection test failed from ManagedBean");
            } else {
                logger.log(System.Logger.Level.INFO, "CDI injection test passed from ManagedBean");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "CDI injection test failed from ManagedBean");
            pass = false;
        }
        if (!pass) {
            throw new Exception("sendRecvTopicTestUsingCDIFromManagedBean failed");
        }
    }

    static {
        logger = System.getLogger(ClientIT.class.getName());
    }
}

