/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.callStmt.callStmt2;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class callStmtClient2
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.callStmt.callStmt2";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private DataSource ds1 = null;
    private rsSchema rsSch = null;
    private JDBCTestMsg msg = null;
    private String drManager = null;
    private Properties sqlp = null;
    private CallableStatement cstmt = null;

    public static void main(String[] args) {
        callStmtClient2 theTests = new callStmtClient2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.rsSch = new rsSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTime01() throws Exception {
        Time oRetVal = null;
        Time maxTimeVal = null;
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Time_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 92);
            this.cstmt.registerOutParameter(2, 92);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getTime method");
            oRetVal = this.cstmt.getTime(1);
            String sRetStr = this.rsSch.extractVal("Time_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted Time value from Time_Tab");
            sRetStr = sRetStr.substring(sRetStr.indexOf(39) + 1, sRetStr.lastIndexOf(39));
            maxTimeVal = Time.valueOf(sRetStr);
            this.msg.addOutputMsg(String.valueOf(maxTimeVal), String.valueOf(oRetVal));
            if (oRetVal.equals(maxTimeVal)) {
                this.msg.setMsg("getTime returns the Break Time");
            } else {
                this.msg.printTestError("getTime() did not return the proper Break Time", "Call to getTime Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTime is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTime Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetTime02() throws Exception {
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Time_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 92);
            this.cstmt.registerOutParameter(2, 92);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getTime method");
            Time oRetVal = this.cstmt.getTime(2);
            this.msg.addOutputMsg("null", String.valueOf(oRetVal));
            if (oRetVal == null) {
                this.msg.setMsg("getTime returns the null value");
            } else {
                this.msg.printTestError("getTime() did not return the null value", "Call to getTime Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTime is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTime Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTime03() throws Exception {
        Time oRetVal = null;
        Time maxTimeVal = null;
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Time_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 92);
            this.cstmt.registerOutParameter(2, 92);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            Calendar oCalDefault = Calendar.getInstance();
            this.msg.setMsg("invoke getTime method");
            oRetVal = this.cstmt.getTime(1, oCalDefault);
            String sRetStr = this.rsSch.extractVal("Time_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted Time value from Time_Tab");
            sRetStr = sRetStr.substring(sRetStr.indexOf(39) + 1, sRetStr.lastIndexOf(39));
            maxTimeVal = Time.valueOf(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(maxTimeVal)) {
                this.msg.setMsg("getTime returns the Break Time" + oRetVal.toString());
            } else {
                this.msg.printTestError("getTime() did not return the proper Break Time", "Call to getTime Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTime is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTime Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetTime04() throws Exception {
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Time_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 92);
            this.cstmt.registerOutParameter(2, 92);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            Calendar oCalDefault = Calendar.getInstance();
            this.msg.setMsg("invoke getTime method");
            Time oRetVal = this.cstmt.getTime(2, oCalDefault);
            this.msg.addOutputMsg("null", String.valueOf(oRetVal));
            if (oRetVal == null) {
                this.msg.setMsg("getTime returns the null value");
            } else {
                this.msg.printTestError("getTime() did not return the null value", "Call to getTime Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTime is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTime Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTimestamp01() throws Exception {
        Timestamp oRetVal = null;
        Timestamp maxTimestampVal = null;
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Timestamp_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 93);
            this.cstmt.registerOutParameter(2, 93);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getTimestamp method");
            oRetVal = this.cstmt.getTimestamp(1);
            String sRetStr = this.rsSch.extractVal("Timestamp_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted Timestamp value from Timestamp_Tab");
            sRetStr = sRetStr.substring(sRetStr.indexOf(39) + 1, sRetStr.lastIndexOf(39));
            maxTimestampVal = Timestamp.valueOf(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(maxTimestampVal)) {
                this.msg.setMsg("getTimestamp returns the In Time");
            } else {
                this.msg.printTestError("getTimestamp() did not return the proper In Time", "Call to getTimestamp Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTimestamp is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTimestamp Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetTimestamp02() throws Exception {
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Timestamp_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 93);
            this.cstmt.registerOutParameter(2, 93);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getTimestamp method");
            Timestamp oRetVal = this.cstmt.getTimestamp(2);
            this.msg.addOutputMsg("null", String.valueOf(oRetVal));
            if (oRetVal == null) {
                this.msg.setMsg("getTimestamp returns the null value");
            } else {
                this.msg.printTestError("getTimestamp() did not return the null value", "Call to getTimestamp Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTimestamp is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTimestamp Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTimestamp03() throws Exception {
        Timestamp oRetVal = null;
        Timestamp maxTimestampVal = null;
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Timestamp_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 93);
            this.cstmt.registerOutParameter(2, 93);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("Calling CallableStatement.getTimestamp(IN_TIME,Calendar)");
            Calendar oCalDefault = Calendar.getInstance();
            this.msg.setMsg("invoke getTimestamp method");
            oRetVal = this.cstmt.getTimestamp(1, oCalDefault);
            String sRetStr = this.rsSch.extractVal("Timestamp_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted Timestamp value from Timestamp_Tab");
            sRetStr = sRetStr.substring(sRetStr.indexOf(39) + 1, sRetStr.lastIndexOf(39));
            maxTimestampVal = Timestamp.valueOf(sRetStr);
            this.msg.addOutputMsg(String.valueOf(maxTimestampVal), oRetVal.toString());
            if (oRetVal.equals(maxTimestampVal)) {
                this.msg.setMsg("getTimestamp returns the In Time");
            } else {
                this.msg.printTestError("getTimestamp() did not return the proper In Time", "Call to getTimestamp Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTimestamp is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTimestamp Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetTimestamp04() throws Exception {
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Timestamp_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 93);
            this.cstmt.registerOutParameter(2, 93);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("get the calendar instance");
            Calendar oCalDefault = Calendar.getInstance();
            this.msg.setMsg("invoke getTimestamp method");
            Timestamp oRetVal = this.cstmt.getTimestamp(2, oCalDefault);
            this.msg.addOutputMsg("null", String.valueOf(oRetVal));
            if (oRetVal == null) {
                this.msg.setMsg("getTimestamp returns the null value");
            } else {
                this.msg.printTestError("getTimestamp() did not return the null value", "Call to getTimestamp Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTimestamp is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTimestamp Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetDate01() throws Exception {
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Date_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 91);
            this.cstmt.registerOutParameter(2, 91);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getDate method");
            Date oRetVal = this.cstmt.getDate(1);
            String sRetStr = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted the Date value from Date_Tab");
            sRetStr = sRetStr.substring(sRetStr.indexOf(39) + 1, sRetStr.lastIndexOf(39));
            sRetStr = sRetStr.trim();
            Date oExtVal = Date.valueOf(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.toString().equals(oExtVal.toString())) {
                this.msg.setMsg("getDate returns the Date");
            } else {
                this.msg.printTestError("getDate() did not return the proper Manufacturing Date", "Call to getDate Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDate Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetDate02() throws Exception {
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Date_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 91);
            this.cstmt.registerOutParameter(2, 91);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getDate method");
            Date oRetVal = this.cstmt.getDate(2);
            this.msg.addOutputMsg("null", String.valueOf(oRetVal));
            if (oRetVal == null) {
                this.msg.setMsg("getDate returns the null value");
            } else {
                this.msg.printTestError("getDate() did not return the null value", "Call to getDate Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDate Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetDate03() throws Exception {
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Date_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 91);
            this.cstmt.registerOutParameter(2, 91);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("get the calendar instance");
            Calendar oCalDefault = Calendar.getInstance();
            this.msg.setMsg("invoke getTimestamp method");
            Date oRetVal = this.cstmt.getDate(1, oCalDefault);
            String sRetStr = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            sRetStr = sRetStr.substring(sRetStr.indexOf(39) + 1, sRetStr.lastIndexOf(39));
            sRetStr = sRetStr.trim();
            Date oExtVal = Date.valueOf(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.toString().equals(oExtVal.toString())) {
                this.msg.setMsg("getDate returns the Manufacturing Date");
            } else {
                this.msg.printTestError("getDate() did not return the proper In Time", "Call to getDate Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDate Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetDate04() throws Exception {
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Date_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 91);
            this.cstmt.registerOutParameter(2, 91);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("get the calendar instance");
            Calendar oCalDefault = Calendar.getInstance();
            this.msg.setMsg("invoke getDate method");
            Date oRetVal = this.cstmt.getDate(2, oCalDefault);
            this.msg.addOutputMsg("null", String.valueOf(oRetVal));
            if (oRetVal == null) {
                this.msg.setMsg("getDate returns the null value");
            } else {
                this.msg.printTestError("getDate() did not return the null value", "Call to getDate Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDate Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte01() throws Exception {
        Byte oRetVal = null;
        Byte maxByteVal = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -6);
            this.cstmt.registerOutParameter(2, -6);
            this.cstmt.registerOutParameter(3, -6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getByte method");
            byte yRetVal = this.cstmt.getByte(1);
            oRetVal = new Byte(yRetVal);
            String sRetStr = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted MAX_VAL from Tinyint_Tab");
            maxByteVal = new Byte(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(maxByteVal)) {
                this.msg.setMsg("getByte returns the Maximum Value" + oRetVal.toString());
            } else {
                this.msg.printTestError("getByte() did not return the Maximum Value", "Call to getByte Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetByte02() throws Exception {
        Byte oRetVal = null;
        Byte minByteVal = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -6);
            this.cstmt.registerOutParameter(2, -6);
            this.cstmt.registerOutParameter(3, -6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getByte method");
            byte yRetVal = this.cstmt.getByte(2);
            oRetVal = new Byte(yRetVal);
            String sRetStr = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted MIN_VAL from Tinyint_Tab");
            minByteVal = new Byte(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(minByteVal)) {
                this.msg.setMsg("getByte returns the Minimum Value" + oRetVal.toString());
            } else {
                this.msg.printTestError("getByte() did not return the Minimum Value", "Call to getByte Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetByte03() throws Exception {
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Tinyint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -6);
            this.cstmt.registerOutParameter(2, -6);
            this.cstmt.registerOutParameter(3, -6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getByte method");
            byte yRetVal = this.cstmt.getByte(3);
            this.msg.addOutputMsg("0", Byte.toString(yRetVal));
            if (yRetVal == 0) {
                this.msg.setMsg("getByte returns the Null Value");
            } else {
                this.msg.printTestError("getByte() did not return the Null Value", "Call to getByte Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getByte Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetDouble01() throws Exception {
        Double oRetVal = null;
        Double maxDoubleVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 8);
            this.cstmt.registerOutParameter(2, 8);
            this.cstmt.registerOutParameter(3, 8);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getDouble method");
            double dRetVal = this.cstmt.getDouble(1);
            oRetVal = new Double(dRetVal);
            String sRetStr = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted maximum value from Double_Tab");
            maxDoubleVal = new Double(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(maxDoubleVal)) {
                this.msg.setMsg("getDouble returns the Maximum Value");
            } else {
                this.msg.printTestError("getDouble() did not return the Maximum Value", "Call to getDouble Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDouble is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDouble Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetDouble02() throws Exception {
        Double oRetVal = null;
        Double minDoubleVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 8);
            this.cstmt.registerOutParameter(2, 8);
            this.cstmt.registerOutParameter(3, 8);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getDouble method");
            double dRetVal = this.cstmt.getDouble(2);
            oRetVal = new Double(dRetVal);
            String sRetStr = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted minimum value from Double_Tab");
            minDoubleVal = new Double(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(minDoubleVal)) {
                this.msg.setMsg("getDouble returns the Minimum Value" + oRetVal.toString());
            } else {
                this.msg.printTestError("getDouble() did not return the Minimum Value", "Call to getDouble Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDouble is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDouble Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetDouble03() throws Exception {
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Double_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 8);
            this.cstmt.registerOutParameter(2, 8);
            this.cstmt.registerOutParameter(3, 8);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getDouble method");
            double dRetVal = this.cstmt.getDouble(3);
            this.msg.addOutputMsg("0.0", new Double(dRetVal).toString());
            if (dRetVal == 0.0) {
                this.msg.setMsg("getDouble returns the Null Value");
            } else {
                this.msg.printTestError("getDouble() did not return the Null Value", "Call to getDouble Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getDouble is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getDouble Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testWasNull() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 4);
            this.cstmt.registerOutParameter(2, 4);
            this.cstmt.registerOutParameter(3, 4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getInteger method");
            int nRetVal = this.cstmt.getInt(3);
            this.msg.setMsg("execute the method cstmt.wasNull");
            if (this.cstmt.wasNull()) {
                this.msg.setMsg("The last OUT parameter read had the value of SQL NULL");
            } else {
                this.msg.printTestError("The last OUT parameter read did not have the value of SQL NULL", " ");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to wasNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to wasNull Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

