/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.Merge;
import com.sun.tdk.signaturetest.Setup;
import com.sun.tdk.signaturetest.SetupAndTest;
import com.sun.tdk.signaturetest.SignatureTest;
import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.util.BatchFileParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.SwissKnife;

public class Main {
    private static final String COMMAND_SETUP = "Setup";
    private static final String COMMAND_TEST = "Test";
    private static final String COMMAND_TEST_ALT = "SignatureTest";
    private static final String COMMAND_SETUP_AND_TEST = "SetupAndTest";
    private static final String COMMAND_MERGE = "Merge";
    private static final String COMMAND_HELP = "-help";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);
    private static boolean isSigtestdevJar;
    private static String jar;

    private static void commonUsage() {
        System.out.println(i18n.getString("Main.usage.version", "3.1"));
        System.out.println(i18n.getString("Main.usage.variant.command", "java -jar " + jar));
        System.out.println(i18n.getString("Main.usage.variant.help", new Object[]{"java -jar " + jar, COMMAND_HELP}));
        System.out.println();
        if (isSigtestdevJar) {
            System.out.println(i18n.getString("Main.usage.variant.canbedev", new Object[]{COMMAND_SETUP, COMMAND_TEST, COMMAND_SETUP_AND_TEST, COMMAND_MERGE}));
        } else {
            System.out.println(i18n.getString("Main.usage.variant.canbe", new Object[]{COMMAND_TEST, COMMAND_MERGE}));
        }
    }

    public static void main(String[] args) {
        try {
            Class.forName("com.sun.tdk.signaturetest.Setup");
            isSigtestdevJar = true;
        }
        catch (ClassNotFoundException e) {
            isSigtestdevJar = false;
        }
        jar = isSigtestdevJar ? "sigtestdev.jar" : "sigtest.jar";
        try {
            args = BatchFileParser.processParameters(args);
        }
        catch (CommandLineParserException ex) {
            SwissKnife.reportThrowable(ex);
        }
        if (args.length == 0 || args.length == 1 && args[0].equalsIgnoreCase(COMMAND_HELP)) {
            Main.commonUsage();
        } else {
            String[] otherArgs = new String[args.length - 1];
            System.arraycopy(args, 1, otherArgs, 0, args.length - 1);
            if (args[0].equalsIgnoreCase(COMMAND_SETUP)) {
                if (isSigtestdevJar) {
                    Setup.main(otherArgs);
                } else {
                    System.out.println(i18n.getString("Main.command.absent", new Object[]{COMMAND_SETUP, jar}));
                }
            } else if (args[0].equalsIgnoreCase(COMMAND_TEST) || args[0].equalsIgnoreCase(COMMAND_TEST_ALT)) {
                SignatureTest.main(otherArgs);
            } else if (args[0].equalsIgnoreCase(COMMAND_SETUP_AND_TEST)) {
                if (isSigtestdevJar) {
                    SetupAndTest.main(otherArgs);
                } else {
                    System.out.println(i18n.getString("Main.command.absent", new Object[]{COMMAND_SETUP_AND_TEST, jar}));
                }
            } else if (args[0].equalsIgnoreCase(COMMAND_MERGE)) {
                Merge.main(otherArgs);
            } else if (args[0].equalsIgnoreCase("-Version")) {
                Main.printVersionInfo();
                System.exit(1);
            } else {
                Main.commonUsage();
                System.exit(1);
            }
        }
    }

    private static void printVersionInfo() {
        System.out.println(Version.getVersionInfo());
    }
}

