/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.PasswordProvider;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.LDAPSDKUsageException;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SimpleBindRequest
extends BindRequest
implements ResponseAcceptor,
ProtocolOp {
    private static final byte CRED_TYPE_SIMPLE = -128;
    private static final ASN1OctetString NO_BIND_DN = new ASN1OctetString();
    private static final ASN1OctetString NO_PASSWORD = new ASN1OctetString(-128);
    private static final long serialVersionUID = 4725871243149974407L;
    private int messageID = -1;
    private final ASN1OctetString bindDN;
    private final ASN1OctetString password;
    private final LinkedBlockingQueue<LDAPResponse> responseQueue = new LinkedBlockingQueue();
    private final PasswordProvider passwordProvider;

    public SimpleBindRequest() {
        this(NO_BIND_DN, NO_PASSWORD, null, NO_CONTROLS);
    }

    public SimpleBindRequest(String bindDN, String password) {
        this(bindDN, password, NO_CONTROLS);
    }

    public SimpleBindRequest(String bindDN, byte[] password) {
        this(bindDN, password, NO_CONTROLS);
    }

    public SimpleBindRequest(DN bindDN, String password) {
        this(bindDN, password, NO_CONTROLS);
    }

    public SimpleBindRequest(DN bindDN, byte[] password) {
        this(bindDN, password, NO_CONTROLS);
    }

    public SimpleBindRequest(String bindDN, String password, Control ... controls) {
        super(controls);
        this.bindDN = bindDN == null ? NO_BIND_DN : new ASN1OctetString(bindDN);
        this.password = password == null ? NO_PASSWORD : new ASN1OctetString(-128, password);
        this.passwordProvider = null;
    }

    public SimpleBindRequest(String bindDN, byte[] password, Control ... controls) {
        super(controls);
        this.bindDN = bindDN == null ? NO_BIND_DN : new ASN1OctetString(bindDN);
        this.password = password == null ? NO_PASSWORD : new ASN1OctetString(-128, password);
        this.passwordProvider = null;
    }

    public SimpleBindRequest(DN bindDN, String password, Control ... controls) {
        super(controls);
        this.bindDN = bindDN == null ? NO_BIND_DN : new ASN1OctetString(bindDN.toString());
        this.password = password == null ? NO_PASSWORD : new ASN1OctetString(-128, password);
        this.passwordProvider = null;
    }

    public SimpleBindRequest(DN bindDN, byte[] password, Control ... controls) {
        super(controls);
        this.bindDN = bindDN == null ? NO_BIND_DN : new ASN1OctetString(bindDN.toString());
        this.password = password == null ? NO_PASSWORD : new ASN1OctetString(-128, password);
        this.passwordProvider = null;
    }

    public SimpleBindRequest(String bindDN, PasswordProvider passwordProvider, Control ... controls) {
        super(controls);
        this.bindDN = new ASN1OctetString(bindDN);
        this.passwordProvider = passwordProvider;
        this.password = null;
    }

    public SimpleBindRequest(DN bindDN, PasswordProvider passwordProvider, Control ... controls) {
        super(controls);
        this.bindDN = new ASN1OctetString(bindDN.toString());
        this.passwordProvider = passwordProvider;
        this.password = null;
    }

    private SimpleBindRequest(ASN1OctetString bindDN, ASN1OctetString password, PasswordProvider passwordProvider, Control ... controls) {
        super(controls);
        this.bindDN = bindDN;
        this.password = password;
        this.passwordProvider = passwordProvider;
    }

    public String getBindDN() {
        return this.bindDN.stringValue();
    }

    public ASN1OctetString getPassword() {
        return this.password;
    }

    public PasswordProvider getPasswordProvider() {
        return this.passwordProvider;
    }

    @Override
    public byte getProtocolOpType() {
        return 96;
    }

    @Override
    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence requestSequence = buffer.beginSequence((byte)96);
        buffer.addElement(VERSION_ELEMENT);
        buffer.addElement(this.bindDN);
        if (this.passwordProvider == null) {
            buffer.addElement(this.password);
        } else {
            byte[] pwBytes;
            try {
                pwBytes = this.passwordProvider.getPasswordBytes();
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw new LDAPRuntimeException(le);
            }
            ASN1OctetString pw = new ASN1OctetString(-128, pwBytes);
            buffer.addElement(pw);
            buffer.setZeroBufferOnClear();
            Arrays.fill(pwBytes, (byte)0);
        }
        requestSequence.end();
    }

    @Override
    public ASN1Element encodeProtocolOp() throws LDAPSDKUsageException {
        if (this.password == null) {
            throw new LDAPSDKUsageException(LDAPMessages.ERR_SIMPLE_BIND_ENCODE_PROTOCOL_OP_WITH_PROVIDER.get());
        }
        return new ASN1Sequence(96, new ASN1Integer(3), this.bindDN, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        if (connection.synchronousMode()) {
            boolean autoReconnect = connection.getConnectionOptions().autoReconnect();
            return this.processSync(connection, autoReconnect);
        }
        if (this.password != null && this.bindDN.getValue().length > 0 && this.password.getValue().length == 0 && connection.getConnectionOptions().bindWithDNRequiresPassword()) {
            LDAPException le = new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_SIMPLE_BIND_DN_WITHOUT_PASSWORD.get());
            Debug.debugCodingError(le);
            throw le;
        }
        this.messageID = connection.nextMessageID();
        LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
        connection.registerResponseAcceptor(this.messageID, this);
        try {
            LDAPResponse response;
            Debug.debugLDAPRequest(this);
            long requestTime = System.nanoTime();
            connection.getConnectionStatistics().incrementNumBindRequests();
            connection.sendMessage(message);
            try {
                long responseTimeout = this.getResponseTimeoutMillis(connection);
                response = responseTimeout > 0L ? this.responseQueue.poll(responseTimeout, TimeUnit.MILLISECONDS) : this.responseQueue.take();
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                Thread.currentThread().interrupt();
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_BIND_INTERRUPTED.get(connection.getHostPort()), ie);
            }
            BindResult bindResult = this.handleResponse(connection, response, requestTime, false);
            return bindResult;
        }
        finally {
            connection.deregisterResponseAcceptor(this.messageID);
        }
    }

    private BindResult processSync(LDAPConnection connection, boolean allowRetry) throws LDAPException {
        LDAPResponse response;
        long requestTime;
        block5: {
            this.messageID = connection.nextMessageID();
            LDAPMessage message = new LDAPMessage(this.messageID, (ProtocolOp)this, this.getControls());
            try {
                connection.getConnectionInternals(true).getSocket().setSoTimeout((int)this.getResponseTimeoutMillis(connection));
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            requestTime = System.nanoTime();
            Debug.debugLDAPRequest(this);
            connection.getConnectionStatistics().incrementNumBindRequests();
            try {
                connection.sendMessage(message);
            }
            catch (LDAPException le) {
                BindResult bindResult;
                Debug.debugException(le);
                if (!allowRetry || (bindResult = this.reconnectAndRetry(connection, le.getResultCode())) == null) break block5;
                return bindResult;
            }
        }
        while ((response = connection.readResponse(this.messageID)) instanceof IntermediateResponse) {
            IntermediateResponseListener listener = this.getIntermediateResponseListener();
            if (listener == null) continue;
            listener.intermediateResponseReturned((IntermediateResponse)response);
        }
        return this.handleResponse(connection, response, requestTime, allowRetry);
    }

    private BindResult handleResponse(LDAPConnection connection, LDAPResponse response, long requestTime, boolean allowRetry) throws LDAPException {
        BindResult retryResult;
        if (response == null) {
            long waitTime = StaticUtils.nanosToMillis(System.nanoTime() - requestTime);
            throw new LDAPException(ResultCode.TIMEOUT, LDAPMessages.ERR_SIMPLE_BIND_CLIENT_TIMEOUT.get(waitTime, this.messageID, this.bindDN.stringValue(), connection.getHostPort()));
        }
        connection.getConnectionStatistics().incrementNumBindResponses(System.nanoTime() - requestTime);
        if (response instanceof ConnectionClosedResponse) {
            BindResult retryResult2;
            if (allowRetry && (retryResult2 = this.reconnectAndRetry(connection, ResultCode.SERVER_DOWN)) != null) {
                return retryResult2;
            }
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String message = ccr.getMessage();
            if (message == null) {
                throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE.get(connection.getHostPort(), this.toString()));
            }
            throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_BIND_RESPONSE_WITH_MESSAGE.get(connection.getHostPort(), this.toString(), message));
        }
        BindResult bindResult = (BindResult)response;
        if (allowRetry && (retryResult = this.reconnectAndRetry(connection, bindResult.getResultCode())) != null) {
            return retryResult;
        }
        return bindResult;
    }

    private BindResult reconnectAndRetry(LDAPConnection connection, ResultCode resultCode) {
        try {
            switch (resultCode.intValue()) {
                case 81: 
                case 84: 
                case 91: {
                    connection.reconnect();
                    return this.processSync(connection, false);
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        return null;
    }

    @Override
    public SimpleBindRequest getRebindRequest(String host, int port) {
        return new SimpleBindRequest(this.bindDN, this.password, this.passwordProvider, this.getControls());
    }

    @Override
    @InternalUseOnly
    public void responseReceived(LDAPResponse response) throws LDAPException {
        try {
            this.responseQueue.put(response);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_EXCEPTION_HANDLING_RESPONSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public String getBindType() {
        return "SIMPLE";
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public SimpleBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public SimpleBindRequest duplicate(Control[] controls) {
        SimpleBindRequest bindRequest = new SimpleBindRequest(this.bindDN, this.password, this.passwordProvider, controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return bindRequest;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("SimpleBindRequest(dn='");
        buffer.append(this.bindDN);
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    @Override
    public void toCode(List<String> lineList, String requestID, int indentSpaces, boolean includeProcessing) {
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(3);
        constructorArgs.add(ToCodeArgHelper.createString(this.bindDN.stringValue(), "Bind DN"));
        constructorArgs.add(ToCodeArgHelper.createString("---redacted-password---", "Bind Password"));
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            constructorArgs.add(ToCodeArgHelper.createControlArray(controls, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "SimpleBindRequest", requestID + "Request", "new SimpleBindRequest", constructorArgs);
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + "try");
            lineList.add(indent + '{');
            lineList.add(indent + "  BindResult " + requestID + "Result = connection.bind(" + requestID + "Request);");
            lineList.add(indent + "  // The bind was processed successfully.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The bind failed.  Maybe the following will " + "help explain why.");
            lineList.add(indent + "  // Note that the connection is now likely in " + "an unauthenticated state.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = " + "e.getResponseControls();");
            lineList.add(indent + '}');
        }
    }
}

