/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ASN1Writer {
    private static final ThreadLocal<ByteStringBuffer> buffers = new ThreadLocal();
    private static final int MAX_BUFFER_LENGTH = 524288;

    private ASN1Writer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeElement(ASN1Element element, OutputStream outputStream) throws IOException {
        Debug.debugASN1Write(element);
        ByteStringBuffer buffer = buffers.get();
        if (buffer == null) {
            buffer = new ByteStringBuffer();
            buffers.set(buffer);
        }
        element.encodeTo(buffer);
        try {
            buffer.write(outputStream);
        }
        finally {
            if (buffer.capacity() > 524288) {
                buffer.setCapacity(524288);
            }
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeElement(ASN1Element element, ByteBuffer buffer) throws BufferOverflowException {
        Debug.debugASN1Write(element);
        ByteStringBuffer b = buffers.get();
        if (b == null) {
            b = new ByteStringBuffer();
            buffers.set(b);
        }
        element.encodeTo(b);
        try {
            if (buffer.remaining() < b.length()) {
                throw new BufferOverflowException();
            }
            int pos = buffer.position();
            buffer.put(b.getBackingArray(), 0, b.length());
            buffer.limit(buffer.position());
            buffer.position(pos);
        }
        finally {
            if (b.capacity() > 524288) {
                b.setCapacity(524288);
            }
            b.clear();
        }
    }
}

