/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class VersionMonitorEntry
extends MonitorEntry {
    protected static final String VERSION_MONITOR_OC = "ds-version-monitor-entry";
    private static final String ATTR_BUILD_ID = "buildID";
    private static final String ATTR_BUILD_NUMBER = "buildNumber";
    private static final String ATTR_COMPACT_VERSION = "compactVersion";
    private static final String ATTR_FIX_IDS = "fixIDs";
    private static final String ATTR_FULL_VERSION = "fullVersion";
    private static final String ATTR_GROOVY_VERSION = "groovyVersion";
    private static final String ATTR_JE_VERSION = "jeVersion";
    private static final String ATTR_JZLIB_VERSION = "jzlibVersion";
    private static final String ATTR_LDAP_SDK_VERSION = "ldapSDKVersion";
    private static final String ATTR_MAJOR_VERSION = "majorVersion";
    private static final String ATTR_MINOR_VERSION = "minorVersion";
    private static final String ATTR_POINT_VERSION = "pointVersion";
    private static final String ATTR_PRODUCT_NAME = "productName";
    private static final String ATTR_REVISION_NUMBER = "revisionNumber";
    private static final String ATTR_SERVER_SDK_VERSION = "serverSDKVersion";
    private static final String ATTR_SHORT_NAME = "shortName";
    private static final String ATTR_SNMP4J_VERSION = "snmp4jVersion";
    private static final String ATTR_SNMP4J_AGENT_VERSION = "snmp4jAgentVersion";
    private static final String ATTR_SNMP4J_AGENTX_VERSION = "snmp4jAgentXVersion";
    private static final String ATTR_VERSION_QUALIFIER = "versionQualifier";
    private static final long serialVersionUID = -8501846678698542926L;
    private final Long buildNumber = this.getLong("buildNumber");
    private final Long majorVersion = this.getLong("majorVersion");
    private final Long minorVersion = this.getLong("minorVersion");
    private final Long pointVersion = this.getLong("pointVersion");
    private final Long revisionNumber = this.getLong("revisionNumber");
    private final String buildID = this.getString("buildID");
    private final String compactVersion = this.getString("compactVersion");
    private final String fixIDs = this.getString("fixIDs");
    private final String groovyVersion = this.getString("groovyVersion");
    private final String fullVersion = this.getString("fullVersion");
    private final String jeVersion = this.getString("jeVersion");
    private final String jzlibVersion = this.getString("jzlibVersion");
    private final String ldapSDKVersion = this.getString("ldapSDKVersion");
    private final String productName = this.getString("productName");
    private final String serverSDKVersion = this.getString("serverSDKVersion");
    private final String shortName = this.getString("shortName");
    private final String snmp4jVersion = this.getString("snmp4jVersion");
    private final String snmp4jAgentVersion = this.getString("snmp4jAgentVersion");
    private final String snmp4jAgentXVersion = this.getString("snmp4jAgentXVersion");
    private final String versionQualifier = this.getString("versionQualifier");

    public VersionMonitorEntry(Entry entry) {
        super(entry);
    }

    public String getBuildID() {
        return this.buildID;
    }

    public Long getBuildNumber() {
        return this.buildNumber;
    }

    public String getCompactVersion() {
        return this.compactVersion;
    }

    public String getFixIDs() {
        return this.fixIDs;
    }

    public String getFullVersion() {
        return this.fullVersion;
    }

    public String getGroovyVersion() {
        return this.groovyVersion;
    }

    public String getBerkeleyDBJEVersion() {
        return this.jeVersion;
    }

    public String getJZLibVersion() {
        return this.jzlibVersion;
    }

    public String getLDAPSDKVersion() {
        return this.ldapSDKVersion;
    }

    public Long getMajorVersion() {
        return this.majorVersion;
    }

    public Long getMinorVersion() {
        return this.minorVersion;
    }

    public Long getPointVersion() {
        return this.pointVersion;
    }

    public String getProductName() {
        return this.productName;
    }

    public Long getRevisionNumber() {
        return this.revisionNumber;
    }

    public String getServerSDKVersion() {
        return this.serverSDKVersion;
    }

    public String getShortProductName() {
        return this.shortName;
    }

    public String getSNMP4JVersion() {
        return this.snmp4jVersion;
    }

    public String getSNMP4JAgentVersion() {
        return this.snmp4jAgentVersion;
    }

    public String getSNMP4JAgentXVersion() {
        return this.snmp4jAgentXVersion;
    }

    public String getVersionQualifier() {
        return this.versionQualifier;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_VERSION_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_VERSION_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(20);
        if (this.productName != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_PRODUCT_NAME, MonitorMessages.INFO_VERSION_DISPNAME_PRODUCT_NAME.get(), MonitorMessages.INFO_VERSION_DESC_PRODUCT_NAME.get(), this.productName);
        }
        if (this.shortName != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_SHORT_NAME, MonitorMessages.INFO_VERSION_DISPNAME_SHORT_NAME.get(), MonitorMessages.INFO_VERSION_DESC_SHORT_NAME.get(), this.shortName);
        }
        if (this.fullVersion != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_FULL_VERSION, MonitorMessages.INFO_VERSION_DISPNAME_FULL_VERSION.get(), MonitorMessages.INFO_VERSION_DESC_FULL_VERSION.get(), this.fullVersion);
        }
        if (this.compactVersion != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_COMPACT_VERSION, MonitorMessages.INFO_VERSION_DISPNAME_COMPACT_VERSION.get(), MonitorMessages.INFO_VERSION_DESC_COMPACT_VERSION.get(), this.compactVersion);
        }
        if (this.buildID != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_BUILD_ID, MonitorMessages.INFO_VERSION_DISPNAME_BUILD_ID.get(), MonitorMessages.INFO_VERSION_DESC_BUILD_ID.get(), this.buildID);
        }
        if (this.majorVersion != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_MAJOR_VERSION, MonitorMessages.INFO_VERSION_DISPNAME_MAJOR_VERSION.get(), MonitorMessages.INFO_VERSION_DESC_MAJOR_VERSION.get(), this.majorVersion);
        }
        if (this.minorVersion != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_MINOR_VERSION, MonitorMessages.INFO_VERSION_DISPNAME_MINOR_VERSION.get(), MonitorMessages.INFO_VERSION_DESC_MINOR_VERSION.get(), this.minorVersion);
        }
        if (this.pointVersion != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_POINT_VERSION, MonitorMessages.INFO_VERSION_DISPNAME_POINT_VERSION.get(), MonitorMessages.INFO_VERSION_DESC_POINT_VERSION.get(), this.pointVersion);
        }
        if (this.buildNumber != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_BUILD_NUMBER, MonitorMessages.INFO_VERSION_DISPNAME_BUILD_NUMBER.get(), MonitorMessages.INFO_VERSION_DESC_BUILD_NUMBER.get(), this.buildNumber);
        }
        if (this.versionQualifier != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_VERSION_QUALIFIER, MonitorMessages.INFO_VERSION_DISPNAME_VERSION_QUALIFIER.get(), MonitorMessages.INFO_VERSION_DESC_VERSION_QUALIFIER.get(), this.versionQualifier);
        }
        if (this.revisionNumber != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_REVISION_NUMBER, MonitorMessages.INFO_VERSION_DISPNAME_REVISION_NUMBER.get(), MonitorMessages.INFO_VERSION_DESC_REVISION_NUMBER.get(), this.revisionNumber);
        }
        if (this.fixIDs != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_FIX_IDS, MonitorMessages.INFO_VERSION_DISPNAME_FIX_IDS.get(), MonitorMessages.INFO_VERSION_DESC_FIX_IDS.get(), this.fixIDs);
        }
        if (this.groovyVersion != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_GROOVY_VERSION, MonitorMessages.INFO_VERSION_DISPNAME_GROOVY_VERSION.get(), MonitorMessages.INFO_VERSION_DESC_GROOVY_VERSION.get(), this.groovyVersion);
        }
        if (this.jeVersion != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_JE_VERSION, MonitorMessages.INFO_VERSION_DISPNAME_JE_VERSION.get(), MonitorMessages.INFO_VERSION_DESC_JE_VERSION.get(), this.jeVersion);
        }
        if (this.jzlibVersion != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_JZLIB_VERSION, MonitorMessages.INFO_VERSION_DISPNAME_JZLIB_VERSION.get(), MonitorMessages.INFO_VERSION_DESC_JZLIB_VERSION.get(), this.jzlibVersion);
        }
        if (this.ldapSDKVersion != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_LDAP_SDK_VERSION, MonitorMessages.INFO_VERSION_DISPNAME_LDAP_SDK_VERSION.get(), MonitorMessages.INFO_VERSION_DESC_LDAP_SDK_VERSION.get(), this.ldapSDKVersion);
        }
        if (this.serverSDKVersion != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_SERVER_SDK_VERSION, MonitorMessages.INFO_VERSION_DISPNAME_SERVER_SDK_VERSION.get(), MonitorMessages.INFO_VERSION_DESC_SERVER_SDK_VERSION.get(), this.serverSDKVersion);
        }
        if (this.snmp4jVersion != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_SNMP4J_VERSION, MonitorMessages.INFO_VERSION_DISPNAME_SNMP4J_VERSION.get(), MonitorMessages.INFO_VERSION_DESC_SNMP4J_VERSION.get(), this.snmp4jVersion);
        }
        if (this.snmp4jAgentVersion != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_SNMP4J_AGENT_VERSION, MonitorMessages.INFO_VERSION_DISPNAME_SNMP4J_AGENT_VERSION.get(), MonitorMessages.INFO_VERSION_DESC_SNMP4J_AGENT_VERSION.get(), this.snmp4jAgentVersion);
        }
        if (this.snmp4jAgentXVersion != null) {
            VersionMonitorEntry.addMonitorAttribute(attrs, ATTR_SNMP4J_AGENTX_VERSION, MonitorMessages.INFO_VERSION_DISPNAME_SNMP4J_AGENTX_VERSION.get(), MonitorMessages.INFO_VERSION_DESC_SNMP4J_AGENTX_VERSION.get(), this.snmp4jAgentXVersion);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

