/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.callback.methodoverride;

import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusIF;
import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusImpl;
import com.sun.ts.tests.jpa.core.callback.common.GenerictListenerImpl;
import com.sun.ts.tests.jpa.core.callback.methodoverride.LineItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ORDER_TABLE")
public class Order
extends CallbackStatusImpl
implements Serializable,
CallbackStatusIF {
    private String id;
    private double totalPrice;
    private LineItem sampleLineItem;
    private Collection<LineItem> lineItemsCollection = new ArrayList<LineItem>();
    private GenerictListenerImpl callbackImpl = new GenerictListenerImpl();

    public Order() {
    }

    public Order(String id, double totalPrice) {
        this.id = id;
        this.totalPrice = totalPrice;
    }

    @Transient
    public GenerictListenerImpl getCallbackImpl() {
        return this.callbackImpl;
    }

    public void setCallbackImpl(GenerictListenerImpl callbackImpl) {
        this.callbackImpl = callbackImpl;
    }

    private void prePersist() {
        this.getCallbackImpl().prePersist(this);
    }

    private void postPersist() {
        this.getCallbackImpl().postPersist(this);
    }

    private void preRemove() {
        this.getCallbackImpl().preRemove(this);
    }

    private void postRemove() {
        this.getCallbackImpl().postRemove(this);
    }

    private void preUpdate() {
        this.getCallbackImpl().preUpdate(this);
    }

    private void postUpdate() {
        this.getCallbackImpl().postUpdate(this);
    }

    private void postLoad() {
        this.getCallbackImpl().postLoad(this);
    }

    @Id
    @Column(name="ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Column(name="TOTALPRICE")
    public double getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(double price) {
        this.totalPrice = price;
    }

    @OneToOne(cascade={CascadeType.REMOVE})
    @JoinColumn(name="FK0_FOR_LINEITEM_TABLE")
    public LineItem getSampleLineItem() {
        return this.sampleLineItem;
    }

    public void setSampleLineItem(LineItem l) {
        this.sampleLineItem = l;
    }

    @OneToMany(mappedBy="order", cascade={CascadeType.ALL})
    public Collection<LineItem> getLineItemsCollection() {
        return this.lineItemsCollection;
    }

    public void setLineItemsCollection(Collection<LineItem> c) {
        this.lineItemsCollection = c;
    }

    public void addLineItem(LineItem p) {
        this.getLineItemsCollection().add(p);
    }
}

