/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.frame;

import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.frame.Http2Frame;

public abstract class HeaderFrame
extends Http2Frame {
    final int headerLength;
    final ByteBufferReference[] headerBlocks;
    public static final int END_STREAM = 1;
    public static final int END_HEADERS = 4;

    public HeaderFrame(int n, int n2, ByteBufferReference byteBufferReference) {
        this(n, n2, new ByteBufferReference[]{byteBufferReference});
    }

    public HeaderFrame(int n, int n2, ByteBufferReference[] byteBufferReferenceArray) {
        super(n, n2);
        this.headerBlocks = byteBufferReferenceArray;
        this.headerLength = Utils.remaining(byteBufferReferenceArray);
    }

    @Override
    public String flagAsString(int n) {
        switch (n) {
            case 4: {
                return "END_HEADERS";
            }
            case 1: {
                return "END_STREAM";
            }
        }
        return super.flagAsString(n);
    }

    public ByteBufferReference[] getHeaderBlock() {
        return this.headerBlocks;
    }

    int getHeaderLength() {
        return this.headerLength;
    }

    public boolean endHeaders() {
        return this.getFlag(4);
    }
}

