/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.implementation.sun.javaee.glassfish;

import com.sun.ts.lib.deliverable.PropertyNotSetException;
import com.sun.ts.lib.implementation.sun.javaee.glassfish.AutoDeployment;
import com.sun.ts.lib.implementation.sun.javaee.glassfish.AutoDeploymentServerInterface;
import com.sun.ts.lib.porting.DeploymentInfo;
import com.sun.ts.lib.porting.TSDeploymentException;
import com.sun.ts.lib.util.TestUtil;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;

public class AutoDeploymentSeparateVM
extends AutoDeployment {
    private AutoDeploymentServerInterface deploymentServer = null;
    private Map extraParameters = new HashMap();

    private void getDeploymentServer() throws TSDeploymentException {
        String sHost = "";
        String sPort = "2002";
        try {
            sHost = InetAddress.getLocalHost().getHostName();
            try {
                sPort = this.propMgr.getProperty("harness.deployment.server.port");
                TestUtil.logHarnessDebug((String)("harness.deployment.server.port = " + sPort));
            }
            catch (PropertyNotSetException pe) {
                this.log.print(pe.getMessage());
                this.log.print("error looking up property:  sun.porting_server.port");
                this.log.print("Defaulting to port #:  " + sPort);
            }
            this.deploymentServer = (AutoDeploymentServerInterface)Naming.lookup("rmi://" + sHost + ":" + sPort + "/AutoDeploymentServer");
            this.extraParameters.put("porting_set", new Integer(this.iPortingSet));
            this.deploymentServer.init(this.propMgr.getJteProperties(), this.extraParameters);
        }
        catch (MalformedURLException me) {
            this.log.print(me.getMessage());
            me.printStackTrace();
            throw new TSDeploymentException(me.getMessage(), (Throwable)me);
        }
        catch (UnknownHostException ue) {
            this.log.print(ue.getMessage());
            this.log.print("unknown host:  " + sHost);
            ue.printStackTrace();
            throw new TSDeploymentException(ue.getMessage(), (Throwable)ue);
        }
        catch (NotBoundException nbe) {
            this.log.print(nbe.getMessage());
            nbe.printStackTrace();
            throw new TSDeploymentException(nbe.getMessage(), (Throwable)nbe);
        }
        catch (RemoteException e) {
            TestUtil.logHarness((String)("Failed to deploy using AutoDeploymentServer: " + e.getMessage()));
            e.printStackTrace();
            throw new TSDeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String deploy(DeploymentInfo info) throws TSDeploymentException {
        String classpath = null;
        try {
            if (this.deploymentServer == null) {
                this.getDeploymentServer();
            }
            classpath = this.deploymentServer.deploy(info);
        }
        catch (RemoteException e) {
            TestUtil.logHarness((String)("Failed to deploy using AutoDeploymentServer:  " + e.getMessage()));
            e.printStackTrace();
            throw new TSDeploymentException(e.getMessage());
        }
        return classpath;
    }
}

