/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile.f21;

import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.sigfile.Format;
import com.sun.tdk.signaturetest.sigfile.Parser;
import com.sun.tdk.signaturetest.sigfile.SignatureClassLoader;
import com.sun.tdk.signaturetest.sigfile.f31.F31Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class F21Reader
extends SignatureClassLoader {
    private static final Pattern constantDeclaration = Pattern.compile("<constant> <value=\".*\">");
    private static final Pattern valueDeclaration = Pattern.compile("\".*\"");
    private static final Pattern arrayDeclaration = Pattern.compile("\\[+[BCDFIJSZVL]");
    private static final Pattern constructorName = Pattern.compile("\\.\\w+\\(");
    private static final Pattern unicodeSim = Pattern.compile("\\\\u(?i)[\\da-f]{4}");

    F21Reader(Format format) {
        super(format);
    }

    @Override
    protected Parser getParser() {
        return new F31Parser();
    }

    @Override
    protected String convertClassDescr(String descr) {
        return descr;
    }

    @Override
    protected List<String> convertClassDefinitions(List<String> definitions) {
        ArrayList<String> newDef = new ArrayList<String>();
        for (String memberDef : definitions) {
            if ("supr null".equals(memberDef)) continue;
            memberDef = this.processConstants(memberDef);
            memberDef = this.processArrays(memberDef);
            memberDef = this.processConstructors(memberDef);
            newDef.add(memberDef);
        }
        return newDef;
    }

    private String processConstructors(String memberDef) {
        Matcher m;
        if (memberDef.startsWith("cons ") && (m = constructorName.matcher(memberDef)).find()) {
            memberDef = m.replaceFirst("(");
        }
        return memberDef;
    }

    private String processArrays(String memberDef) {
        Matcher m = arrayDeclaration.matcher(memberDef);
        while (m.find()) {
            int stPos = m.start();
            int eqPos = memberDef.indexOf(" = ");
            if (eqPos > -1 && stPos > eqPos) break;
            int endPos = stPos;
            int tmp = memberDef.indexOf(32, stPos);
            if (tmp >= 0) {
                endPos = tmp;
            }
            if ((tmp = memberDef.indexOf(44, stPos)) >= 0 && (tmp < endPos || endPos == stPos)) {
                endPos = tmp;
            }
            if ((tmp = memberDef.indexOf(41, stPos)) >= 0 && (tmp < endPos || endPos == stPos)) {
                endPos = tmp;
            }
            if ((tmp = memberDef.indexOf(59, stPos)) >= 0 && (tmp < endPos || endPos == stPos)) {
                endPos = tmp + 1;
            }
            String p1 = memberDef.substring(0, stPos);
            String p4 = memberDef.substring(stPos, endPos);
            String p2 = MemberDescription.getTypeName(p4.replace('/', '.'));
            String p3 = memberDef.substring(endPos);
            memberDef = p1 + p2 + p3;
            m = arrayDeclaration.matcher(memberDef);
        }
        return memberDef;
    }

    private String processConstants(String memberDef) throws NumberFormatException {
        Matcher m = constantDeclaration.matcher(memberDef);
        if (m.find()) {
            String constDef = memberDef.substring(m.start(), m.end());
            memberDef = m.replaceFirst("");
            Matcher v = valueDeclaration.matcher(constDef);
            if (v.find()) {
                String value = constDef.substring(v.start() + 1, v.end() - 1);
                int end = memberDef.lastIndexOf(32);
                int start = memberDef.lastIndexOf(32, end - 1);
                String type = memberDef.substring(++start, end);
                Object oVal = null;
                switch (type) {
                    case "java.lang.String": {
                        Matcher uc = unicodeSim.matcher(value);
                        while (uc.find()) {
                            String uValue = value.substring(uc.start() + 2, uc.end());
                            char ch = (char)Integer.parseInt(uValue, 16);
                            String repl = "" + ch;
                            if (ch == '\\' || ch == '$') {
                                repl = "\\" + ch;
                            }
                            value = uc.replaceFirst(repl);
                            uc = unicodeSim.matcher(value);
                        }
                        oVal = value;
                        break;
                    }
                    case "boolean": {
                        if ("0".equals(value)) {
                            oVal = Boolean.FALSE;
                            break;
                        }
                        oVal = Boolean.TRUE;
                        break;
                    }
                    case "int": {
                        oVal = new Integer(value);
                        break;
                    }
                    case "long": {
                        oVal = new Long(value);
                        break;
                    }
                    case "char": {
                        oVal = Character.valueOf((char)Integer.parseInt(value));
                        break;
                    }
                    case "byte": {
                        oVal = new Byte(value);
                        break;
                    }
                    case "double": {
                        oVal = new Double(value);
                        break;
                    }
                    case "float": {
                        oVal = new Float(value);
                    }
                }
                if (oVal != null) {
                    value = MemberDescription.valueToString(oVal);
                }
                memberDef = memberDef + " = " + value;
            }
        }
        return memberDef;
    }
}

