/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.PseudoPublisher;
import jdk.incubator.http.PullPublisher;
import jdk.incubator.http.internal.common.Utils;

class RequestProcessors {
    RequestProcessors() {
    }

    static class InputStreamProcessor
    implements HttpRequest.BodyProcessor {
        private final Supplier<? extends InputStream> streamSupplier;
        private Flow.Publisher<ByteBuffer> delegate;

        InputStreamProcessor(Supplier<? extends InputStream> supplier) {
            this.streamSupplier = supplier;
        }

        @Override
        public synchronized void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
            InputStream inputStream = this.streamSupplier.get();
            if (inputStream == null) {
                throw new UncheckedIOException(new IOException("no inputstream supplied"));
            }
            this.delegate = new PullPublisher<ByteBuffer>(() -> new StreamIterator(inputStream));
            this.delegate.subscribe(subscriber);
        }

        @Override
        public long contentLength() {
            return -1L;
        }
    }

    static class StreamIterator
    implements Iterator<ByteBuffer> {
        final InputStream is;
        ByteBuffer nextBuffer;
        boolean need2Read = true;
        boolean haveNext;
        Throwable error;

        StreamIterator(InputStream inputStream) {
            this.is = inputStream;
        }

        Throwable error() {
            return this.error;
        }

        private int read() {
            this.nextBuffer = Utils.getBuffer();
            this.nextBuffer.clear();
            byte[] byArray = this.nextBuffer.array();
            int n = this.nextBuffer.arrayOffset();
            int n2 = this.nextBuffer.capacity();
            try {
                int n3 = this.is.read(byArray, n, n2);
                if (n3 == -1) {
                    this.is.close();
                    return -1;
                }
                this.nextBuffer.limit(n3);
                this.nextBuffer.position(0);
                return n3;
            }
            catch (IOException iOException) {
                this.error = iOException;
                return -1;
            }
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.need2Read) {
                boolean bl = this.haveNext = this.read() != -1;
                if (this.haveNext) {
                    this.need2Read = false;
                }
                return this.haveNext;
            }
            return this.haveNext;
        }

        @Override
        public synchronized ByteBuffer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.need2Read = true;
            return this.nextBuffer;
        }
    }

    static class FileProcessor
    extends InputStreamProcessor
    implements HttpRequest.BodyProcessor {
        File file;

        FileProcessor(Path path) {
            super(() -> FileProcessor.create(path));
            this.file = path.toFile();
        }

        static FileInputStream create(Path path) {
            try {
                return new FileInputStream(path.toFile());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new UncheckedIOException(fileNotFoundException);
            }
        }

        @Override
        public long contentLength() {
            return this.file.length();
        }
    }

    static class EmptyProcessor
    implements HttpRequest.BodyProcessor {
        PseudoPublisher<ByteBuffer> delegate = new PseudoPublisher();

        EmptyProcessor() {
        }

        @Override
        public long contentLength() {
            return 0L;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
            this.delegate.subscribe(subscriber);
        }
    }

    static class StringProcessor
    extends ByteArrayProcessor {
        public StringProcessor(String string, Charset charset) {
            super(string.getBytes(charset));
        }
    }

    static class IterableProcessor
    implements HttpRequest.BodyProcessor {
        private volatile Flow.Publisher<ByteBuffer> delegate;
        private final Iterable<byte[]> content;
        private volatile long contentLength;

        IterableProcessor(Iterable<byte[]> iterable) {
            this.content = iterable;
        }

        public Iterator<ByteBuffer> iterator() {
            return new ByteBufferIterator();
        }

        @Override
        public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
            Iterable iterable = this::iterator;
            this.delegate = new PullPublisher<ByteBuffer>(iterable);
            this.delegate.subscribe(subscriber);
        }

        static long computeLength(Iterable<byte[]> iterable) {
            long l = 0L;
            for (byte[] byArray : iterable) {
                l = Math.addExact(l, (long)byArray.length);
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long contentLength() {
            if (this.contentLength == 0L) {
                IterableProcessor iterableProcessor = this;
                synchronized (iterableProcessor) {
                    if (this.contentLength == 0L) {
                        this.contentLength = IterableProcessor.computeLength(this.content);
                    }
                }
            }
            return this.contentLength;
        }

        static /* synthetic */ Iterable access$000(IterableProcessor iterableProcessor) {
            return iterableProcessor.content;
        }

        class ByteBufferIterator
        implements Iterator<ByteBuffer> {
            final ConcurrentLinkedQueue<ByteBuffer> buffers = new ConcurrentLinkedQueue();
            final Iterator<byte[]> iterator = IterableProcessor.access$000(IterableProcessor.this).iterator();

            ByteBufferIterator() {
            }

            @Override
            public boolean hasNext() {
                return !this.buffers.isEmpty() || this.iterator.hasNext();
            }

            @Override
            public ByteBuffer next() {
                ByteBuffer byteBuffer = this.buffers.poll();
                while (byteBuffer == null) {
                    this.copy();
                    byteBuffer = this.buffers.poll();
                }
                return byteBuffer;
            }

            ByteBuffer getBuffer() {
                return Utils.getBuffer();
            }

            void copy() {
                int n;
                byte[] byArray = this.iterator.next();
                int n2 = byArray.length;
                if (n2 == 0 && this.iterator.hasNext()) {
                    return;
                }
                int n3 = 0;
                do {
                    ByteBuffer byteBuffer = this.getBuffer();
                    int n4 = byteBuffer.capacity();
                    n = Math.min(n4, n2);
                    byteBuffer.put(byArray, n3, n);
                    n3 += n;
                    byteBuffer.flip();
                    this.buffers.add(byteBuffer);
                } while ((n2 -= n) > 0);
            }
        }
    }

    static class ByteArrayProcessor
    implements HttpRequest.BodyProcessor {
        private volatile Flow.Publisher<ByteBuffer> delegate;
        private final int length;
        private final byte[] content;
        private final int offset;

        ByteArrayProcessor(byte[] byArray) {
            this(byArray, 0, byArray.length);
        }

        ByteArrayProcessor(byte[] byArray, int n, int n2) {
            this.content = byArray;
            this.offset = n;
            this.length = n2;
        }

        List<ByteBuffer> copy(byte[] byArray, int n, int n2) {
            ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
            while (n2 > 0) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(Math.min(Utils.BUFSIZE, n2));
                int n3 = byteBuffer.capacity();
                int n4 = Math.min(n3, n2);
                byteBuffer.put(byArray, n, n4);
                n += n4;
                n2 -= n4;
                byteBuffer.flip();
                arrayList.add(byteBuffer);
            }
            return arrayList;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
            List<ByteBuffer> list = this.copy(this.content, this.offset, this.length);
            this.delegate = new PullPublisher<ByteBuffer>(list);
            this.delegate.subscribe(subscriber);
        }

        @Override
        public long contentLength() {
            return this.length;
        }
    }
}

