/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.unsignedbyte.maxexclusive.maxexclusive_4;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class maxExclusive4_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        maxExclusive4_ValidateCTTests test = new maxExclusive4_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final short[] validValues = {(short)11, (short)5, (short)0};
    final short[] invalidValues = {(short)12, (short)255, (short)400, (short)-1, (short)-400};
    
    JAXBElement<Short> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "maxExclusive-4-1.xml";
        elemObj = (JAXBElement<Short>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate002( ) {
        String xmlDocName = "maxExclusive-4-1.xml";
        elemObj = (JAXBElement<Short>)unmarshal(xmlDocName);
        return testInvalid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<Short>)(new ObjectFactory()).createNISTSchemaUnsignedByteMaxExclusive4((short)9);
        
        return testValid();
    }

    public Status Validate004( ) {
        elemObj = (JAXBElement<Short>)(new ObjectFactory()).createNISTSchemaUnsignedByteMaxExclusive4((short)9);
        
        return testInvalid();
    }


}

