/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.bind.util.enumeration_1_source;

import jakarta.xml.bind.util.JAXBSource;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.Marshaller;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class CtorGetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        CtorGetCTTests test = new CtorGetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status CtorGet001( ) {
        JAXBContext jc = null;
         Object obj = null;

         obj = unmarshal("enumeration-1-source.xml");
         try {
             jc = getJAXBContext();
         } catch (JAXBException je){
             return Status.failed("Unable to create JAXBContext");
         }
         try {
             new JAXBSource(jc, obj);
         } catch (JAXBException je){
             return Status.failed("new JAXBSource(context, obj) with valid arguments throws JAXBException");
         }
         return Status.passed("OKAY");
    }

    public Status CtorGet002( ) {
        JAXBContext jc = null;
         Marshaller m = null;
         Object obj = null;

         obj = unmarshal("enumeration-1-source.xml");
         try {
             jc = getJAXBContext();
              m = jc.createMarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or marshaler object");
         }
         try {
             new JAXBSource(m, obj);
         } catch (JAXBException je){
             return Status.failed("new JAXBSource(marshaler, obj) with valid arguments throws JAXBException");
         }
         return Status.passed("OKAY");
    }

    public Status CtorGet003( ) {
        JAXBContext jc = null;
         Unmarshaller um = null;
         JAXBSource src = null;
         Object obj = null;
         Object objRes = null;

         obj = unmarshal("enumeration-1-source.xml");
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaler object");
         }
         try {
             src = new JAXBSource(jc, obj);
         } catch (JAXBException je){
             return Status.failed("new JAXBSource(context, obj) with valid arguments throws JAXBException");
         }
         try {
             objRes = um.unmarshal(src);
         } catch (JAXBException je){
             return Status.failed("JAXBException: unable to unmarshal from valid JAXBSource");
         }
         if (!((JAXBElement<Long>)obj).getValue().equals(((JAXBElement<Long>)objRes).getValue())){
             return Status.failed("transformation result object is not equivalent to the original");
         }
         return Status.passed("OKAY");
    }

    public Status CtorGet004( ) {
        JAXBContext jc = null;
         Unmarshaller um = null;
         Marshaller m = null;
         JAXBSource src = null;
         Object obj = null;
         Object objRes = null;

         obj = unmarshal("enumeration-1-source.xml");
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
              m = jc.createMarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or marshaler or unmarshaller object");
         }
         try {
             src = new JAXBSource(m, obj);
         } catch (JAXBException je){
             return Status.failed("new JAXBSource(marshaler, obj) with valid arguments throws JAXBException");
         }
         try {
             objRes = um.unmarshal(src);
         } catch (JAXBException je){
             return Status.failed("JAXBException: unable to unmarshal from valid JAXBSource");
         }
         if (!((JAXBElement<Long>)obj).getValue().equals(((JAXBElement<Long>)objRes).getValue())){
             return Status.failed("transformation result object is not equivalent to the original");
         }
         return Status.passed("OKAY");
    }

    public Status CtorGet005( ) {
        try {
            new JAXBSource((JAXBContext)null, unmarshal("enumeration-1-source.xml"));
        } catch (JAXBException je){
            return Status.passed("OKAY");
        }
        return Status.failed("expected JAXBException was not thrown");
    }

    public Status CtorGet006( ) {
        try {
            JAXBContext jc = getJAXBContext();
            try {
                new JAXBSource(jc, null);
            } catch (JAXBException je){
                return Status.passed("OKAY");
            }
        } catch (JAXBException je){
            return Status.failed("Unable to create JAXBContext");
        }
        return Status.failed("expected JAXBException was not thrown");
    }

    public Status CtorGet007( ) {
        try {
            new JAXBSource((JAXBContext)null, null);
        } catch (JAXBException je){
            return Status.passed("OKAY");
        }
        return Status.failed("expected JAXBException was not thrown");
    }

    public Status CtorGet005a( ) {
        try {
            new JAXBSource((Marshaller)null, unmarshal("enumeration-1-source.xml"));
        } catch (JAXBException je){
            return Status.passed("OKAY");
        }
        return Status.failed("expected JAXBException was not thrown");
    }

    public Status CtorGet006a( ) {
        try {
            Marshaller mrsh = getJAXBContext().createMarshaller();
            try {
                new JAXBSource(mrsh, null);
            } catch (JAXBException je){
                return Status.passed("OKAY");
            }
        } catch (JAXBException je){
            return Status.failed("Unable to create valid context or marshaler object");
        }
        return Status.failed("expected JAXBException was not thrown");
    }

    public Status CtorGet007a( ) {
        try {
            new JAXBSource((Marshaller)null, null);
        } catch (JAXBException je){
            return Status.passed("OKAY");
        }
        return Status.failed("expected JAXBException was not thrown");
    }


}

