/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._byte.enumeration.enumeration_1;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class enumeration1_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        enumeration1_ValidateCTTests test = new enumeration1_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final byte[] validValues = {(byte)86, (byte)-128, (byte)4, (byte)127, (byte)-8, (byte)-33, 
                                 (byte)-7, (byte)86, (byte)7, (byte)7, (byte)-7, (byte)-19};
    final byte[] invalidValues = {(byte)-127, (byte)-86, (byte)85, (byte)87, (byte)5, (byte)-6, 
                                  (byte)0, (byte)19, (byte)-20, (byte)126};
    
    JAXBElement<Byte> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "enumeration-1-1.xml";
        elemObj = (JAXBElement<Byte>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate002( ) {
        String xmlDocName = "enumeration-1-1.xml";
        elemObj = (JAXBElement<Byte>)unmarshal(xmlDocName);
        return testInvalid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<Byte>)(new ObjectFactory()).createNISTSchemaByteEnumeration1((byte)-33);
        
        return testValid();
    }

    public Status Validate004( ) {
        elemObj = (JAXBElement<Byte>)(new ObjectFactory()).createNISTSchemaByteEnumeration1((byte)-33);
        
        return testInvalid();
    }


}

