/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */


/*
 *  @(#)JAXBElement.test.xml	1.3 07/03/21 Igor Tseytin
 * Generated from : api/jakarta_xml/bind/JAXBElement/JAXBElement.test.xml
 *
 * Provides JAXBElement implementation tests
 */

package javasoft.sqe.tests.api.jakarta.xml.bind.JAXBElement;

import jakarta.xml.bind.JAXBElement;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiTest;
import javax.xml.namespace.QName;


public class JAXBElementTests extends MultiTest {

    QName name = new QName("LocalPart");

    void assertT( boolean val, String msg ){
        if( !val )
            throw new RuntimeException(msg);
    }

    /* standalone interface */
    public static void main(String argv[]) {
        JAXBElementTests test = new JAXBElementTests();
        test.run(argv, System.err, System.out).exit();
    }

    /**
     * Functional tests for JAXBElement,
     * Construct an xml element instance..
     */
    public Status Ctor001() {
        try {
            {
                JAXBElement<Long> e = new JAXBElement<Long>(name, Long.class, null, 5L);
                assertT( name.equals( e.getName() ), "names are not equal" );
                assertT( Long.class == e.getDeclaredType(), "declaredTypes are not equal" );
                assertT( JAXBElement.GlobalScope.class == e.getScope(), "scopes are not equal" );
                assertT( e.getValue().equals( 5L ), "values are not equal" );
                assertT( e.isGlobalScope(), "scope isn't global" );
                assertT( !e.isNil(), "value is nil" );
            }
            {
                JAXBElement<String> e = new JAXBElement<String>(name, String.class, JAXBElement.GlobalScope.class, "5");
                assertT( name.equals( e.getName() ), "names are not equal" );
                assertT( String.class == e.getDeclaredType(), "declaredTypes are not equal" );
                assertT( JAXBElement.GlobalScope.class == e.getScope(), "scopes are not equal" );
                assertT( "5".equals( e.getValue() ), "values are not equal" );
                assertT( e.isGlobalScope(), "scope isn't global" );
                assertT( !e.isNil(), "value is nil" );
            }
            {
                JAXBElement<Integer> e = new JAXBElement<Integer>(name, Integer.class, 5);
                assertT( name.equals( e.getName() ), "names are not equal" );
                assertT( Integer.class == e.getDeclaredType(), "declaredTypes are not equal" );
                assertT( JAXBElement.GlobalScope.class == e.getScope(), "scopes are not equal" );
                assertT( e.getValue().equals( 5 ), "values are not equal" );
                assertT( e.isGlobalScope(), "scope isn't global" );
                assertT( !e.isNil(), "value is nil" );
            }
        } catch( Exception x ){
            x.printStackTrace(ref);
            return Status.failed( x.toString() );
        }
        return Status.passed("Ok");
        }

    /**
     * Functional tests for JAXBElement,
     * Set whether this element has nil content..
     */
    public Status setNil001() {
        try {
            JAXBElement<Long> e = new JAXBElement<Long>(name, Long.class, null, 5L);
            assertT( !e.isNil(), "value is nil" );
            e.setNil(true);
            assertT( e.isNil(), "value isn't nil" );
            e.setNil(false);
            assertT( !e.isNil(), "value is nil" );
        } catch( Exception x ){
            x.printStackTrace(ref);
            return Status.failed( x.toString() );
        }
        return Status.passed("Ok");
        }

    /**
     * Functional tests for JAXBElement,
     * Set the content model and attributes of this xml element. When this property is set to null, isNil() must by true..
     */
    public Status setValue001() {
        try {
            JAXBElement<Long> e = new JAXBElement<Long>(name, Long.class, null, 5L);
            assertT( e.getValue().equals( 5L ), "values are not equal 1" );
            e.setValue( 6L );
            assertT( e.getValue().equals( 6L ), "values are not equal 2" );
            e.setValue( null );
            assertT( e.isNil(), "value isn't nil" );
        } catch( Exception x ){
            x.printStackTrace(ref);
            return Status.failed( x.toString() );
        }
        return Status.passed("Ok");
        }
}
