/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.se.cache.inherit;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.se.cache.inherit.HardwareProduct;
import com.sun.ts.tests.jpa.se.cache.inherit.HardwareProduct2;
import com.sun.ts.tests.jpa.se.cache.inherit.Product;
import com.sun.ts.tests.jpa.se.cache.inherit.Product2;
import com.sun.ts.tests.jpa.se.cache.inherit.SoftwareProduct;
import com.sun.ts.tests.jpa.se.cache.inherit.SoftwareProduct2;
import jakarta.persistence.Cache;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", (Throwable)e);
        }
    }

    public void subClassInheritsCacheableTrue() throws EETest.Fault {
        boolean pass3;
        boolean pass2;
        boolean pass1;
        block12: {
            pass1 = false;
            pass2 = false;
            pass3 = false;
            if (this.cachingSupported) {
                try {
                    EntityManager em2 = this.getEntityManager();
                    EntityTransaction et = this.getEntityTransaction();
                    et.begin();
                    Product product = new Product("1", 101);
                    em2.persist((Object)product);
                    TestUtil.logTrace((String)("persisted Product " + product));
                    SoftwareProduct sp = new SoftwareProduct();
                    sp.setId("2");
                    sp.setRevisionNumber(1.0);
                    sp.setQuantity(202);
                    em2.persist((Object)sp);
                    TestUtil.logTrace((String)("persisted SoftwareProduct " + sp));
                    HardwareProduct hp = new HardwareProduct();
                    hp.setId("3");
                    hp.setModelNumber(3);
                    hp.setQuantity(303);
                    em2.persist((Object)hp);
                    TestUtil.logTrace((String)("persisted HardwareProduct " + hp));
                    em2.flush();
                    et.commit();
                    EntityManagerFactory emf = this.getEntityManagerFactory();
                    Cache cache = emf.getCache();
                    if (cache != null) {
                        boolean b1 = cache.contains(Product.class, (Object)"1");
                        if (b1) {
                            TestUtil.logTrace((String)("Cache returned: " + b1 + ", therefore cache does contain Product " + product));
                            pass1 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b1 + ", therefore cache does not contain Product " + product));
                        }
                        boolean b2 = cache.contains(SoftwareProduct.class, (Object)"2");
                        if (!b2) {
                            TestUtil.logTrace((String)("Cache returned: " + b2 + ", therefore cache does not contain SoftwareProduct " + sp));
                            pass2 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b2 + ", therefore cache does contain SoftwareProduct " + sp));
                        }
                        boolean b3 = cache.contains(HardwareProduct.class, (Object)"3");
                        if (b3) {
                            TestUtil.logTrace((String)("Cache returned: " + b3 + ", therefore cache does contain HardwareProduct " + hp));
                            pass3 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b3 + ", therefore cache does not contain HardwareProduct " + hp));
                        }
                        break block12;
                    }
                    TestUtil.logErr((String)"Cache returned was null");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
                pass3 = true;
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("subClassInheritsCacheableTrue failed");
        }
    }

    public void subClassInheritsCacheableFalse() throws EETest.Fault {
        boolean pass3;
        boolean pass2;
        boolean pass1;
        block12: {
            pass1 = false;
            pass2 = false;
            pass3 = false;
            if (this.cachingSupported) {
                try {
                    EntityManager em2 = this.getEntityManager();
                    EntityTransaction et = this.getEntityTransaction();
                    et.begin();
                    Product2 product = new Product2("1", 101);
                    em2.persist((Object)product);
                    TestUtil.logTrace((String)("persisted Product2 " + product));
                    SoftwareProduct2 sp = new SoftwareProduct2();
                    sp.setId("2");
                    sp.setRevisionNumber(1.0);
                    sp.setQuantity(202);
                    em2.persist((Object)sp);
                    TestUtil.logTrace((String)("persisted SoftwareProduct2 " + sp));
                    HardwareProduct2 hp = new HardwareProduct2();
                    hp.setId("3");
                    hp.setModelNumber(3);
                    hp.setQuantity(303);
                    em2.persist((Object)hp);
                    TestUtil.logTrace((String)("persisted HardwareProduct2 " + hp));
                    em2.flush();
                    et.commit();
                    EntityManagerFactory emf = this.getEntityManagerFactory();
                    Cache cache = emf.getCache();
                    if (cache != null) {
                        boolean b1 = cache.contains(Product2.class, (Object)"1");
                        if (!b1) {
                            TestUtil.logTrace((String)("Cache returned: " + b1 + ", therefore cache does not contain Product2 " + product));
                            pass1 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b1 + ", therefore cache does contain Product2 " + product));
                        }
                        boolean b2 = cache.contains(SoftwareProduct2.class, (Object)"2");
                        if (b2) {
                            TestUtil.logTrace((String)("Cache returned: " + b2 + ", therefore cache does contain SoftwareProduct2 " + sp));
                            pass2 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b2 + ", therefore cache does not contain SoftwareProduct2 " + sp));
                        }
                        boolean b3 = cache.contains(HardwareProduct2.class, (Object)"3");
                        if (!b3) {
                            TestUtil.logTrace((String)("Cache returned: " + b3 + ", therefore cache does not contain HardwareProduct2 " + hp));
                            pass3 = true;
                        } else {
                            TestUtil.logErr((String)("Cache returned: " + b3 + ", therefore cache does  contain HardwareProduct2 " + hp));
                        }
                        break block12;
                    }
                    TestUtil.logErr((String)"Cache returned was null");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
                pass3 = true;
            }
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("subClassInheritsCacheableFalse failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_DETAILS").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PRODUCT_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

