/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import jdk.incubator.http.AsyncConnection;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.internal.common.AsyncWriteQueue;
import jdk.incubator.http.internal.common.ByteBufferPool;
import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.common.ExceptionallyCloseable;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.Queue;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.common.Utils8;

class AsyncSSLDelegate
implements ExceptionallyCloseable,
AsyncConnection {
    final AsyncWriteQueue appOutputQ = new AsyncWriteQueue(this::upperWrite);
    final Queue<ByteBufferReference> channelInputQ;
    final SSLEngine engine;
    final SSLParameters sslParameters;
    final HttpConnection lowerOutput;
    final HttpClientImpl client;
    final String serverName;
    volatile Consumer<ByteBufferReference> asyncReceiver;
    volatile Consumer<Throwable> errorHandler;
    volatile boolean connected = false;
    final Object reader = new Object();
    final Semaphore handshaker = new Semaphore(1);
    final String[] alpn;
    private final ByteBufferPool netBufferPool = new ByteBufferPool();
    private final ByteBufferPool appBufferPool = new ByteBufferPool();

    AsyncSSLDelegate(HttpConnection httpConnection, HttpClientImpl httpClientImpl, String[] stringArray, String string) {
        SSLContext sSLContext = httpClientImpl.sslContext();
        this.serverName = string;
        this.engine = sSLContext.createSSLEngine();
        this.engine.setUseClientMode(true);
        SSLParameters sSLParameters = httpClientImpl.sslParameters().orElseGet(sSLContext::getSupportedSSLParameters);
        this.sslParameters = Utils.copySSLParameters(sSLParameters);
        if (stringArray != null) {
            Log.logSSL("AsyncSSLDelegate: Setting application protocols: " + Arrays.toString(stringArray), new Object[0]);
        } else {
            Log.logSSL("AsyncSSLDelegate: no applications set!", new Object[0]);
        }
        if (this.serverName != null) {
            SNIHostName sNIHostName = new SNIHostName(this.serverName);
            this.sslParameters.setServerNames(Utils8.listOf(sNIHostName));
        }
        AsyncSSLDelegate.logParams(this.sslParameters);
        this.engine.setSSLParameters(this.sslParameters);
        this.lowerOutput = httpConnection;
        this.client = httpClientImpl;
        this.channelInputQ = new Queue();
        this.channelInputQ.registerPutCallback(this::upperRead);
        this.alpn = stringArray;
    }

    @Override
    public void writeAsync(ByteBufferReference[] byteBufferReferenceArray) throws IOException {
        this.appOutputQ.put(byteBufferReferenceArray);
    }

    @Override
    public void writeAsyncUnordered(ByteBufferReference[] byteBufferReferenceArray) throws IOException {
        this.appOutputQ.putFirst(byteBufferReferenceArray);
    }

    @Override
    public void flushAsync() throws IOException {
        if (this.appOutputQ.flush()) {
            this.lowerOutput.flushAsync();
        }
    }

    SSLEngine getEngine() {
        return this.engine;
    }

    @Override
    public void closeExceptionally(Throwable throwable) {
        Utils.close(throwable, this.appOutputQ, this.channelInputQ, this.lowerOutput);
    }

    @Override
    public void close() {
        Utils.close(this.appOutputQ, this.channelInputQ, this.lowerOutput);
    }

    private void upperWrite(ByteBufferReference[] byteBufferReferenceArray, AsyncWriteQueue asyncWriteQueue) {
        try {
            ByteBuffer[] byteBufferArray = ByteBufferReference.toBuffers(byteBufferReferenceArray);
            int n = Utils.remaining(byteBufferArray);
            while (n > 0) {
                EngineResult engineResult = this.wrapBuffers(byteBufferArray);
                int n2 = engineResult.bytesProduced();
                int n3 = engineResult.bytesConsumed();
                n -= n3;
                if (n2 > 0) {
                    this.lowerOutput.writeAsync(new ByteBufferReference[]{engineResult.destBuffer});
                }
                if (!engineResult.handshaking()) continue;
                Log.logTrace("Write: needs handshake", new Object[0]);
                this.doHandshakeNow("Write");
            }
            ByteBufferReference.clear(byteBufferReferenceArray);
        }
        catch (Throwable throwable) {
            this.closeExceptionally(throwable);
            this.errorHandler.accept(throwable);
        }
    }

    void connect() throws IOException, InterruptedException {
        this.doHandshakeNow("Init");
        this.connected = true;
    }

    boolean connected() {
        return this.connected;
    }

    private void startHandshake(String string) {
        Runnable runnable = () -> {
            try {
                this.doHandshakeNow(string);
            }
            catch (Throwable throwable) {
                Log.logTrace("{0}: handshake failed: {1}", string, throwable);
                this.closeExceptionally(throwable);
                this.errorHandler.accept(throwable);
            }
        };
        this.client.executor().execute(runnable);
    }

    private void doHandshakeNow(String string) throws IOException, InterruptedException {
        this.handshaker.acquire();
        try {
            this.channelInputQ.disableCallback();
            this.lowerOutput.flushAsync();
            Log.logTrace("{0}: Starting handshake...", string);
            this.doHandshakeImpl();
            Log.logTrace("{0}: Handshake completed", string);
        }
        finally {
            this.handshaker.release();
        }
    }

    @Override
    public void enableCallback() {
        this.channelInputQ.enableCallback();
    }

    private void doHandshakeImpl() throws IOException {
        this.engine.beginHandshake();
        block7: while (true) {
            SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
            switch (handshakeStatus) {
                case NEED_TASK: {
                    List<Runnable> list = this.obtainTasks();
                    Iterator<Runnable> iterator = list.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block7;
                        Runnable runnable = iterator.next();
                        runnable.run();
                    }
                }
                case NEED_WRAP: {
                    this.handshakeWrapAndSend();
                    break;
                }
                case NEED_UNWRAP: {
                    this.handshakeReceiveAndUnWrap();
                    break;
                }
                case FINISHED: {
                    return;
                }
                case NOT_HANDSHAKING: {
                    return;
                }
                default: {
                    throw new InternalError("Unexpected Handshake Status: " + (Object)((Object)handshakeStatus));
                }
            }
        }
    }

    void doClosure() throws IOException {
    }

    List<Runnable> obtainTasks() {
        Runnable runnable;
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
        while ((runnable = this.engine.getDelegatedTask()) != null) {
            arrayList.add(runnable);
        }
        return arrayList;
    }

    @Override
    public void setAsyncCallbacks(Consumer<ByteBufferReference> consumer, Consumer<Throwable> consumer2, Supplier<ByteBufferReference> supplier) {
        this.asyncReceiver = consumer;
        this.errorHandler = consumer2;
    }

    @Override
    public void startReading() {
    }

    @Override
    public void stopAsyncReading() {
    }

    EngineResult handshakeWrapAndSend() throws IOException {
        EngineResult engineResult = this.wrapBuffer(Utils.EMPTY_BYTEBUFFER);
        if (engineResult.bytesProduced() > 0) {
            this.lowerOutput.writeAsync(new ByteBufferReference[]{engineResult.destBuffer});
            this.lowerOutput.flushAsync();
        }
        return engineResult;
    }

    void handshakeReceiveAndUnWrap() throws IOException {
        ByteBufferReference byteBufferReference = this.channelInputQ.take();
        while (true) {
            EngineResult engineResult;
            SSLEngineResult.Status status;
            if ((status = (engineResult = this.unwrapBuffer(byteBufferReference.get())).status()) == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                ByteBufferReference byteBufferReference2 = this.channelInputQ.take();
                byteBufferReference = this.combine(byteBufferReference, byteBufferReference2);
                continue;
            }
            if (engineResult.bytesProduced() > 0) {
                this.asyncReceiver.accept(engineResult.destBuffer);
            } else {
                engineResult.destBuffer.clear();
            }
            if (engineResult.handshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.obtainTasks().stream().forEach(runnable -> runnable.run());
            }
            if (!byteBufferReference.get().hasRemaining()) break;
        }
        byteBufferReference.clear();
    }

    EngineResult wrapBuffer(ByteBuffer byteBuffer) throws SSLException {
        ByteBuffer[] byteBufferArray = new ByteBuffer[]{byteBuffer};
        return this.wrapBuffers(byteBufferArray);
    }

    public ByteBufferReference getNetBuffer() {
        return this.netBufferPool.get(this.engine.getSession().getPacketBufferSize());
    }

    private ByteBufferReference getAppBuffer() {
        return this.appBufferPool.get(this.engine.getSession().getApplicationBufferSize());
    }

    EngineResult wrapBuffers(ByteBuffer[] byteBufferArray) throws SSLException {
        ByteBufferReference byteBufferReference = this.getNetBuffer();
        block5: while (true) {
            SSLEngineResult sSLEngineResult = this.engine.wrap(byteBufferArray, byteBufferReference.get());
            switch (sSLEngineResult.getStatus()) {
                case BUFFER_OVERFLOW: {
                    byteBufferReference = this.getNetBuffer();
                    continue block5;
                }
                case CLOSED: 
                case OK: {
                    byteBufferReference.get().flip();
                    return new EngineResult(sSLEngineResult, byteBufferReference);
                }
                case BUFFER_UNDERFLOW: {
                    return new EngineResult(sSLEngineResult);
                }
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError();
    }

    EngineResult unwrapBuffer(ByteBuffer byteBuffer) throws IOException {
        ByteBufferReference byteBufferReference = this.getAppBuffer();
        while (true) {
            SSLEngineResult sSLEngineResult = this.engine.unwrap(byteBuffer, byteBufferReference.get());
            switch (sSLEngineResult.getStatus()) {
                case BUFFER_OVERFLOW: {
                    byteBufferReference = this.getAppBuffer();
                    break;
                }
                case CLOSED: {
                    this.doClosure();
                    throw new IOException("Engine closed");
                }
                case BUFFER_UNDERFLOW: {
                    byteBufferReference.clear();
                    return new EngineResult(sSLEngineResult);
                }
                case OK: {
                    byteBufferReference.get().flip();
                    return new EngineResult(sSLEngineResult, byteBufferReference);
                }
            }
        }
    }

    public void asyncReceive(ByteBufferReference byteBufferReference) {
        try {
            this.channelInputQ.put(byteBufferReference);
        }
        catch (Throwable throwable) {
            this.closeExceptionally(throwable);
            this.errorHandler.accept(throwable);
        }
    }

    private ByteBufferReference pollInput() throws IOException {
        return this.channelInputQ.poll();
    }

    private ByteBufferReference pollInput(ByteBufferReference byteBufferReference) throws IOException {
        return byteBufferReference == null ? this.channelInputQ.poll() : byteBufferReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upperRead() {
        ByteBufferReference byteBufferReference = null;
        Object object = this.reader;
        synchronized (object) {
            try {
                ByteBufferReference byteBufferReference2 = this.pollInput();
                if (byteBufferReference2 == null) {
                    return;
                }
                while (true) {
                    EngineResult engineResult = this.unwrapBuffer(byteBufferReference2.get());
                    switch (engineResult.result.getStatus()) {
                        case BUFFER_UNDERFLOW: {
                            byteBufferReference = this.pollInput(byteBufferReference);
                            if (byteBufferReference == null) {
                                this.channelInputQ.pushback(byteBufferReference2);
                                return;
                            }
                            byteBufferReference2 = this.shift(byteBufferReference2, byteBufferReference);
                            if (byteBufferReference.get().hasRemaining()) break;
                            byteBufferReference.clear();
                            byteBufferReference = null;
                            break;
                        }
                        case OK: {
                            if (engineResult.handshaking()) {
                                Log.logTrace("Read: needs handshake", new Object[0]);
                                this.channelInputQ.pushback(byteBufferReference2);
                                this.startHandshake("Read");
                                return;
                            }
                            this.asyncReceiver.accept(engineResult.destBuffer);
                        }
                    }
                    if (byteBufferReference2.get().hasRemaining()) continue;
                    byteBufferReference2.clear();
                    byteBufferReference2 = this.pollInput(byteBufferReference);
                    byteBufferReference = null;
                    if (byteBufferReference2 == null) break;
                }
                return;
            }
            catch (Throwable throwable) {
                this.closeExceptionally(throwable);
                this.errorHandler.accept(throwable);
            }
        }
    }

    ByteBufferReference shift(ByteBufferReference object, ByteBufferReference byteBufferReference) {
        Object object2;
        ByteBuffer byteBuffer = ((ByteBufferReference)object).get();
        if (byteBuffer.capacity() < this.engine.getSession().getPacketBufferSize()) {
            object2 = this.getNetBuffer();
            ByteBuffer byteBuffer2 = ((ByteBufferReference)object2).get();
            byteBuffer2.put(byteBuffer);
            byteBuffer = byteBuffer2;
            ((ByteBufferReference)object).clear();
            object = object2;
        } else {
            byteBuffer.compact();
        }
        object2 = byteBufferReference.get();
        Utils.copy((ByteBuffer)object2, byteBuffer, Math.min(byteBuffer.remaining(), ((Buffer)object2).remaining()));
        byteBuffer.flip();
        return object;
    }

    ByteBufferReference combine(ByteBufferReference byteBufferReference, ByteBufferReference byteBufferReference2) {
        ByteBuffer byteBuffer = byteBufferReference.get();
        ByteBuffer byteBuffer2 = byteBufferReference2.get();
        int n = byteBuffer.capacity() - byteBuffer.remaining();
        if (byteBuffer2.remaining() < n) {
            byteBuffer.compact();
            byteBuffer.put(byteBuffer2);
            byteBuffer.flip();
            byteBufferReference2.clear();
            return byteBufferReference;
        }
        int n2 = byteBuffer.remaining() + byteBuffer2.remaining();
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(n2);
        byteBuffer3.put(byteBuffer);
        byteBuffer3.put(byteBuffer2);
        byteBuffer3.flip();
        byteBufferReference.clear();
        byteBufferReference2.clear();
        return ByteBufferReference.of(byteBuffer3);
    }

    SSLParameters getSSLParameters() {
        return this.sslParameters;
    }

    static void logParams(SSLParameters sSLParameters) {
        if (!Log.ssl()) {
            return;
        }
        if (sSLParameters == null) {
            Log.logSSL("SSLParameters: Null params", new Object[0]);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("SSLParameters:");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (sSLParameters.getCipherSuites() != null) {
            for (String object : sSLParameters.getCipherSuites()) {
                stringBuilder.append("\n    cipher: {").append(arrayList.size()).append("}");
                arrayList.add(object);
            }
        }
        if (sSLParameters.getProtocols() != null) {
            for (String string : sSLParameters.getProtocols()) {
                stringBuilder.append("\n    protocol: {").append(arrayList.size()).append("}");
                arrayList.add(string);
            }
        }
        if (sSLParameters.getServerNames() != null) {
            for (SNIServerName sNIServerName : sSLParameters.getServerNames()) {
                stringBuilder.append("\n    server name: {").append(arrayList.size()).append("}");
                arrayList.add(sNIServerName.toString());
            }
        }
        stringBuilder.append('\n');
        Log.logSSL(stringBuilder.toString(), arrayList.toArray());
    }

    String getSessionInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "foo";
        SSLSession sSLSession = this.engine.getSession();
        String string2 = sSLSession.getCipherSuite();
        String string3 = sSLSession.getProtocol();
        stringBuilder.append("Handshake complete alpn: ").append(string).append(", Cipher: ").append(string2).append(", Protocol: ").append(string3);
        return stringBuilder.toString();
    }

    static class EngineResult {
        final SSLEngineResult result;
        final ByteBufferReference destBuffer;

        EngineResult(SSLEngineResult sSLEngineResult) {
            this(sSLEngineResult, null);
        }

        EngineResult(SSLEngineResult sSLEngineResult, ByteBufferReference byteBufferReference) {
            this.result = sSLEngineResult;
            this.destBuffer = byteBufferReference;
        }

        boolean handshaking() {
            SSLEngineResult.HandshakeStatus handshakeStatus = this.result.getHandshakeStatus();
            return handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }

        int bytesConsumed() {
            return this.result.bytesConsumed();
        }

        int bytesProduced() {
            return this.result.bytesProduced();
        }

        SSLEngineResult.HandshakeStatus handshakeStatus() {
            return this.result.getHandshakeStatus();
        }

        SSLEngineResult.Status status() {
            return this.result.getStatus();
        }
    }
}

