/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLServerSocketFactory;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.MOSTLY_THREADSAFE)
final class SetEnabledProtocolsSSLServerSocketFactory
extends SSLServerSocketFactory {
    private final Set<String> protocols;
    private final SSLServerSocketFactory delegateFactory;

    SetEnabledProtocolsSSLServerSocketFactory(SSLServerSocketFactory delegateFactory, String defaultProtocol) {
        this.delegateFactory = delegateFactory;
        this.protocols = defaultProtocol.equalsIgnoreCase("TLSv1.2") ? new HashSet<String>(Arrays.asList("TLSv1.2", "TLSv1.1", "TLSv1")) : (defaultProtocol.equalsIgnoreCase("TLSv1.1") ? new HashSet<String>(Arrays.asList("TLSv1.1", "TLSv1")) : (defaultProtocol.equalsIgnoreCase("TLSv1") ? new HashSet<String>(Collections.singletonList("TLSv1")) : Collections.emptySet()));
    }

    SetEnabledProtocolsSSLServerSocketFactory(SSLServerSocketFactory delegateFactory, Set<String> protocols) {
        this.delegateFactory = delegateFactory;
        this.protocols = protocols;
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        ServerSocket serverSocket = this.delegateFactory.createServerSocket();
        SSLUtil.applyEnabledSSLProtocols(serverSocket, this.protocols);
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket serverSocket = this.delegateFactory.createServerSocket(port);
        SSLUtil.applyEnabledSSLProtocols(serverSocket, this.protocols);
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        ServerSocket serverSocket = this.delegateFactory.createServerSocket(port, backlog);
        SSLUtil.applyEnabledSSLProtocols(serverSocket, this.protocols);
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        ServerSocket serverSocket = this.delegateFactory.createServerSocket(port, backlog, ifAddress);
        SSLUtil.applyEnabledSSLProtocols(serverSocket, this.protocols);
        return serverSocket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegateFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegateFactory.getSupportedCipherSuites();
    }
}

