/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._byte.minexclusive.minexclusive_1;

import jakarta.xml.bind.*;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class minExclusive1_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        minExclusive1_GetSetCTTests test = new minExclusive1_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "minExclusive-1-1.xml", "minExclusive-1-2.xml", "minExclusive-1-3.xml",
            "minExclusive-1-4.xml", "minExclusive-1-5.xml"
        };
        byte[] expectedValues = {(byte)-127, (byte)82, (byte)-68, (byte)122, (byte)127};
        byte[] anExpectedValues = {(byte)-126, (byte)-54, (byte)72, (byte)0, (byte)126};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<Byte> elemObj = (JAXBElement<Byte>)unmarshal(xmlDocNames[i]);
            if (elemObj.getValue() != expectedValues[i]){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (elemObj.getValue() != anExpectedValues[i]){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        byte[] setValues = {(byte)-127, (byte)82, (byte)-68, (byte)0, (byte)127};
        byte[] anSetValues = {(byte)-126, (byte)-54, (byte)72, (byte)1, (byte)126};
        JAXBElement<Byte> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<Byte>)(new ObjectFactory()).createNISTSchemaByteMinExclusive1(setValues[i]);
            
            if (elemObj.getValue() != setValues[i]){
                return Status.failed("dynamically created JAXBElement<Byte>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (elemObj.getValue() != anSetValues[i]){
                return Status.failed("dynamically created JAXBElement<Byte>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

