/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.common.schema30;

import com.sun.ts.tests.jpa.common.schema30.Address;
import com.sun.ts.tests.jpa.common.schema30.Alias;
import com.sun.ts.tests.jpa.common.schema30.Country;
import com.sun.ts.tests.jpa.common.schema30.CreditCard;
import com.sun.ts.tests.jpa.common.schema30.Order;
import com.sun.ts.tests.jpa.common.schema30.Spouse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="CUSTOMER_TABLE")
public class Customer
implements Serializable {
    private String id;
    private String name;
    private Address home;
    private Address work;
    private Country country;
    private Spouse spouse;
    private Collection<CreditCard> creditCards = new ArrayList<CreditCard>();
    private Collection<Order> orders = new ArrayList<Order>();
    private Collection<Alias> aliases = new ArrayList<Alias>();
    private Collection<Alias> aliasesNoop = new ArrayList<Alias>();
    private Set<Order> orders2 = new HashSet<Order>();
    private List<Order> orders3 = new ArrayList<Order>();

    public Customer() {
    }

    public Customer(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public Customer(String id, String name, Country country) {
        this.id = id;
        this.name = name;
        this.country = country;
    }

    public Customer(String id, String name, Country country, Address work) {
        this.id = id;
        this.name = name;
        this.country = country;
        this.work = work;
    }

    public Customer(String id, String name, Address home, Address work, Country country) {
        this.id = id;
        this.name = name;
        this.home = home;
        this.work = work;
        this.country = country;
    }

    @Id
    @Column(name="ID")
    public String getId() {
        return this.id;
    }

    public void setId(String v) {
        this.id = v;
    }

    @Column(name="NAME")
    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
    }

    @Embedded
    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country v) {
        this.country = v;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="FK6_FOR_CUSTOMER_TABLE")
    public Address getHome() {
        return this.home;
    }

    public void setHome(Address v) {
        this.home = v;
    }

    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="FK5_FOR_CUSTOMER_TABLE")
    public Address getWork() {
        return this.work;
    }

    public void setWork(Address v) {
        this.work = v;
    }

    @OneToOne(cascade={CascadeType.ALL}, mappedBy="customer")
    public Spouse getSpouse() {
        return this.spouse;
    }

    public void setSpouse(Spouse v) {
        this.spouse = v;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="customer")
    public Collection<CreditCard> getCreditCards() {
        return this.creditCards;
    }

    public void setCreditCards(Collection<CreditCard> v) {
        this.creditCards = v;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="customer")
    public Collection<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(Collection<Order> v) {
        this.orders = v;
    }

    @ManyToMany(cascade={CascadeType.ALL}, mappedBy="customers")
    public Collection<Alias> getAliases() {
        return this.aliases;
    }

    public void setAliases(Collection<Alias> v) {
        this.aliases = v;
    }

    @ManyToMany(cascade={CascadeType.ALL}, mappedBy="customersNoop")
    public Collection<Alias> getAliasesNoop() {
        return this.aliasesNoop;
    }

    public void setAliasesNoop(Collection<Alias> v) {
        this.aliasesNoop = v;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="customer")
    public Set<Order> getOrders2() {
        return this.orders2;
    }

    public void setOrders2(Set<Order> v) {
        this.orders2 = v;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="customer")
    public List<Order> getOrders3() {
        return this.orders3;
    }

    public void setOrders3(List<Order> v) {
        this.orders3 = v;
    }

    public boolean equals(Object o) {
        boolean same = true;
        if (!(o instanceof Customer)) {
            return false;
        }
        Customer other = (Customer)o;
        return same &= this.id.equals(other.id);
    }

    public int hashCode() {
        int myHash = this.id.hashCode();
        return myHash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + this.getId());
        result.append(",  name: " + this.getName());
        if (this.getHome() != null) {
            result.append(", home: " + this.getHome().getId());
        } else {
            result.append(", home: null");
        }
        if (this.getWork() != null) {
            result.append(", work: " + this.getWork().getId());
        } else {
            result.append(", work: null");
        }
        if (this.getSpouse() != null) {
            result.append(", spouse: " + this.getSpouse());
        } else {
            result.append(", spouse: null");
        }
        if (this.getCountry() != null) {
            result.append(", country: " + this.getCountry());
        } else {
            result.append(", country: null");
        }
        result.append("]");
        return result.toString();
    }
}

