/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.MethodOverridingChecker;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.plugin.Filter;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassHierarchyImpl
implements ClassHierarchy {
    private static String[] EMPTY_STRING_ARRAY;
    private ClassDescriptionLoader loader;
    private int trackMode;
    private Filter defaultFilter = new DefaultIsAccessibleFilter();
    private Pattern anonimouse = Pattern.compile("\\$\\d+$");
    private static Pattern simpleParamUsage;
    private Map directSubClasses = new HashMap();
    private HashMap processedClasses = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$core$ClassHierarchyImpl;

    public ClassHierarchyImpl(ClassDescriptionLoader loader, int trackMode) {
        this.loader = loader;
        this.trackMode = trackMode;
    }

    public String getSuperClass(String fqClassName) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqClassName);
        return info.superClass;
    }

    public List getSuperClasses(String fqClassName) throws ClassNotFoundException {
        ArrayList superclasses = new ArrayList();
        this.findSuperclasses(fqClassName, superclasses);
        return superclasses;
    }

    public String[] getSuperInterfaces(String fqClassName) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqClassName);
        return info.superInterfaces;
    }

    public Set getAllImplementedInterfaces(String fqClassName) throws ClassNotFoundException {
        HashSet intfs = new HashSet();
        this.findAllImplementedInterfaces(fqClassName, intfs);
        return intfs;
    }

    private void findSuperclasses(String fqname, List supers) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqname);
        String supr = info.superClass;
        if (supr != null) {
            supers.add(supr);
            this.findSuperclasses(supr, supers);
        }
    }

    private void findAllImplementedInterfaces(String fqname, Set implementedInterfaces) throws ClassNotFoundException {
        ArrayList<String> superClasses = new ArrayList<String>();
        ClassInfo info = this.getClassInfo(fqname);
        String[] intfs = info.superInterfaces;
        int j = 0;
        while (j < intfs.length) {
            implementedInterfaces.add(intfs[j]);
            superClasses.add(intfs[j]);
            ++j;
        }
        this.findSuperclasses(fqname, superClasses);
        int i = 0;
        while (i < superClasses.size()) {
            this.findSuperInterfaces((String)superClasses.get(i), implementedInterfaces);
            ++i;
        }
    }

    private void findSuperInterfaces(String fqname, Set supers) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqname);
        String[] intf = info.superInterfaces;
        int i = 0;
        while (i < intf.length) {
            supers.add(intf[i]);
            this.findSuperInterfaces(intf[i], supers);
            ++i;
        }
    }

    public String[] getDirectSubclasses(String fqClassName) {
        String[] result = EMPTY_STRING_ARRAY;
        List subClasses = (List)this.directSubClasses.get(fqClassName);
        if (subClasses != null) {
            result = subClasses.toArray(EMPTY_STRING_ARRAY);
        }
        return result;
    }

    public String[] getAllSubclasses(String fqClassName) {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    public String[] getNestedClasses(String fqClassName) {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    public boolean isSubclass(String subClassName, String superClassName) throws ClassNotFoundException {
        ClassInfo info;
        if (!($assertionsDisabled || subClassName != null && superClassName != null)) {
            throw new AssertionError();
        }
        String name = subClassName;
        do {
            info = this.getClassInfo(name);
            if (!superClassName.equals(info.superClass)) continue;
            return true;
        } while ((name = info.superClass) != null);
        return false;
    }

    public ClassDescription load(String name) throws ClassNotFoundException {
        return this.load(name, false);
    }

    public boolean isMethodOverriden(MethodDescr md) throws ClassNotFoundException {
        Erasurator erasurator = new Erasurator();
        MethodOverridingChecker moc = new MethodOverridingChecker(erasurator);
        List scs = this.getSuperClasses(md.getDeclaringClassName());
        Iterator it = scs.iterator();
        while (it.hasNext()) {
            ClassDescription sc = this.load((String)it.next());
            erasurator.erasure(sc);
            moc.addMethods(sc.getDeclaredMethods());
        }
        return moc.getOverridingMethod(md, false) != null;
    }

    public boolean isMethodImplements(MethodDescr md) throws ClassNotFoundException {
        Erasurator erasurator = new Erasurator();
        MethodOverridingChecker moc = new MethodOverridingChecker(erasurator);
        Set scs = this.getAllImplementedInterfaces(md.getDeclaringClassName());
        Iterator it = scs.iterator();
        String name = md.getName();
        while (it.hasNext()) {
            ClassDescription sc = this.load((String)it.next());
            erasurator.erasure(sc);
            moc.addMethods(sc.getDeclaredMethods(), name);
        }
        if (moc.getOverridingMethod(md, false) != null) {
            return true;
        }
        return this.isAnonimouse(md.getDeclaringClassName());
    }

    private boolean isAnonimouse(String clName) {
        boolean ret = this.anonimouse.matcher(clName).find();
        return ret;
    }

    private ClassDescription load(String name, boolean no_cache) throws ClassNotFoundException {
        while (name.indexOf(60) != -1 && name.indexOf(62) != -1) {
            Matcher m = simpleParamUsage.matcher(name);
            name = m.replaceAll("");
        }
        ClassDescription c = this.loader.load(name);
        Transformer t = PluginAPI.ON_CLASS_LOAD.getTransformer();
        if (t != null) {
            t.transform(c);
        }
        if (!no_cache) {
            this.getClassInfo(name);
        }
        c.setHierarchy(this);
        return c;
    }

    public boolean isAccessible(ClassDescription c) {
        return this.isAccessible(c, false);
    }

    public boolean isDocumentedAnnotation(String fqname) throws ClassNotFoundException {
        ClassInfo info = (ClassInfo)this.processedClasses.get(fqname);
        if (info != null) {
            return info.isDocumentedAnnotation;
        }
        ClassDescription c = this.load(fqname);
        return c.isDocumentedAnnotation();
    }

    public boolean isContainerAnnotation(String fqname) throws ClassNotFoundException {
        ClassDescription c = this.load(fqname);
        try {
            if (c.hasModifier(Modifier.ANNOTATION)) {
                MethodDescr[] mds = c.getDeclaredMethods();
                String aType = null;
                int i = 0;
                while (i < mds.length) {
                    MethodDescr md = mds[i];
                    if (md.getName().equals("value") && "".equals(c.getArgs())) {
                        aType = md.getType();
                    } else if (!md.hasModifier(Modifier.HASDEFAULT)) {
                        return false;
                    }
                    ++i;
                }
                if (aType == null || !aType.endsWith("[]")) {
                    return false;
                }
                ClassDescription a = this.load(aType = aType.substring(0, aType.length() - 2));
                if (!a.hasModifier(Modifier.ANNOTATION)) {
                    return false;
                }
                AnnotationItem[] alist = a.getAnnoList();
                int i2 = 0;
                while (i2 < alist.length) {
                    if (alist[i2].getName().equals("java.lang.annotation.Repeatable")) {
                        return true;
                    }
                    ++i2;
                }
            }
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        return false;
    }

    public boolean isAccessible(String fqname) throws ClassNotFoundException {
        if (fqname == null) {
            throw new NullPointerException("Parameter fqname can't be null!");
        }
        ClassInfo info = (ClassInfo)this.processedClasses.get(fqname);
        if (info != null) {
            return info.accessable;
        }
        ClassDescription c = this.load(fqname);
        return this.isAccessible(c, false);
    }

    private boolean isAccessible(ClassDescription c, boolean no_cache) {
        ClassInfo info;
        if (!no_cache && (info = (ClassInfo)this.processedClasses.get(c.getQualifiedName())) != null) {
            return info.accessable;
        }
        if (c.isAnonymousClass()) {
            return false;
        }
        Filter f = PluginAPI.IS_CLASS_ACCESSIBLE.getFilter();
        if (f == null) {
            f = this.defaultFilter;
        }
        return f.accept(c);
    }

    public boolean isClassVisibleOutside(String fqClassName) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqClassName);
        return info.isVisibleOutside;
    }

    public boolean isClassVisibleOutside(ClassDescription cls) throws ClassNotFoundException {
        boolean visible;
        boolean bl = visible = cls.hasModifier(Modifier.PUBLIC) || cls.hasModifier(Modifier.PROTECTED);
        if (visible && !cls.isTopClass()) {
            visible = this.isClassVisibleOutside(cls.getDeclaringClassName());
        }
        return visible;
    }

    public boolean isInterface(String fqClassName) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqClassName);
        return Modifier.hasModifier(info.modifiers, Modifier.INTERFACE);
    }

    public boolean isAnnotation(String fqClassName) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqClassName);
        return Modifier.hasModifier(info.modifiers, Modifier.ANNOTATION);
    }

    public int getClassModifiers(String fqClassName) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqClassName);
        return info.modifiers;
    }

    private ClassInfo getClassInfo(String fqname) throws ClassNotFoundException {
        ClassInfo info = (ClassInfo)this.processedClasses.get(fqname);
        if (info == null) {
            ClassDescription c = this.load(fqname, true);
            info = new ClassInfo(c, this.isAccessible(c, true), this.isClassVisibleOutside(c));
            if (info.superClass != null) {
                this.addSubClass(info.superClass, fqname);
            }
            if (info.superInterfaces != null && info.superInterfaces.length > 0) {
                int i = 0;
                while (i < info.superInterfaces.length) {
                    this.addSubClass(info.superInterfaces[i], fqname);
                    ++i;
                }
            }
            this.processedClasses.put(fqname, info);
        }
        return info;
    }

    private void addSubClass(String superClass, String subClass) {
        ArrayList<String> subClasses = (ArrayList<String>)this.directSubClasses.get(superClass);
        if (subClasses == null) {
            subClasses = new ArrayList<String>(3);
            this.directSubClasses.put(superClass, subClasses);
        }
        subClasses.add(subClass);
    }

    public int getTrackMode() {
        return this.trackMode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$tdk$signaturetest$core$ClassHierarchyImpl == null ? (class$com$sun$tdk$signaturetest$core$ClassHierarchyImpl = ClassHierarchyImpl.class$("com.sun.tdk.signaturetest.core.ClassHierarchyImpl")) : class$com$sun$tdk$signaturetest$core$ClassHierarchyImpl).desiredAssertionStatus();
        EMPTY_STRING_ARRAY = new String[0];
        simpleParamUsage = Pattern.compile("<[^<>]+?>");
    }

    class DefaultIsAccessibleFilter
    implements Filter {
        DefaultIsAccessibleFilter() {
        }

        private boolean isAccessible(ClassDescription c) {
            boolean result;
            block4: {
                if (c.isPackageInfo()) {
                    return true;
                }
                if (ClassHierarchyImpl.this.trackMode == 2) {
                    return c.isPublic() || c.isProtected();
                }
                result = false;
                try {
                    result = c.getClassHierarchy().isClassVisibleOutside(c);
                }
                catch (ClassNotFoundException e) {
                    if (!SigTest.debug) break block4;
                    SwissKnife.reportThrowable(e);
                }
            }
            return result;
        }

        public boolean accept(ClassDescription cls) {
            return this.isAccessible(cls);
        }
    }

    private static class ClassInfo {
        private static final String[] EMPTY_INTERFACES = new String[0];
        String superClass = null;
        String[] superInterfaces = EMPTY_INTERFACES;
        boolean accessable = false;
        boolean isDocumentedAnnotation = false;
        int modifiers = 0;
        boolean isVisibleOutside;

        public ClassInfo(ClassDescription c, boolean accessable, boolean visible) {
            SuperInterface[] intfs;
            int len;
            this.modifiers = c.getModifiers();
            SuperClass sc = c.getSuperClass();
            if (sc != null) {
                this.superClass = sc.getQualifiedName();
            }
            if ((len = (intfs = c.getInterfaces()).length) > 0) {
                this.superInterfaces = new String[len];
                int i = 0;
                while (i < len) {
                    this.superInterfaces[i] = intfs[i].getQualifiedName();
                    ++i;
                }
            }
            this.accessable = accessable;
            this.isVisibleOutside = visible;
            this.isDocumentedAnnotation = c.isDocumentedAnnotation();
        }
    }
}

