/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.util;

import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BatchFileParser {
    private BatchFileParser() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] processParameters(String[] args) throws CommandLineParserException {
        int filePos = -1;
        if (args == null) {
            return args;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i] != null && args[i].startsWith("@")) {
                filePos = i;
                break;
            }
            ++i;
        }
        if (filePos == -1) {
            return args;
        }
        String fName = args[filePos].substring(1).trim();
        LineNumberReader r = null;
        try {
            try {
                r = new LineNumberReader(SwissKnife.approveFileReader(fName));
                Properties props = new Properties();
                ArrayList<String> options = new ArrayList<String>();
                if (filePos > 0) {
                    options.addAll(Arrays.asList(args).subList(0, filePos));
                }
                Pattern setPattern = Pattern.compile("Set\\s+(.+)=(.+)", 2);
                Pattern nameAndValue = Pattern.compile("(.+)=(.+)");
                Pattern nameOnly = Pattern.compile("([^=]+)");
                while (true) {
                    void var5_11;
                    String currLine;
                    if ((currLine = r.readLine()) == null) break;
                    currLine = var5_11.trim();
                    Matcher m = setPattern.matcher(currLine);
                    if (currLine.startsWith("#") || "".equals(currLine)) continue;
                    if (m.find()) {
                        props.put(m.group(1), m.group(2));
                        continue;
                    }
                    Matcher nv = nameAndValue.matcher(currLine);
                    if (nv.find()) {
                        String name = nv.group(1).trim();
                        String val = nv.group(2).trim();
                        if (!name.startsWith("-")) {
                            name = "-" + name;
                        }
                        options.add(name);
                        options.add(val);
                        continue;
                    }
                    Matcher no = nameOnly.matcher(currLine);
                    if (!no.find()) continue;
                    String name = no.group(1).trim();
                    if (!name.startsWith("-")) {
                        name = "-" + name;
                    }
                    options.add(name);
                }
                options.addAll(Arrays.asList(args).subList(filePos + 1, args.length));
                BatchFileParser.resolveParams(options, props);
                String[] stringArray = options.toArray(new String[0]);
                Object var16_17 = null;
                try {
                    if (r == null) return stringArray;
                    r.close();
                    return stringArray;
                }
                catch (IOException ex) {
                    SwissKnife.reportThrowable(ex);
                }
                return stringArray;
            }
            catch (FileNotFoundException ex) {
                throw new CommandLineParserException("File " + fName + " not found", ex);
            }
            catch (IOException ex) {
                throw new CommandLineParserException("Can't read file " + fName, ex);
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            try {}
            catch (IOException ex) {
                SwissKnife.reportThrowable(ex);
                throw throwable;
            }
            if (r == null) throw throwable;
            r.close();
            throw throwable;
        }
    }

    private static void resolveParams(ArrayList options, Properties props) throws CommandLineParserException {
        boolean resolved;
        boolean subst;
        Pattern macro = Pattern.compile("(\\$\\{(.+?)\\})");
        do {
            subst = false;
            resolved = true;
            Iterator<Object> keys = props.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = props.getProperty(key);
                Matcher m = macro.matcher(val);
                if (!m.find()) continue;
                subst = true;
                String keyToFind = m.group(2);
                String newVal = props.getProperty(keyToFind);
                if (macro.matcher(newVal).find()) {
                    resolved = false;
                    continue;
                }
                if (newVal != null) {
                    val = m.replaceFirst(newVal);
                    props.put(key, val);
                    if (!macro.matcher(val).find()) continue;
                    resolved = false;
                    continue;
                }
                throw new CommandLineParserException("Can't resolve ${" + keyToFind + "} property");
            }
        } while (subst && !resolved);
        int i = 0;
        while (i < options.size()) {
            String o = (String)options.get(i);
            Matcher m = macro.matcher(o);
            if (m.find()) {
                String newVal = props.getProperty(m.group(2));
                if (newVal != null) {
                    options.set(i, newVal);
                } else {
                    throw new CommandLineParserException("Can't resolve " + o + " property");
                }
            }
            ++i;
        }
    }
}

