/*
 * Copyright (c) 2013, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.concurrency.common.counter;

import java.io.PrintWriter;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.sun.ts.tests.concurrency.common.*;

public class CounterServlet extends HttpServlet {

    public void doGet(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {
        doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res)
           throws ServletException, IOException {
        PrintWriter out = null;

        try {
            res.setContentType("text/plain");
            out = res.getWriter();

            String opName = req.getParameter(ConcurrencyTestUtils.SERVLET_OP_ATTR_NAME);
            if (ConcurrencyTestUtils.SERVLET_OP_COUNTER_GETCOUNT.equals(opName)) {
                out.println(StaticCounter.getCount());
            } else if (ConcurrencyTestUtils.SERVLET_OP_COUNTER_INC.equals(opName)) {
                StaticCounter.inc();
                out.println(ConcurrencyTestUtils.SERVLET_RETURN_SUCCESS);
            } else if (ConcurrencyTestUtils.SERVLET_OP_COUNTER_RESET.equals(opName)) {
                StaticCounter.reset();
                out.println(ConcurrencyTestUtils.SERVLET_RETURN_SUCCESS);
            } else {
                setupTest(req, res);
                doTest(req, res);
            }
        } catch (Exception e) {
            if (out != null) {
                out.println(ConcurrencyTestUtils.SERVLET_RETURN_FAIL);
                out.println(e);
            }
        } finally { 
            if (null != out) {
                out.close();
            }
        }
    }

    protected void doTest(HttpServletRequest req, HttpServletResponse res) throws Exception {
    }

    protected void setupTest(HttpServletRequest req, HttpServletResponse res) throws Exception {
    }

}
